/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.core.model.ims;

import com.ibm.etools.fm.core.model.ims.ImsSegment;
import java.util.Objects;

public class ImsKeyField {
    private final ImsSegment segment;
    private final String name;
    private String pos;
    private int length;
    private ImsKeyFieldType type;

    public ImsKeyField(ImsSegment segment, String name) {
        this.segment = Objects.requireNonNull(segment, "Must provide a non-null segment");
        this.name = Objects.requireNonNull(name, "Must provide a non-null name");
    }

    public boolean equals(Object o) {
        if (!(o instanceof ImsKeyField)) {
            return false;
        }
        ImsKeyField other = (ImsKeyField)o;
        return this.name.equals(other.name) && this.segment.equals(other.segment);
    }

    public int hashCode() {
        int result = 37;
        result = 37 * result + this.name.hashCode();
        result = 37 * result + this.segment.hashCode();
        return result;
    }

    public String getPos() {
        return this.pos;
    }

    public void setPos(String pos) {
        this.pos = pos;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public ImsKeyFieldType getType() {
        return this.type;
    }

    public void setType(ImsKeyFieldType type) {
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public static enum ImsKeyFieldType {
        Hex("H"),
        Packed("P"),
        Binary("B"),
        Character("C");

        private final String ldbdRep;

        public static final ImsKeyFieldType parseFromLdbdRep(String ldbdRep) {
            ImsKeyFieldType[] imsKeyFieldTypeArray = ImsKeyFieldType.values();
            int n = imsKeyFieldTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ImsKeyFieldType type = imsKeyFieldTypeArray[n2];
                if (type.ldbdRep.equals(ldbdRep)) {
                    return type;
                }
                ++n2;
            }
            throw new IllegalArgumentException(ldbdRep);
        }

        private ImsKeyFieldType(String ldbdRep) {
            this.ldbdRep = ldbdRep;
        }

        public String getLdbdRep() {
            return this.ldbdRep;
        }
    }
}

