/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.core.model.ims;

import com.ibm.etools.fm.core.model.DataSetOrMember;
import com.ibm.etools.fm.core.model.DummyMember;
import com.ibm.etools.fm.core.model.ims.ImsAccessMode;
import com.ibm.etools.fm.core.model.ims.ImsDatabase;
import com.ibm.etools.fm.core.model.ims.ImsPcb;
import com.ibm.etools.fm.core.model.ims.ImsRegionType;
import com.ibm.etools.fm.core.model.ims.ImsRegionTypeProvider;
import com.ibm.etools.fm.core.model.ims.ImsSubsystem;
import com.ibm.etools.fm.core.model.ims.ImsSubsystemProvider;
import com.ibm.etools.fm.jhost.core.model.FMHostJhost;
import com.ibm.pdtools.common.component.core.util.PDBidiFormat;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;

public class ImsEditorOptions
implements ImsSubsystemProvider,
ImsRegionTypeProvider {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final int EDIT_PROTOCOL_VERSION = 4;
    private IPDHost aHost;
    private ImsSubsystem aSubsystem;
    private IZRL imsResource;
    private DataSetOrMember aViewResource;
    private boolean useTemplate = false;
    private ImsRegionType regionType;
    private boolean editDliDatabaseDataSet = false;
    private ImsAccessMode accessMode;
    private boolean editSession = false;
    private ImsLog imsLog = ImsLog.KEEP;
    private String encoding;
    private String dbcsEncoding;
    private PDBidiFormat bidiFormat;
    private String secondaryIndexName;

    public ImsEditorOptions(IPDHost aHost, ImsSubsystem aSubsystem, IZRL imsResource, DataSetOrMember aViewResource) {
        if (aHost == null) {
            throw new IllegalArgumentException("Must provide a non-null aHost.");
        }
        this.aHost = aHost;
        this.aSubsystem = aSubsystem;
        this.imsResource = imsResource;
        this.aViewResource = aViewResource;
        this.useTemplate = false;
        this.regionType = ImsRegionType.BMP;
        this.accessMode = ImsAccessMode.DYNAMIC;
        this.editDliDatabaseDataSet = false;
        this.editSession = false;
        this.imsLog = ImsLog.KEEP;
        this.encoding = this.aHost.getCodePage();
        this.dbcsEncoding = "";
        this.bidiFormat = PDBidiFormat.parse((String)aHost.getBidiFormat());
        this.secondaryIndexName = "";
    }

    public static ImsSubsystem getSubsystem(IZRL aResource) {
        if (aResource instanceof ImsSubsystemProvider) {
            return ((ImsSubsystemProvider)aResource).getSubsystem();
        }
        return null;
    }

    public IPDHost getSystem() {
        return this.aHost;
    }

    @Override
    public ImsSubsystem getSubsystem() {
        return this.aSubsystem;
    }

    public void setSubsystem(ImsSubsystem aSubsystem) {
        this.aSubsystem = aSubsystem;
        this.imsResource = null;
    }

    public void setImsResource(IZRL imsResource) {
        this.imsResource = imsResource;
    }

    public IZRL getImsResource() {
        return this.imsResource;
    }

    public ImsDatabase getDatabase() {
        if (this.imsResource instanceof ImsDatabase) {
            return (ImsDatabase)this.imsResource;
        }
        if (this.imsResource instanceof ImsPcb) {
            return ((ImsPcb)this.imsResource).getDbd();
        }
        return null;
    }

    public ImsPcb getPcb() {
        if (this.imsResource instanceof ImsPcb) {
            return (ImsPcb)this.imsResource;
        }
        return null;
    }

    public DataSetOrMember getTemplate() {
        return this.aViewResource;
    }

    public void setTemplate(DataSetOrMember aTemplate) {
        this.aViewResource = aTemplate;
    }

    public boolean useTemplate() {
        return this.useTemplate;
    }

    public void setUseTemplate(boolean useTemplate) {
        this.useTemplate = useTemplate;
    }

    @Override
    public ImsRegionType getRegionType() {
        return this.regionType;
    }

    public void setRegionType(ImsRegionType regionType) {
        this.regionType = regionType;
    }

    public boolean editDliDatabaseDataSets() {
        return this.editDliDatabaseDataSet;
    }

    public void setEditDliDatabaseDatasets(boolean editDliDatabaseDataSet) {
        this.editDliDatabaseDataSet = editDliDatabaseDataSet;
    }

    public ImsAccessMode getAccessMode() {
        return this.accessMode;
    }

    public void setAccessMode(ImsAccessMode accessMode) {
        this.accessMode = accessMode;
    }

    public boolean isEditSession() {
        return this.editSession;
    }

    public void setEditSession(boolean editSession) {
        this.editSession = editSession;
    }

    public ImsLog getImsLog() {
        return this.imsLog;
    }

    public void setImsLog(ImsLog imsLog) {
        this.imsLog = imsLog;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setDbcsEncoding(String dbcsEncoding) {
        this.dbcsEncoding = dbcsEncoding;
    }

    public String getDbcsEncoding() {
        if (this.dbcsEncoding.isEmpty()) {
            return "cp930";
        }
        return this.dbcsEncoding;
    }

    public boolean isDbcsEcndoingValueSet() {
        return this.dbcsEncoding != null && !this.dbcsEncoding.trim().isEmpty();
    }

    public String getBidiFormat() {
        return this.bidiFormat.toString();
    }

    public PDBidiFormat getBidiFormatType() {
        return this.bidiFormat;
    }

    public String getDynamicPsbSecondaryIndexName() {
        return this.secondaryIndexName;
    }

    public void setDynamicPsbSecondaryIndexName(String secondaryIndexName) {
        this.secondaryIndexName = secondaryIndexName == null || secondaryIndexName.trim().isEmpty() ? "" : secondaryIndexName.trim().toUpperCase();
    }

    public ImsEditorOptions clone() {
        ImsEditorOptions aCopy = new ImsEditorOptions(this.aHost, this.aSubsystem, this.imsResource, this.aViewResource);
        aCopy.useTemplate = this.useTemplate;
        aCopy.regionType = this.regionType;
        aCopy.editDliDatabaseDataSet = this.editDliDatabaseDataSet;
        aCopy.accessMode = this.accessMode;
        aCopy.editSession = this.editSession;
        aCopy.imsLog = this.imsLog;
        aCopy.encoding = this.encoding;
        aCopy.dbcsEncoding = this.dbcsEncoding;
        aCopy.bidiFormat = this.bidiFormat;
        aCopy.secondaryIndexName = this.secondaryIndexName;
        return aCopy;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ImsEditorOptions)) {
            return false;
        }
        ImsEditorOptions other = (ImsEditorOptions)obj;
        if (!this.aHost.equals(other.aHost)) {
            return false;
        }
        if (this.aSubsystem != null ? !this.aSubsystem.equals(other.aSubsystem) : other.aSubsystem != null) {
            return false;
        }
        if (this.imsResource != null ? !this.imsResource.equals(other.imsResource) : other.imsResource != null) {
            return false;
        }
        if (this.aViewResource != null ? !this.aViewResource.equals(other.aViewResource) : other.aViewResource != null) {
            return false;
        }
        if (this.useTemplate != other.useTemplate) {
            return false;
        }
        if (this.regionType != other.regionType) {
            return false;
        }
        if (this.editDliDatabaseDataSet != other.editDliDatabaseDataSet) {
            return false;
        }
        if (this.accessMode != other.accessMode) {
            return false;
        }
        if (this.editSession != other.editSession) {
            return false;
        }
        if (this.imsLog != other.imsLog) {
            return false;
        }
        if (this.encoding == null ? other.encoding != null : !this.encoding.equals(other.encoding)) {
            return false;
        }
        if (this.dbcsEncoding == null ? other.dbcsEncoding != null : !this.dbcsEncoding.equals(other.dbcsEncoding)) {
            return false;
        }
        if (this.bidiFormat == null ? other.bidiFormat != null : !this.bidiFormat.equals(other.bidiFormat)) {
            return false;
        }
        return !(this.secondaryIndexName == null ? other.secondaryIndexName != null : !this.secondaryIndexName.equals(other.secondaryIndexName));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.imsResource == null ? 0 : this.imsResource.hashCode());
        result = 31 * result + (this.aViewResource == null ? 0 : this.aViewResource.hashCode());
        result = 31 * result + (this.useTemplate ? 0 : 1);
        result = 31 * result + this.regionType.hashCode();
        result = 31 * result + (this.editDliDatabaseDataSet ? 0 : 1);
        result = 31 * result + this.accessMode.hashCode();
        result = 31 * result + (this.editSession ? 1 : 0);
        result = 31 * result + this.imsLog.hashCode();
        result = 31 * result + (this.dbcsEncoding == null ? 0 : this.dbcsEncoding.hashCode());
        result = 31 * result + (this.encoding == null ? 0 : this.encoding.hashCode());
        result = 31 * result + (this.bidiFormat == null ? 0 : this.bidiFormat.hashCode());
        result = 31 * result + (this.secondaryIndexName == null ? 0 : this.secondaryIndexName.hashCode());
        return result;
    }

    public String toCommandString() {
        String cmd;
        String xmlVerstionTag;
        StringBuilder sb = new StringBuilder();
        if (this.editSession) {
            sb.append("IE ");
        } else {
            sb.append("IB ");
        }
        ImsSubsystem subsystem = this.getSubsystem();
        if (subsystem == null) {
            throw new IllegalStateException("subsystem can not be null.");
        }
        String subsystemID = subsystem.getSubsystemID();
        sb.append("IMSID=").append(subsystemID).append(",");
        if (this.accessMode == ImsAccessMode.DYNAMIC && this.getDatabase() != null) {
            sb.append("DBDMEM=").append(this.getDatabase().getName()).append(",");
        } else if (this.getPcb() != null) {
            ImsPcb aPcb = this.getPcb();
            ImsDatabase dbd = aPcb.getDbd();
            if (dbd != null) {
                sb.append("DBDMEM=").append(dbd.getName()).append(",");
            }
            sb.append("PSBMEM=").append(aPcb.getPsb().getName()).append(",");
            sb.append("PCBNUM=").append(aPcb.getIndex()).append(",");
        }
        if (this.accessMode == ImsAccessMode.DYNAMIC) {
            sb.append("PSBTYPE=DYNAMIC,");
        } else {
            sb.append("PSBTYPE=STATIC,");
        }
        if (this.regionType == ImsRegionType.BMP) {
            sb.append("REGNTYPE=BMP,");
        } else {
            sb.append("REGNTYPE=DLI,");
        }
        if (this.useTemplate()) {
            sb.append("VIEW=T,");
        } else if (this.aViewResource == null || this.aViewResource instanceof DummyMember) {
            sb.append("VIEW=N,");
        } else {
            sb.append("VIEW=Y,");
            sb.append("VIEWDSN=").append(this.aViewResource.getFormattedName()).append(",");
        }
        if (this.getAccessMode() == ImsAccessMode.DYNAMIC && this.getDynamicPsbSecondaryIndexName().length() > 0) {
            sb.append("SECINDEX=").append(this.getDynamicPsbSecondaryIndexName()).append(",");
        }
        if (this.imsResource == null) {
            throw new IllegalStateException("imsResource can not be null");
        }
        if (this.imsResource != null && !(xmlVerstionTag = FMHostJhost.getXmlVersionTag((IPDHost)this.imsResource.getSystem())).isEmpty()) {
            sb.append(xmlVerstionTag);
        }
        if ((cmd = sb.toString().trim()).charAt(cmd.length() - 1) == ',') {
            cmd = cmd.substring(0, cmd.length() - 1);
        }
        return cmd;
    }

    public static enum ImsLog {
        KEEP,
        DELETE,
        NONE;

    }
}

