/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.core.model.ims;

import com.ibm.etools.fm.core.model.DataSet;
import com.ibm.etools.fm.core.model.Member;
import com.ibm.etools.fm.core.model.ims.ImsRegionConfig;
import com.ibm.etools.fm.core.model.ims.ImsRegionType;
import com.ibm.etools.fm.core.model.ims.ImsSubsystemConfig;
import com.ibm.pdtools.common.component.jhost.registery.EListener;
import com.ibm.pdtools.common.component.jhost.registery.EntityEvent;
import com.ibm.pdtools.common.component.jhost.registery.EntityEventDispatcher;
import com.ibm.pdtools.common.component.jhost.registery.IEntityEventDispatcher;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class ImsDliRegionConfig
extends ImsRegionConfig
implements IEntityEventDispatcher<ImsDliRegionConfig> {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    public static final int MAX_RES_LIBS = 6;
    public static final String DYNB = "dynb";
    public static final String DBRC = "dbrc";
    public static final String IRLM = "irlm";
    public static final String IMSLOGUSAGE = "logusage";
    public static final String IRLM_NAME = "irlmname";
    public static final String GSG_NAME = "gsgname";
    public static final String TMI_NAME = "tminame";
    public static final String BUF = "buf";
    public static final int BUF_MIN = 1;
    public static final int BUF_MAX = 999;
    public static final String DYN_DD = "dyndd";
    private Member dfsvsamp = null;
    private boolean dfsvsampUpdateable = false;
    private List<DataSet> resLibs = new ArrayList<DataSet>();
    private boolean resLibsUpdateable = false;
    private DataSet imsMacroLib = null;
    private boolean imsMacroLibUpdateable = false;
    private DataSet reconPrimary;
    private DataSet reconSecondary;
    private DataSet reconSpare;
    private boolean reconUpdate = false;
    private DataSet acbLib = null;
    private boolean acbLibUpdateable = false;
    private String imsLogDsn = null;
    private boolean imsLogLibUpdateable = false;
    private boolean imsLogUsageUpdateable = false;
    private final EntityEventDispatcher<ImsDliRegionConfig> eventDispatcher = new EntityEventDispatcher((Object)this);

    public ImsDliRegionConfig(ImsSubsystemConfig subsystem) {
        super(subsystem, ImsRegionType.DLI);
    }

    public ImsDliRegionConfig(ImsDliRegionConfig config) {
        this(config.getSubsystemConfig());
        this.copyFrom(config);
        this.setDfsvsamp(config.dfsvsamp);
        this.setDfsvsampUpdateable(config.dfsvsampUpdateable);
        this.setResLibs(config.resLibs);
        this.setResLibsUpdateable(config.resLibsUpdateable);
        this.setImsMacroLib(config.imsMacroLib);
        this.setImsMacroLibUpdateable(config.imsMacroLibUpdateable);
        this.setReconPrimary(config.reconPrimary);
        this.setReconSecondary(config.reconSecondary);
        this.setReconSpare(config.reconSpare);
        this.setReconUpdateable(config.reconUpdate);
        this.setAcbLib(config.acbLib);
        this.setAcbLibUpdateable(config.acbLibUpdateable);
        this.setImsLogLib(config.imsLogDsn);
        this.setImsLogLibUpdateable(config.imsLogLibUpdateable);
        this.setImsLogUsageUpdateable(config.imsLogUsageUpdateable);
    }

    @Override
    public String getRegionTypeLabel() {
        return "DLI";
    }

    @Override
    protected EntityEventDispatcher<? extends ImsRegionConfig> getEventDispatcher() {
        return this.eventDispatcher;
    }

    @Override
    public boolean isConnectable() {
        return this.getSubsystemConfig().isDliSupported();
    }

    @Override
    protected Set<String> getDefaultReadOnlySettings() {
        return Collections.singleton(DYN_DD);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.acbLib == null ? 0 : this.acbLib.hashCode());
        result = 31 * result + (this.acbLibUpdateable ? 1231 : 1237);
        result = 31 * result + (this.imsLogDsn == null ? 0 : this.imsLogDsn.hashCode());
        result = 31 * result + (this.imsLogLibUpdateable ? 1231 : 1237);
        result = 31 * result + (this.imsLogUsageUpdateable ? 1231 : 1237);
        result = 31 * result + (this.dfsvsamp == null ? 0 : this.dfsvsamp.hashCode());
        result = 31 * result + (this.dfsvsampUpdateable ? 1231 : 1237);
        result = 31 * result + (this.imsMacroLib == null ? 0 : this.imsMacroLib.hashCode());
        result = 31 * result + (this.imsMacroLibUpdateable ? 1231 : 1237);
        result = 31 * result + (this.reconPrimary == null ? 0 : this.reconPrimary.hashCode());
        result = 31 * result + (this.reconSecondary == null ? 0 : this.reconSecondary.hashCode());
        result = 31 * result + (this.reconSpare == null ? 0 : this.reconSpare.hashCode());
        result = 31 * result + (this.reconUpdate ? 1231 : 1237);
        result = 31 * result + (this.resLibs == null ? 0 : this.resLibs.hashCode());
        result = 31 * result + (this.resLibsUpdateable ? 1231 : 1237);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof ImsDliRegionConfig)) {
            return false;
        }
        ImsDliRegionConfig other = (ImsDliRegionConfig)obj;
        if (this.acbLib == null ? other.acbLib != null : !this.acbLib.equals(other.acbLib)) {
            return false;
        }
        if (this.acbLibUpdateable != other.acbLibUpdateable) {
            return false;
        }
        if (this.imsLogDsn == null ? other.imsLogDsn != null : !this.imsLogDsn.equals(other.imsLogDsn)) {
            return false;
        }
        if (this.imsLogLibUpdateable != other.imsLogLibUpdateable) {
            return false;
        }
        if (this.imsLogUsageUpdateable != other.imsLogUsageUpdateable) {
            return false;
        }
        if (this.dfsvsamp == null ? other.dfsvsamp != null : !this.dfsvsamp.equals(other.dfsvsamp)) {
            return false;
        }
        if (this.dfsvsampUpdateable != other.dfsvsampUpdateable) {
            return false;
        }
        if (this.imsMacroLib == null ? other.imsMacroLib != null : !this.imsMacroLib.equals(other.imsMacroLib)) {
            return false;
        }
        if (this.imsMacroLibUpdateable != other.imsMacroLibUpdateable) {
            return false;
        }
        if (this.reconPrimary == null ? other.reconPrimary != null : !this.reconPrimary.equals(other.reconPrimary)) {
            return false;
        }
        if (this.reconSecondary == null ? other.reconSecondary != null : !this.reconSecondary.equals(other.reconSecondary)) {
            return false;
        }
        if (this.reconSpare == null ? other.reconSpare != null : !this.reconSpare.equals(other.reconSpare)) {
            return false;
        }
        if (this.reconUpdate != other.reconUpdate) {
            return false;
        }
        if (this.resLibs == null ? other.resLibs != null : !this.resLibs.equals(other.resLibs)) {
            return false;
        }
        return this.resLibsUpdateable == other.resLibsUpdateable;
    }

    public Member getDfsvsamp() {
        return this.dfsvsamp;
    }

    public void setDfsvsamp(Member dfsvsamp) {
        this.dfsvsamp = dfsvsamp;
        this.eventDispatcher.fireChangedEvent(PROPERTY_REGION_CONFIG);
    }

    public boolean isDfsvsampUpdateable() {
        return this.dfsvsampUpdateable;
    }

    public void setDfsvsampUpdateable(boolean dfsvsampUpdateability) {
        this.dfsvsampUpdateable = dfsvsampUpdateability;
        this.eventDispatcher.fireChangedEvent(PROPERTY_REGION_CONFIG);
    }

    public boolean isDynamicBackoutEnabled() {
        return "Y".equals(this.getSettingValue(DYNB));
    }

    public void setDynamicBackoutEnabled(boolean dynb) {
        this.setSettingValue(DYNB, dynb ? "Y" : "N");
    }

    public DefaultableBoolean isUsingDatabaseRecoveryControl() {
        return DefaultableBoolean.parse(this.getSettingValue(DBRC));
    }

    public void setUsingDatabaseRecoveryControl(DefaultableBoolean dbrc) {
        this.setSettingValue(DBRC, dbrc.getValue());
    }

    public static String getDbrcStr(DefaultableBoolean dbrc) {
        if (dbrc == DefaultableBoolean.YES) {
            return "Y";
        }
        if (dbrc == DefaultableBoolean.NO) {
            return "N";
        }
        return " ";
    }

    public DefaultableBoolean isUsingInternalResourceLockManager() {
        return DefaultableBoolean.parse(this.getSettingValue(IRLM));
    }

    public void setUsingInternalResourceLockManager(DefaultableBoolean irlm) {
        this.setSettingValue(IRLM, irlm.getValue());
    }

    public ImsSubsystemConfig.ImsLogUsage getImsLogUsage() {
        String value = this.getSettingValue(IMSLOGUSAGE);
        return value.equalsIgnoreCase("K") ? ImsSubsystemConfig.ImsLogUsage.KEEP : (value.equalsIgnoreCase("U") ? ImsSubsystemConfig.ImsLogUsage.KEEPWHENUPDATES : (value.equalsIgnoreCase("D") ? ImsSubsystemConfig.ImsLogUsage.DELETE : ImsSubsystemConfig.ImsLogUsage.NONE));
    }

    public String getImsLogUsageValue() {
        return this.getSettingValue(IMSLOGUSAGE);
    }

    public void setImsLogUsage(ImsSubsystemConfig.ImsLogUsage imsLogUsage) {
        this.setSettingValue(IMSLOGUSAGE, ImsDliRegionConfig.getImsLogUsageStr(imsLogUsage));
    }

    public static String getImsLogUsageStr(ImsSubsystemConfig.ImsLogUsage imsLogUsage) {
        return imsLogUsage == ImsSubsystemConfig.ImsLogUsage.KEEP ? "K" : (imsLogUsage == ImsSubsystemConfig.ImsLogUsage.KEEPWHENUPDATES ? "U" : (imsLogUsage == ImsSubsystemConfig.ImsLogUsage.DELETE ? "D" : "N"));
    }

    public String getInternalResourceLockManagerName() {
        return this.getSettingValue(IRLM_NAME);
    }

    public void setInternalResourceLockManagerName(String irlmName) {
        if (irlmName.length() > 4) {
            throw new IllegalArgumentException();
        }
        this.setSettingValue(IRLM_NAME, irlmName);
    }

    public String getGlobalServiceGroupName() {
        return this.getSettingValue(GSG_NAME);
    }

    public void setGlobalServiceGroupName(String gsgName) {
        if (gsgName.length() > 8) {
            throw new IllegalArgumentException();
        }
        this.setSettingValue(GSG_NAME, gsgName);
    }

    public String getTransportManagerInstanceName() {
        return this.getSettingValue(TMI_NAME);
    }

    public void setTransportManagerInstanceName(String tmiName) {
        if (tmiName.length() > 4) {
            throw new IllegalArgumentException();
        }
        this.setSettingValue(TMI_NAME, tmiName);
    }

    public String getBufferCount() {
        return this.getSettingValue(BUF);
    }

    public void setBufferCount(String buf) {
        this.ensureArgIsEmptyOrIntInRange(buf, 1, 999);
        this.setSettingValue(BUF, buf);
    }

    public boolean getDynamicAllocationUsedForDDs() {
        return "Y".equals(this.getSettingValue(DYN_DD));
    }

    public void setDynamicAllocationUsedForDDs(String dynDd) {
        this.setSettingValue(DYN_DD, dynDd);
    }

    public List<DataSet> getResLibs() {
        return Collections.unmodifiableList(this.resLibs);
    }

    public void setResLibs(List<DataSet> resLibs) {
        this.resLibs = new ArrayList<DataSet>(resLibs);
        this.eventDispatcher.fireChangedEvent(PROPERTY_REGION_CONFIG);
    }

    public boolean isResLibsUpdateable() {
        return this.resLibsUpdateable;
    }

    public void setResLibsUpdateable(boolean resLibsUpdateable) {
        this.resLibsUpdateable = resLibsUpdateable;
        this.eventDispatcher.fireChangedEvent(PROPERTY_REGION_CONFIG);
    }

    public DataSet getImsMacroLib() {
        return this.imsMacroLib;
    }

    public void setImsMacroLib(DataSet imsMacroLib) {
        this.imsMacroLib = imsMacroLib;
        this.eventDispatcher.fireChangedEvent(PROPERTY_REGION_CONFIG);
    }

    public boolean isImsMacroLibUpdateable() {
        return this.imsMacroLibUpdateable;
    }

    public void setImsMacroLibUpdateable(boolean imsMacroLibUpdateability) {
        this.imsMacroLibUpdateable = imsMacroLibUpdateability;
        this.eventDispatcher.fireChangedEvent(PROPERTY_REGION_CONFIG);
    }

    public DataSet getReconPrimary() {
        return this.reconPrimary;
    }

    public void setReconPrimary(DataSet reconPrimary) {
        this.reconPrimary = reconPrimary;
        this.eventDispatcher.fireChangedEvent(PROPERTY_REGION_CONFIG);
    }

    public DataSet getReconSecondary() {
        return this.reconSecondary;
    }

    public void setReconSecondary(DataSet reconSecondary) {
        this.reconSecondary = reconSecondary;
        this.eventDispatcher.fireChangedEvent(PROPERTY_REGION_CONFIG);
    }

    public DataSet getReconSpare() {
        return this.reconSpare;
    }

    public void setReconSpare(DataSet reconSpare) {
        this.reconSpare = reconSpare;
        this.eventDispatcher.fireChangedEvent(PROPERTY_REGION_CONFIG);
    }

    public boolean isReconUpdateable() {
        return this.reconUpdate;
    }

    public void setReconUpdateable(boolean reconUpdate) {
        this.reconUpdate = reconUpdate;
        this.eventDispatcher.fireChangedEvent(PROPERTY_REGION_CONFIG);
    }

    public DataSet getAcbLib() {
        return this.acbLib;
    }

    public void setAcbLib(DataSet acbLib) {
        this.acbLib = acbLib;
        this.eventDispatcher.fireChangedEvent(PROPERTY_REGION_CONFIG);
    }

    public boolean isAcbLibUpdateable() {
        return this.acbLibUpdateable;
    }

    public void setAcbLibUpdateable(boolean acbLibUpdateability) {
        this.acbLibUpdateable = acbLibUpdateability;
        this.eventDispatcher.fireChangedEvent(PROPERTY_REGION_CONFIG);
    }

    public String getImsLogLib() {
        return this.imsLogDsn;
    }

    public void setImsLogLib(String imsLogDsn) {
        this.imsLogDsn = imsLogDsn;
        this.eventDispatcher.fireChangedEvent(PROPERTY_REGION_CONFIG);
    }

    public boolean isImsLogLibUpdateable() {
        return this.imsLogLibUpdateable;
    }

    public void setImsLogLibUpdateable(boolean imsLogLibUpdateability) {
        this.imsLogLibUpdateable = imsLogLibUpdateability;
        this.eventDispatcher.fireChangedEvent(PROPERTY_REGION_CONFIG);
    }

    public boolean isImsLogUsageUpdateable() {
        return this.imsLogUsageUpdateable;
    }

    public void setImsLogUsageUpdateable(boolean imsLogUsageUpdateability) {
        this.imsLogUsageUpdateable = imsLogUsageUpdateability;
    }

    public void addListener(EListener<EntityEvent<ImsDliRegionConfig>> listener) {
        this.eventDispatcher.addListener(listener);
    }

    public void removeListener(EListener<EntityEvent<ImsDliRegionConfig>> listener) {
        this.eventDispatcher.removeListener(listener);
    }

    public static enum DefaultableBoolean {
        YES("Y"),
        NO("N"),
        DEFAULT("");

        private final String value;

        private DefaultableBoolean(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        private static DefaultableBoolean parse(String val) {
            if ("Y".equals(val)) {
                return YES;
            }
            if ("N".equals(val)) {
                return NO;
            }
            if ("".equals(val) || " ".equals(val)) {
                return DEFAULT;
            }
            throw new IllegalArgumentException(MessageFormat.format("[{0}]", val));
        }
    }
}

