/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.core.model.ims;

import com.ibm.etools.fm.core.model.ims.ImsDatabase;
import com.ibm.etools.fm.core.model.ims.ImsSecondaryIndex;
import com.ibm.etools.fm.core.model.ims.ImsSegment;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ImsDatabaseInfo {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private final List<ImsSegment> segments;
    private final List<ImsSecondaryIndex> secondaryIndexes;
    private final boolean halDb;
    private final ImsDatabase db;
    private final String dsn;

    public ImsDatabaseInfo(ImsDatabase db, String dsn, List<ImsSegment> segments, List<ImsSecondaryIndex> secondaryIndexes, boolean isHalDb) {
        if (db == null) {
            throw new IllegalArgumentException("Must specify a non-null ImsDatabase.");
        }
        if (dsn == null) {
            throw new IllegalArgumentException("Must specify a non-null dsn.");
        }
        this.db = db;
        this.dsn = dsn;
        this.segments = new ArrayList<ImsSegment>(segments);
        this.secondaryIndexes = new ArrayList<ImsSecondaryIndex>(secondaryIndexes);
        this.halDb = isHalDb;
    }

    public ImsDatabase getName() {
        return this.db;
    }

    public String getDsn() {
        return this.dsn;
    }

    public List<ImsSecondaryIndex> getSecondaryIndexes() {
        return Collections.unmodifiableList(this.secondaryIndexes);
    }

    public boolean isValidSecondaryIndexName(String secondaryIndexName) {
        List<ImsSecondaryIndex> indecies = this.getSecondaryIndexes();
        for (ImsSecondaryIndex anIndex : indecies) {
            if (!anIndex.getName().equals(secondaryIndexName)) continue;
            return true;
        }
        return false;
    }

    public List<ImsSegment> getSegments() {
        return Collections.unmodifiableList(this.segments);
    }

    public boolean isHalDb() {
        return this.halDb;
    }
}

