/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.core.model.ims;

import com.ibm.etools.fm.core.model.Member;
import com.ibm.etools.fm.core.model.ims.ImsDatabaseInfo;
import com.ibm.etools.fm.core.model.ims.ImsRegionType;
import com.ibm.etools.fm.core.model.ims.ImsRegionTypeProvider;
import com.ibm.etools.fm.core.model.ims.ImsSubsystem;
import com.ibm.etools.fm.core.model.ims.ImsSubsystemProvider;
import com.ibm.etools.fm.core.socket.func.UtilityFunctionRunner;
import com.ibm.etools.fm.core.socket.func.ims.LDBD;
import com.ibm.etools.fm.core.socket.func.ims.LDBDParser;
import com.ibm.pdtools.common.component.core.model.PDPlatformObject;
import com.ibm.pdtools.common.component.jhost.comms.HostType;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.regex.Pattern;

public class ImsDatabase
extends PDPlatformObject
implements ImsSubsystemProvider,
IZRL,
ImsRegionTypeProvider {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private final Properties resourceProperties = new Properties();
    private static final String IMS_DB_PREFIX = ":DB:";
    private static final Pattern parseableRegexp = Pattern.compile("^IMS:[A-Z0-9#$@]{1,4}:DB:[-!#$\ufffd&_=+{}a-zA-Z0-9@]{1,8}$");
    private final String name;
    private final ImsSubsystem subsystem;
    private final ImsRegionType regionType;
    private ImsDatabaseInfo info;

    public static boolean isValidName(String name, String codepage) {
        if (name == null) {
            return false;
        }
        return Member.isValidName(name, codepage);
    }

    public static boolean isParseableDatabase(String path, String codepage) {
        if (path == null) {
            return false;
        }
        String nameCheck = null;
        try {
            nameCheck = new String(path.getBytes(codepage), HostType.ZOS.getCommunicationEncoding());
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return parseableRegexp.matcher(nameCheck).matches();
    }

    public static ImsDatabase parseDatabase(IPDHost aHost, String path) {
        if (aHost == null) {
            throw new IllegalArgumentException("Please specify a non-null host.");
        }
        Objects.requireNonNull(path, "Must provide a non-null path.");
        if (!ImsDatabase.isParseableDatabase(path, aHost.getCodePage())) {
            throw new IllegalArgumentException(path);
        }
        try {
            StringTokenizer st = new StringTokenizer(path, ":");
            st.nextToken();
            String ssid = st.nextToken();
            st.nextToken();
            String dbName = st.nextToken();
            return new ImsDatabase(new ImsSubsystem(aHost, ssid), dbName);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(path);
        }
    }

    public ImsDatabase(ImsSubsystem subsystem, String name) {
        this(subsystem, name, ImsRegionType.BMP);
    }

    public ImsDatabase(ImsSubsystem subsystem, String name, ImsRegionType regionType) {
        Objects.requireNonNull(subsystem, "Must provide a non-null subsystem");
        if (!ImsDatabase.isValidName(name, subsystem.getSystem().getCodePage())) {
            throw new IllegalArgumentException("name='" + (name == null ? "null" : name) + "'");
        }
        this.subsystem = subsystem;
        this.name = name;
        this.regionType = regionType != null ? regionType : ImsRegionType.BMP;
    }

    @Override
    public ImsRegionType getRegionType() {
        return this.regionType;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return "ImsDatabase:name=" + this.name;
    }

    @Override
    public ImsSubsystem getSubsystem() {
        return this.subsystem;
    }

    public IPDHost getSystem() {
        return this.subsystem.getSystem();
    }

    public boolean equals(Object o) {
        if (!(o instanceof ImsDatabase)) {
            return false;
        }
        ImsDatabase other = (ImsDatabase)o;
        return this.name.equals(other.name) && this.subsystem.equals(other.subsystem);
    }

    public int hashCode() {
        int result = 37;
        result = result * 37 + this.name.hashCode();
        result = result * 37 + this.subsystem.hashCode();
        return result;
    }

    public Result<ImsDatabaseInfo> loadInfo(IHowIsGoing monitor, String function, ImsRegionType regionType) throws InterruptedException {
        if (this.info != null) {
            return new Result((Object)this.info);
        }
        LDBD lddb = new LDBD();
        lddb.setDatabase(this, regionType);
        lddb.setFunctionCode(this.getSubsystem().getSystem(), function);
        lddb.setConfig(this.getSubsystem().getCanonicalConfig());
        Result result = UtilityFunctionRunner.executeAndParse(this.getSubsystem().getSystem(), this.getSubsystem(), lddb, new LDBDParser(this), monitor);
        this.info = (ImsDatabaseInfo)result.getOutput();
        return result;
    }

    public String getPDImageName() {
        return "ims_database";
    }

    public String getPDLabel() {
        return this.getName();
    }

    public String getPDPluginId() {
        return "com.ibm.etools.fm.ui";
    }

    public String copyName() {
        return this.getPDLabel();
    }

    public String getFormattedName() {
        return this.getSubsystem().getFormattedName() + IMS_DB_PREFIX + this.name;
    }

    public String getPersistentProperty(String key) {
        return this.resourceProperties.getProperty(key);
    }

    public void setPersistentProperty(String key, String value) {
        this.resourceProperties.setProperty(key, value);
    }

    public ImsDatabase clone() {
        ImsDatabase copy = new ImsDatabase(this.subsystem, this.name);
        for (Map.Entry<Object, Object> entry : this.resourceProperties.entrySet()) {
            copy.setPersistentProperty(entry.getKey().toString(), entry.getValue().toString());
        }
        return copy;
    }
}

