/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.core.model.ims;

import com.ibm.etools.fm.core.model.ims.ImsRegionConfig;
import com.ibm.etools.fm.core.model.ims.ImsRegionType;
import com.ibm.etools.fm.core.model.ims.ImsSubsystemConfig;
import com.ibm.pdtools.common.component.jhost.registery.EListener;
import com.ibm.pdtools.common.component.jhost.registery.EntityEvent;
import com.ibm.pdtools.common.component.jhost.registery.EntityEventDispatcher;
import com.ibm.pdtools.common.component.jhost.registery.IEntityEventDispatcher;

public class ImsBmpRegionConfig
extends ImsRegionConfig
implements IEntityEventDispatcher<ImsBmpRegionConfig> {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    public static final String PARDLI = "pardli";
    public static final String NBA = "nba";
    public static final int NBA_MIN = 1;
    public static final int NBA_MAX = 9999;
    public static final String OBA = "oba";
    public static final int OBA_MIN = 1;
    public static final int OBA_MAX = 9999;
    private final EntityEventDispatcher<ImsBmpRegionConfig> eventDispatcher = new EntityEventDispatcher((Object)this);

    public ImsBmpRegionConfig(ImsSubsystemConfig subsystem) {
        super(subsystem, ImsRegionType.BMP);
    }

    @Override
    public String getRegionTypeLabel() {
        return "BMP";
    }

    public ImsBmpRegionConfig(ImsBmpRegionConfig bmpRegionConfig) {
        this(bmpRegionConfig.getSubsystemConfig());
        this.copyFrom(bmpRegionConfig);
    }

    @Override
    protected EntityEventDispatcher<? extends ImsRegionConfig> getEventDispatcher() {
        return this.eventDispatcher;
    }

    @Override
    public boolean isConnectable() {
        return this.getSubsystemConfig().isBmpSupported() && this.getSubsystemConfig().isOnline();
    }

    public boolean isDliProcessingInImsRegion() {
        return "1".equals(this.getSettingValue(PARDLI));
    }

    public void setDliProcessingInImsRegion(boolean pardliIsOne) {
        this.setSettingValue(PARDLI, pardliIsOne ? "1" : "0");
    }

    public String getNumFastPathDbBuffers() {
        return this.getSettingValue(NBA);
    }

    public void setNumFastPathDbBuffers(String nba) {
        this.ensureArgIsEmptyOrIntInRange(nba, 1, 9999);
        this.setSettingValue(NBA, nba);
    }

    public String getNumFastPathAdditionalBuffers() {
        return this.getSettingValue(OBA);
    }

    public void setNumFastPathAdditionalBuffers(String oba) {
        this.ensureArgIsEmptyOrIntInRange(oba, 1, 9999);
        this.setSettingValue(OBA, oba);
    }

    public void addListener(EListener<EntityEvent<ImsBmpRegionConfig>> listener) {
        this.eventDispatcher.addListener(listener);
    }

    public void removeListener(EListener<EntityEvent<ImsBmpRegionConfig>> listener) {
        this.eventDispatcher.removeListener(listener);
    }
}

