/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.core.model.db2.cmd;

import com.ibm.etools.fm.core.model.db2.cmd.Db2CommandOccurrence;
import com.ibm.etools.fm.core.model.db2.cmd.IDb2CommandParameterComponent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

abstract class Db2CommandParameterComponent
implements IDb2CommandParameterComponent {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private final Db2CommandOccurrence occurrence;
    private final List<IDb2CommandParameterComponent> components;

    public Db2CommandParameterComponent(Db2CommandOccurrence occurrence, List<? extends IDb2CommandParameterComponent> choices) {
        this.occurrence = occurrence;
        this.components = Collections.unmodifiableList(new ArrayList<IDb2CommandParameterComponent>(choices));
    }

    @Override
    public Db2CommandOccurrence getOccurence() {
        return this.occurrence;
    }

    @Override
    public List<? extends IDb2CommandParameterComponent> getComponents() {
        return this.components;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (IDb2CommandParameterComponent component : this.components) {
            sb.append("[");
            sb.append(component.toString());
            sb.append("]");
        }
        return sb.toString();
    }

    @Override
    public Set<? extends IDb2CommandParameterComponent> getAllParameters() {
        HashSet<? extends IDb2CommandParameterComponent> params = new HashSet<IDb2CommandParameterComponent>();
        for (IDb2CommandParameterComponent component : this.components) {
            params.addAll(component.getAllParameters());
        }
        return params;
    }
}

