/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.core.model.db2.cmd;

import com.ibm.etools.fm.core.model.db2.cmd.Db2CommandKeyword;
import com.ibm.etools.fm.core.model.db2.cmd.Db2CommandOccurrence;
import com.ibm.etools.fm.core.model.db2.cmd.IDb2CommandKeywordComponent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

abstract class Db2CommandKeywordComponent
implements IDb2CommandKeywordComponent {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private final Db2CommandOccurrence occurence;
    private final List<IDb2CommandKeywordComponent> components;

    protected Db2CommandKeywordComponent(Db2CommandOccurrence occurence, List<? extends IDb2CommandKeywordComponent> components) {
        this.occurence = Objects.requireNonNull(occurence, "Must provide a non-null occurence");
        this.components = Collections.unmodifiableList(new ArrayList(Objects.requireNonNull(components, "Must provide a non-null components")));
    }

    @Override
    public Db2CommandOccurrence getOccurence() {
        return this.occurence;
    }

    @Override
    public List<? extends IDb2CommandKeywordComponent> getComponents() {
        return this.components;
    }

    @Override
    public Set<Db2CommandKeyword> getAllKeywords() {
        HashSet<Db2CommandKeyword> kws = new HashSet<Db2CommandKeyword>();
        for (IDb2CommandKeywordComponent component : this.components) {
            kws.addAll(component.getAllKeywords());
        }
        return kws;
    }
}

