/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.core.model.db2.cmd;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.db2.cmd.Db2CommandArgument;
import com.ibm.etools.fm.core.model.db2.cmd.Db2CommandOccurrence;
import com.ibm.etools.fm.core.model.db2.cmd.Db2CommandParameter;
import com.ibm.etools.fm.core.model.db2.cmd.Db2CommandParameterChoice;
import com.ibm.etools.fm.core.model.db2.cmd.IDb2CommandKeywordComponent;
import com.ibm.etools.fm.core.model.db2.cmd.IDb2CommandParameterComponent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class Db2CommandKeyword
implements IDb2CommandKeywordComponent,
Comparable<Db2CommandKeyword> {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private final String name;
    private final Db2CommandOccurrence occurence;
    private final IDb2CommandParameterComponent params;
    private final List<String> abbreviations;

    public static Db2CommandKeyword createWithoutParams(String name) {
        return new Db2CommandKeyword(Db2CommandOccurrence.OPTIONAL, name, Collections.emptyList(), Db2CommandParameterChoice.EMPTY);
    }

    public Db2CommandKeyword(Db2CommandOccurrence occurence, String name, List<String> abbreviations, IDb2CommandParameterComponent params) {
        this.occurence = Objects.requireNonNull(occurence, "Must provide a non-null occurence");
        this.name = Objects.requireNonNull(name, "Please specify a non-null name.");
        this.abbreviations = Collections.unmodifiableList(new ArrayList(Objects.requireNonNull(abbreviations, "Must provide a non-null abbreviations")));
        this.params = Objects.requireNonNull(params, "Must provide a non-null params");
    }

    public String getName() {
        return this.name;
    }

    public List<String> getAliases() {
        return this.abbreviations;
    }

    public IDb2CommandParameterComponent getParameters() {
        return this.params;
    }

    public Set<? extends IDb2CommandParameterComponent> getAllParameters() {
        return this.params.getAllParameters();
    }

    @Override
    public List<? extends IDb2CommandKeywordComponent> getComponents() {
        return Collections.emptyList();
    }

    @Override
    public Db2CommandOccurrence getOccurence() {
        return this.occurence;
    }

    @Override
    public Set<Db2CommandKeyword> getAllKeywords() {
        return Collections.singleton(this);
    }

    @Override
    public int compareTo(Db2CommandKeyword o) {
        return this.getName().compareTo(o.getName());
    }

    public String getHtmlDescription() {
        String heading = "<h4>" + this.name + "</h4>";
        Set<? extends IDb2CommandParameterComponent> allParams = this.getAllParameters();
        if (allParams.size() > 0) {
            StringBuilder kws = new StringBuilder();
            for (IDb2CommandParameterComponent iDb2CommandParameterComponent : allParams) {
                kws.append("\n<li>");
                if (iDb2CommandParameterComponent instanceof Db2CommandParameter) {
                    kws.append("<em>");
                    kws.append(((Db2CommandParameter)iDb2CommandParameterComponent).getName());
                    kws.append("<em>");
                } else if (iDb2CommandParameterComponent instanceof Db2CommandArgument) {
                    kws.append("<pre style=\"margin: 0px;\">");
                    kws.append(((Db2CommandArgument)iDb2CommandParameterComponent).getValue());
                    kws.append("</pre>");
                }
                kws.append("</li>");
            }
            return heading + "<ul style=\"list-style-type: square;\">" + kws.toString() + "</ul>";
        }
        String subHeading = Messages.Db2CommandKeyword_NO_PARAMS;
        return heading + "<em>" + subHeading + "</em>";
    }
}

