/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.core.model.db2.cmd;

import com.ibm.etools.fm.core.model.db2.cmd.DB2CommandInformationParser;
import com.ibm.etools.fm.core.model.db2.cmd.Db2Command;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.helpers.DefaultHandler;

public class Db2CommandInformation {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    protected static final PDLogger logger = PDLogger.get(Db2CommandInformation.class);
    public static final String DB2_COMMANDS_FILE_PATH = "db2commands.xml";
    public static final String DB2_SQL_STATEMENTS_FILE_PATH = "db2sqlstatements.xml";
    private boolean infoLoaded = false;
    private List<Db2Command> commands = null;

    public synchronized boolean isInfoLoaded() {
        return this.infoLoaded;
    }

    public void loadFromPath(String path) throws IOException {
        block11: {
            if (path == null) {
                throw new IllegalArgumentException();
            }
            Throwable throwable = null;
            Object var3_4 = null;
            try (InputStream openStream = Db2CommandInformation.class.getResourceAsStream(path);){
                if (openStream != null) {
                    this.loadInfo(openStream);
                    break block11;
                }
                throw new IOException("Failed to open file as stream: " + path);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    public synchronized void loadInfo(InputStream in) {
        if (this.infoLoaded) {
            throw new IllegalStateException();
        }
        DB2CommandInformationParser parser = new DB2CommandInformationParser();
        try {
            SAXParserFactory.newInstance().newSAXParser().parse(in, (DefaultHandler)parser);
            this.commands = Collections.unmodifiableList(parser.getCommands());
            this.infoLoaded = true;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to parse DB2 command info", e);
        }
    }

    public synchronized void setCommands(List<Db2Command> commands) {
        if (this.infoLoaded) {
            throw new IllegalStateException();
        }
        this.commands = Collections.unmodifiableList(new ArrayList<Db2Command>(commands));
    }

    public synchronized List<Db2Command> getCommands() {
        if (this.commands == null) {
            return Collections.emptyList();
        }
        return this.commands;
    }

    public synchronized Db2Command getCommandByName(String name) {
        Objects.requireNonNull(name, "Must provide a non-null name");
        for (Db2Command cmd : this.commands) {
            if (!name.equals(cmd.getName())) continue;
            return cmd;
        }
        return null;
    }
}

