/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.core.model.db2.cmd;

import com.ibm.etools.fm.core.model.db2.cmd.Db2CommandKeyword;
import com.ibm.etools.fm.core.model.db2.cmd.Db2CommandKeywordPath;
import com.ibm.etools.fm.core.model.db2.cmd.Db2CommandOccurrence;
import com.ibm.etools.fm.core.model.db2.cmd.Db2CommandParameterChoice;
import com.ibm.etools.fm.core.model.db2.cmd.IDb2CommandKeywordComponent;
import com.ibm.etools.fm.core.model.db2.cmd.IDb2CommandParameterComponent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class Db2Command {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private final String name;
    private final String displayName;
    private final IDb2CommandKeywordComponent keywordsComponent;
    private final List<String> aliases;
    private final IDb2CommandParameterComponent params;
    private final String help;
    private final String helpDetailLink;

    public Db2Command(String name) {
        this(name, new Db2CommandKeywordPath(Db2CommandOccurrence.OPTIONAL, new ArrayList()), new ArrayList<String>());
    }

    public Db2Command(String name, IDb2CommandKeywordComponent keywordsComponent) {
        this(name, keywordsComponent, new ArrayList<String>());
    }

    public Db2Command(String name, IDb2CommandKeywordComponent keywordsComponent, List<String> aliases) {
        this(name, keywordsComponent, aliases, Db2CommandParameterChoice.EMPTY, null, null, null);
    }

    public Db2Command(String name, IDb2CommandKeywordComponent keywordsComponent, List<String> aliases, IDb2CommandParameterComponent params, String displayName, String help, String helpDetailLink) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("Must specify a non-null name.");
        }
        if (keywordsComponent == null) {
            throw new IllegalArgumentException("Must specify a non-null keywordsComponent.");
        }
        if (aliases == null) {
            throw new IllegalArgumentException("Must specify a non-null aliases.");
        }
        if (params == null) {
            throw new IllegalArgumentException("Must specify a non-null params.");
        }
        if (displayName == null) {
            displayName = name;
        }
        this.name = name;
        this.keywordsComponent = keywordsComponent;
        this.aliases = Collections.unmodifiableList(new ArrayList<String>(aliases));
        this.params = params;
        this.displayName = displayName;
        this.help = help;
        this.helpDetailLink = helpDetailLink;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getHelp() {
        return this.help;
    }

    public String getHelpDetailLinkName() {
        return this.helpDetailLink;
    }

    public IDb2CommandKeywordComponent getKeywords() {
        return this.keywordsComponent;
    }

    public Set<Db2CommandKeyword> getAllKeywords() {
        return this.keywordsComponent.getAllKeywords();
    }

    public Db2CommandKeyword getKeywordByName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Must specify a non-null name.");
        }
        Set<Db2CommandKeyword> kws = this.getAllKeywords();
        for (Db2CommandKeyword kw : kws) {
            if (!kw.getName().equals(name)) continue;
            return kw;
        }
        return null;
    }

    public List<String> getAliases() {
        return this.aliases;
    }

    public IDb2CommandParameterComponent getParams() {
        return this.params;
    }

    public String toString() {
        return this.name + " { " + this.getAllKeywords().size() + " keywords }";
    }
}

