/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.core.model.db2.cmd;

import com.ibm.etools.fm.core.model.db2.cmd.Db2Command;
import com.ibm.etools.fm.core.model.db2.cmd.Db2CommandArgument;
import com.ibm.etools.fm.core.model.db2.cmd.Db2CommandKeyword;
import com.ibm.etools.fm.core.model.db2.cmd.Db2CommandKeywordBranch;
import com.ibm.etools.fm.core.model.db2.cmd.Db2CommandKeywordPath;
import com.ibm.etools.fm.core.model.db2.cmd.Db2CommandOccurrence;
import com.ibm.etools.fm.core.model.db2.cmd.Db2CommandParameter;
import com.ibm.etools.fm.core.model.db2.cmd.Db2CommandParameterChoice;
import com.ibm.etools.fm.core.model.db2.cmd.Db2CommandParameterSequence;
import com.ibm.etools.fm.core.model.db2.cmd.IDb2CommandKeywordComponent;
import com.ibm.etools.fm.core.model.db2.cmd.IDb2CommandParameterComponent;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class DB2CommandInformationParser
extends DefaultHandler {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    protected static final PDLogger logger = PDLogger.get(DB2CommandInformationParser.class);
    private static final String TAG_COMMANDS = "commands";
    private static final String TAG_COMMAND = "command";
    private static final String ATTR_COMMAND_NAME = "name";
    private static final String ATTR_COMMAND_DISPLAY = "display";
    private static final String TAG_HELP = "help";
    private static final String ATTR_HELP_DETAIL_LINK = "link-name";
    private static final String TAG_ALIAS = "alias";
    private static final String ATTR_ALIAS_NAME = "name";
    private static final String TAG_PATH = "path";
    private static final String TAG_BRANCH = "branch";
    private static final String TAG_KEYWORD = "keyword";
    private static final String ATTR_KEYWORD_NAME = "name";
    private static final String TAG_SEQ = "seq";
    private static final String TAG_CHOICE = "choice";
    private static final String TAG_ARG = "arg";
    private static final String ATTR_ARG_VALUE = "value";
    private static final String TAG_PARAM = "param";
    private static final String ATTR_PARAM_NAME = "name";
    private List<Db2Command> commands = new ArrayList<Db2Command>();
    private Stack<String> nameAndValueStack = new Stack();
    private Stack<String> displayStack = new Stack();
    private Stack<List<String>> aliasesStack = new Stack();
    private boolean readingHelp = false;
    private Stack<String> helpLinkStack = new Stack();
    private Stack<StringBuilder> helpStack = new Stack();
    private Stack<List<IDb2CommandKeywordComponent>> keywordComponentsStack = new Stack();
    private Stack<List<IDb2CommandParameterComponent>> paramChoicesStack = new Stack();

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (!TAG_COMMANDS.equals(qName)) {
            if (TAG_COMMAND.equals(qName)) {
                this.nameAndValueStack.push(attributes.getValue("name"));
                this.displayStack.push(attributes.getValue(ATTR_COMMAND_DISPLAY));
                this.aliasesStack.push(new ArrayList());
                this.keywordComponentsStack.push(new ArrayList());
                this.paramChoicesStack.push(new ArrayList());
                this.helpStack.push(new StringBuilder());
                this.helpLinkStack.push(null);
            } else if (TAG_HELP.equals(qName)) {
                this.helpLinkStack.pop();
                this.helpLinkStack.push(attributes.getValue(ATTR_HELP_DETAIL_LINK));
                this.readingHelp = true;
            } else if (TAG_PATH.equals(qName) || TAG_BRANCH.equals(qName)) {
                this.keywordComponentsStack.push(new ArrayList());
            } else if (TAG_KEYWORD.equals(qName)) {
                this.nameAndValueStack.push(attributes.getValue("name"));
                this.aliasesStack.push(new ArrayList());
                this.paramChoicesStack.push(new ArrayList());
            } else if (TAG_ALIAS.equals(qName)) {
                this.aliasesStack.peek().add(attributes.getValue("name"));
            } else if (TAG_SEQ.equals(qName) || TAG_CHOICE.equals(qName)) {
                this.paramChoicesStack.push(new ArrayList());
            } else if (TAG_PARAM.equals(qName)) {
                this.nameAndValueStack.push(attributes.getValue("name"));
                this.aliasesStack.push(new ArrayList());
            } else if (TAG_ARG.equals(qName)) {
                this.nameAndValueStack.push(attributes.getValue(ATTR_ARG_VALUE));
                this.aliasesStack.push(new ArrayList());
            } else {
                throw new IllegalArgumentException("Unexpected element: " + qName + ": " + String.valueOf(attributes));
            }
        }
    }

    @Override
    public void characters(char[] data, int start, int length) throws SAXException {
        if (this.readingHelp) {
            StringBuilder help = this.helpStack.pop();
            String chars = new String(data, start, length).trim();
            help.append(chars);
            this.helpStack.push(help);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (TAG_COMMAND.equals(qName)) {
            String commandName = this.nameAndValueStack.pop();
            String displayName = this.displayStack.pop();
            if (displayName == null) {
                displayName = commandName;
            }
            String helpDetailLink = this.helpLinkStack.pop();
            String help = this.helpStack.pop().toString();
            List<IDb2CommandKeywordComponent> components = this.keywordComponentsStack.pop();
            Db2CommandKeywordPath topKeywordSequence = new Db2CommandKeywordPath(Db2CommandOccurrence.REQUIRED, components);
            List<String> commandAliases = this.aliasesStack.pop();
            List<IDb2CommandParameterComponent> choices = this.paramChoicesStack.pop();
            Db2CommandParameterChoice commandParamChoices = new Db2CommandParameterChoice(Db2CommandOccurrence.REQUIRED, choices);
            Db2Command command = new Db2Command(commandName, topKeywordSequence, commandAliases, commandParamChoices, displayName, help, helpDetailLink);
            this.commands.add(command);
        } else if (TAG_HELP.equals(qName)) {
            this.readingHelp = false;
        } else if (TAG_PATH.equals(qName)) {
            List<IDb2CommandKeywordComponent> components = this.keywordComponentsStack.pop();
            Db2CommandKeywordPath branch = new Db2CommandKeywordPath(Db2CommandOccurrence.OPTIONAL, components);
            this.keywordComponentsStack.peek().add(branch);
        } else if (TAG_BRANCH.equals(qName)) {
            List<IDb2CommandKeywordComponent> components = this.keywordComponentsStack.pop();
            Db2CommandKeywordBranch branch = new Db2CommandKeywordBranch(Db2CommandOccurrence.OPTIONAL, components);
            this.keywordComponentsStack.peek().add(branch);
        } else if (TAG_KEYWORD.equals(qName)) {
            String keywordName = this.nameAndValueStack.pop();
            List<String> keywordAliases = this.aliasesStack.pop();
            List<IDb2CommandParameterComponent> components = this.paramChoicesStack.pop();
            Db2CommandParameterSequence choice = new Db2CommandParameterSequence(Db2CommandOccurrence.REQUIRED, components);
            Db2CommandKeyword keyword = new Db2CommandKeyword(Db2CommandOccurrence.OPTIONAL, keywordName, keywordAliases, choice);
            this.keywordComponentsStack.peek().add(keyword);
        } else if (TAG_SEQ.equals(qName)) {
            List<IDb2CommandParameterComponent> components = this.paramChoicesStack.pop();
            Db2CommandParameterSequence choice = new Db2CommandParameterSequence(Db2CommandOccurrence.REQUIRED, components);
            this.paramChoicesStack.peek().add(choice);
        } else if (TAG_CHOICE.equals(qName)) {
            List<IDb2CommandParameterComponent> components = this.paramChoicesStack.pop();
            Db2CommandParameterChoice choice = new Db2CommandParameterChoice(Db2CommandOccurrence.REQUIRED, components);
            this.paramChoicesStack.peek().add(choice);
        } else if (TAG_ARG.equals(qName)) {
            String argValue = this.nameAndValueStack.pop();
            List<String> argAliases = this.aliasesStack.pop();
            Db2CommandArgument arg = new Db2CommandArgument(argValue, argAliases);
            this.paramChoicesStack.peek().add(arg);
        } else if (TAG_PARAM.equals(qName)) {
            String paramName = this.nameAndValueStack.pop();
            List<String> paramAliases = this.aliasesStack.pop();
            Db2CommandParameter param = new Db2CommandParameter(paramName, paramAliases);
            this.paramChoicesStack.peek().add(param);
        }
    }

    public List<Db2Command> getCommands() {
        return this.commands;
    }
}

