/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.core.model.db2;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.FMSession;
import com.ibm.etools.fm.core.model.IRetrieveCcsidSession;
import com.ibm.etools.fm.core.model.db2.Db2TemplateOptions;
import com.ibm.etools.fm.core.socket.io.ConnPoolManagerFM;
import com.ibm.etools.fm.core.socket.io.ZosConnectionFM;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.model.ISessionEdit;
import com.ibm.pdtools.common.component.core.util.PDFileSystemUtil;
import com.ibm.pdtools.common.component.jhost.core.model.IHostProviderName;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.Date;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class SessionTemplate2
extends FMSession
implements ISessionEdit,
IRetrieveCcsidSession {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final PDLogger logger = PDLogger.get(SessionTemplate2.class);
    public static final String DB2_TEMPLATE_EXTENSION = ".fmt2";
    private Date started = new Date();
    private IFile fromCacheFile;
    private ZosConnectionFM connection;
    private Db2TemplateOptions fromTemplate;

    public SessionTemplate2(Db2TemplateOptions fromTemplate) {
        super(fromTemplate.getTemplate().getSystem(), fromTemplate.getSubsystem());
        this.fromTemplate = fromTemplate;
    }

    public boolean equals(Object obj) {
        if (obj instanceof SessionTemplate2) {
            SessionTemplate2 otherSession = (SessionTemplate2)obj;
            return otherSession.fromTemplate.equals(this.fromTemplate);
        }
        return false;
    }

    public int hashCode() {
        return this.fromTemplate.hashCode();
    }

    public Result<StringBuffer> start(IHowIsGoing monitor) throws InterruptedException {
        logger.trace((Object)"starting a new template edit session.");
        Result result = new Result((Object)new StringBuffer());
        try {
            this.connection = (ZosConnectionFM)ConnPoolManagerFM.instance().getConnection(this.fromTemplate.getTable().getSubsystem().getSystem(), this.fromTemplate.getTable().getSubsystem(), monitor);
            this.fromCacheFile = PDFileSystemUtil.getLocalCacheFile((String)"FM", (IHostProviderName)this.fromTemplate.getTemplate(), (String)"", (String)DB2_TEMPLATE_EXTENSION);
            this.connection.browseTemplate2InXML(this.fromTemplate, this.fromCacheFile.getLocation().toString(), (Result<StringBuffer>)result, monitor);
            return result;
        }
        catch (InterruptedException ie) {
            throw ie;
        }
        catch (Exception e) {
            result.add(MessageFormat.format(Messages.CommEditTemplateSession_START_ERR, this.fromTemplate.getTemplate().getFormattedName()));
            result.add((Throwable)e);
            return result;
        }
    }

    public Db2TemplateOptions getFromTemplateOptioons() {
        return this.fromTemplate;
    }

    public IFile getFromCacheFile() {
        return this.fromCacheFile;
    }

    public void deleteCache() {
        if (this.fromCacheFile.exists()) {
            try {
                this.fromCacheFile.delete(true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public StringBuffer updateTemplate(StringBuffer updateInputXml, IHowIsGoing monitor, Result<StringBuffer> result, boolean retrieveNewTemplate, boolean updateToTemplate) throws InterruptedException {
        logger.trace((Object)("updating template. new XML contents: " + String.valueOf(updateInputXml)));
        logger.trace((Object)("Retrieve template after? " + retrieveNewTemplate));
        return this.connection.updateTemplate(updateInputXml, monitor, result, retrieveNewTemplate, updateToTemplate);
    }

    public StringBuffer getCurrentTemplateContents(IHowIsGoing monitor, Result<StringBuffer> result) throws InterruptedException {
        try {
            return this.connection.getTemplateXMLData(monitor, result);
        }
        catch (InterruptedException ie) {
            throw ie;
        }
        catch (Exception e) {
            String errMsg = Messages.Connection_GET_TEMPLATE_EX;
            logger.error((Object)errMsg, (Throwable)e);
            result.add(errMsg);
            result.add((Throwable)e);
            return null;
        }
    }

    public IFile saveAs(IZRL target, IHowIsGoing monitor, Result<StringBuffer> overallResult) throws InterruptedException {
        logger.trace((Object)("saveAs for current template. Target: " + target.getFormattedName()));
        Result<StringBuffer> saveAsResult = this.connection.sessionSaveAs(target, monitor);
        overallResult.addSubResult(saveAsResult);
        if (saveAsResult.getRC() > 4) {
            return null;
        }
        this.fromTemplate.setTemplate(target);
        try {
            this.fromCacheFile = PDFileSystemUtil.getLocalCacheFile((String)"FM", (IHostProviderName)this.fromTemplate.getTemplate(), (String)"", (String)DB2_TEMPLATE_EXTENSION);
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
        Result<StringBuffer> result = this.connection.doGETRECX(this.fromCacheFile.getLocation().toString(), monitor);
        overallResult.addSubResult(result);
        if (!result.isSuccessfulWithoutWarnings()) {
            return null;
        }
        return this.fromCacheFile;
    }

    public void unlock() {
        if (this.connection != null) {
            this.connection.unlock();
        }
    }

    public void closeConnection() {
        if (this.connection == null) {
            return;
        }
        this.connection.forceConnectionClose();
    }

    public void end(IHowIsGoing monitor) {
        if (this.connection == null) {
            return;
        }
        this.connection.sessionQuit(monitor);
        this.connection.unlock();
    }

    public Result<StringBuffer> save(IHowIsGoing monitor) throws InterruptedException {
        logger.trace((Object)"saving the current template.");
        return this.connection.sessionSave(monitor);
    }

    public String toString() {
        return "Template Edit Session - " + DateFormat.getInstance().format(this.started);
    }

    @Override
    public Result<StringBuffer> retrieveSupportedCcsids(IHowIsGoing monitor) throws InterruptedException {
        if (this.connection == null) {
            Result result = new Result(8);
            result.add(Messages.SessionTemplate2_0);
            return result;
        }
        return this.connection.getSupportedCcsid(monitor);
    }
}

