/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.core.model.db2;

import com.ibm.etools.fm.core.model.DataSetOrMember;
import com.ibm.etools.fm.core.model.FMHost;
import com.ibm.etools.fm.core.model.db2.Db2Subsystem;
import com.ibm.etools.fm.core.model.db2.Db2SubsystemProvider;
import com.ibm.etools.fm.core.model.db2.Db2SystemOptions;
import com.ibm.etools.fm.core.model.db2.Db2Table;
import com.ibm.etools.fm.jhost.core.model.FMHostJhost;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;

public class Db2TemplateOptions
implements Db2SubsystemProvider {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private IPDHost aHost = null;
    private Db2Subsystem aSubsystem = null;
    private Db2Table aTable = null;
    private boolean genRep = false;
    private IZRL aTemplate = null;

    public Db2TemplateOptions() {
    }

    public Db2TemplateOptions(Db2SubsystemProvider obj, DataSetOrMember template) {
        this();
        this.setSubsystem(obj.getSubsystem());
        if (obj instanceof Db2Table) {
            this.setTable((Db2Table)obj);
        }
        this.setTemplate((IZRL)template);
    }

    public Db2TemplateOptions clone() {
        Db2TemplateOptions aCopy = new Db2TemplateOptions();
        aCopy.aHost = this.aHost;
        aCopy.aSubsystem = this.aSubsystem;
        aCopy.aTable = this.aTable;
        this.genRep = false;
        aCopy.genRep = false;
        aCopy.aTemplate = this.aTemplate != null ? this.aTemplate.clone() : null;
        return aCopy;
    }

    public void setTable(Db2Table aTable) {
        this.aTable = aTable;
        this.aSubsystem = this.aTable.getSubsystem();
        this.aHost = this.aTable.getSystem();
    }

    public void setSubsystem(Db2Subsystem aSubsystem) {
        this.aHost = aSubsystem.getSystem();
        this.aSubsystem = aSubsystem;
    }

    public void setHost(IPDHost aHost) {
        this.aHost = aHost;
        this.aSubsystem = null;
        this.aTable = null;
    }

    public String toCommandString() {
        String xmlVerstionTag;
        StringBuilder sb = new StringBuilder();
        Db2TemplateOptions.append(sb, "Creator=" + this.getCreatorX());
        Db2TemplateOptions.append(sb, "Name=" + this.getNameX());
        String systemOptsCmd = this.getSystemOptions().toCommandStringForTemplateSession();
        if (!systemOptsCmd.isEmpty()) {
            Db2TemplateOptions.append(sb, systemOptsCmd);
        }
        if (this.aTemplate != null) {
            if (this.genRep) {
                Db2TemplateOptions.append(sb, "Genrep=Y");
            } else {
                Db2TemplateOptions.append(sb, "Genrep=N");
            }
            Db2TemplateOptions.append(sb, "TCin=" + this.aTemplate.getFormattedName());
        }
        if (!(xmlVerstionTag = FMHostJhost.getXmlVersionTag((IPDHost)this.aHost)).isEmpty()) {
            Db2TemplateOptions.append(sb, xmlVerstionTag);
        }
        return "DTPX " + sb.toString();
    }

    private static void append(StringBuilder sb, String newParam) {
        if (sb.length() == 0) {
            sb.append(newParam);
        } else {
            sb.append("," + newParam);
        }
    }

    public String getCreator() {
        if (this.aTable != null) {
            return this.aTable.getOwner();
        }
        return "";
    }

    private String getCreatorX() {
        if (this.aTable != null) {
            return this.aTable.getOwnerX();
        }
        return "";
    }

    public String getName() {
        if (this.aTable != null) {
            return this.aTable.getName();
        }
        return "";
    }

    private String getNameX() {
        if (this.aTable != null) {
            return this.aTable.getNameX();
        }
        return "";
    }

    public boolean isGenRep() {
        return this.genRep;
    }

    public void setGenRep(boolean genRep) {
        this.genRep = genRep;
    }

    public IZRL getTemplate() {
        return this.aTemplate;
    }

    public void setTemplate(IZRL aTemplate) {
        this.aTemplate = aTemplate;
    }

    public Db2Table getTable() {
        return this.aTable;
    }

    @Override
    public Db2Subsystem getSubsystem() {
        return this.aSubsystem;
    }

    public Db2SystemOptions getSystemOptions() {
        return ((FMHost)FMHost.getSystem((IPDHost)this.aSubsystem.getSystem())).getDb2SystemOptions(this.aSubsystem.getSubsystemID());
    }

    public IPDHost getSystem() {
        return this.aHost;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.aHost == null ? 0 : this.aHost.hashCode());
        result = 31 * result + (this.aSubsystem == null ? 0 : this.aSubsystem.hashCode());
        result = 31 * result + (this.aTable == null ? 0 : this.aTable.hashCode());
        result = 31 * result + (this.aTemplate == null ? 0 : this.aTemplate.hashCode());
        result = 31 * result + (this.genRep ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Db2TemplateOptions)) {
            return false;
        }
        Db2TemplateOptions other = (Db2TemplateOptions)obj;
        if (this.aHost == null ? other.aHost != null : !this.aHost.equals(other.aHost)) {
            return false;
        }
        if (this.aSubsystem == null ? other.aSubsystem != null : !this.aSubsystem.equals(other.aSubsystem)) {
            return false;
        }
        if (this.aTable == null ? other.aTable != null : !this.aTable.equals(other.aTable)) {
            return false;
        }
        if (this.aTemplate == null ? other.aTemplate != null : !this.aTemplate.equals(other.aTemplate)) {
            return false;
        }
        return this.genRep == other.genRep;
    }
}

