/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.core.model.db2;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.db2.Db2Object;
import com.ibm.etools.fm.core.model.db2.Db2ObjectQueryAbstract;
import com.ibm.etools.fm.core.model.db2.Db2SqlQuery;
import com.ibm.etools.fm.core.model.db2.Db2SqlQueryBuilder;
import com.ibm.etools.fm.core.model.db2.Db2SqlQueryResultWrapper;
import com.ibm.etools.fm.core.model.db2.Db2Subsystem;
import com.ibm.etools.fm.core.model.db2.Db2Tablespace;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;

public class Db2TablespaceQuery
extends Db2ObjectQueryAbstract<Db2Tablespace> {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final int NUMBER_OF_PATTERNS = 3;

    public Db2TablespaceQuery(Db2Subsystem subSystem, Class<Db2Tablespace> type) {
        super(subSystem, type);
        this.setPatternList(new String[3]);
    }

    public Db2TablespaceQuery(Db2Subsystem subSystem, Class<Db2Tablespace> type, String[] patternList) {
        super(subSystem, type);
        this.setPatternList(patternList);
    }

    @Override
    public Db2ObjectQueryAbstract<Db2Tablespace> clone() {
        Db2TablespaceQuery clone = new Db2TablespaceQuery(this.subSystem, Db2Tablespace.class);
        clone.setPatternList(this.patternList);
        if (this.objects != null) {
            clone.objects = new ArrayList(this.objects);
        }
        return clone;
    }

    @Override
    public String[] getPatternList() {
        return this.patternList == null ? null : Arrays.copyOf(this.patternList, this.patternList.length);
    }

    @Override
    public String getSQLQuery() {
        String processedOwner = null;
        processedOwner = "CURRENT_USERNAME_QUERY".equals(this.getOwnerPatternRaw()) ? this.getOwnerPattern() : Db2SqlQueryBuilder.makeLikePattern(this.getOwnerPatternRaw(), false);
        String processedName = Db2SqlQueryBuilder.makeLikePattern(this.getNamePattern(), false);
        String processedDatabaseName = Db2SqlQueryBuilder.makeLikePattern(this.getDatabasePattern(), false);
        Db2SqlQueryBuilder statement = new Db2SqlQueryBuilder();
        statement.select("NAME", "CREATOR", "DBNAME").from("SYSIBM.SYSTABLESPACE");
        if (!this.getOwnerPatternRaw().isEmpty()) {
            statement.where(Db2SqlQueryBuilder.OPERATOR.AND, "CREATOR LIKE '" + processedOwner + "'");
        }
        if (!this.getNamePattern().isEmpty()) {
            statement.where(Db2SqlQueryBuilder.OPERATOR.AND, "NAME LIKE '" + processedName + "'");
        }
        if (!this.getDatabasePattern().isEmpty()) {
            statement.where(Db2SqlQueryBuilder.OPERATOR.AND, "DBNAME LIKE '" + processedDatabaseName + "'");
        }
        return statement.getSql();
    }

    @Override
    public String getLabel() {
        String savedCreatorPattern = this.getOwnerPatternRaw();
        if ("CURRENT_USERNAME_QUERY".equals(savedCreatorPattern)) {
            return Messages.Db2TablespaceQuery_MyTables;
        }
        String creatorPattern = savedCreatorPattern.isEmpty() ? "*" : savedCreatorPattern;
        String namePattern = this.getNamePattern().isEmpty() ? "*" : this.getNamePattern();
        String databasePattern = this.getDatabasePattern().isEmpty() ? "*" : this.getDatabasePattern();
        return MessageFormat.format(Messages.SystemsLabelProvider_TABLES_X_Y_Z, creatorPattern, namePattern, databasePattern);
    }

    public void setNamePattern(String namePattern) {
        this.initialisePatternListIfNull();
        this.patternList[1] = namePattern;
    }

    public String getNamePattern() {
        return this.patternList == null ? null : this.patternList[1];
    }

    private String getDatabasePattern() {
        return this.patternList == null ? null : this.patternList[2];
    }

    public void setDatabasePattern(String databasePattern) {
        this.initialisePatternListIfNull();
        this.patternList[2] = databasePattern;
    }

    public static <U extends Db2Object> Db2TablespaceQuery create(Db2Subsystem subsys, Class<Db2Tablespace> type) {
        return new Db2TablespaceQuery(subsys, type);
    }

    @Override
    public Result<?> loadObjects(IHowIsGoing monitor) throws InterruptedException {
        Db2SqlQuery sqlQuery = new Db2SqlQuery(this.subSystem, this.getSQLQuery());
        Result<String[][]> result = sqlQuery.execute(monitor);
        if (result.getOutput() == null) {
            return result;
        }
        Db2SqlQueryResultWrapper sqlResult = new Db2SqlQueryResultWrapper(result);
        ArrayList<Db2Tablespace> objects = new ArrayList<Db2Tablespace>();
        int i = 1;
        while (i < sqlResult.getNumRows()) {
            String name = sqlResult.getString(i, 0);
            String creator = sqlResult.getString(i, 1);
            String databaseName = sqlResult.getString(i, 2);
            Db2Tablespace tablespace = new Db2Tablespace(this.subSystem, name, creator);
            tablespace.setDatabase(databaseName);
            objects.add((Db2Tablespace)this.castToQueryObjectType(tablespace));
            ++i;
        }
        this.setObjects(objects);
        return sqlResult.getRawResult();
    }

    @Override
    protected void initialisePatternListIfNull() {
        if (this.patternList == null) {
            this.patternList = new String[3];
        }
    }
}

