/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.core.model.db2;

import com.ibm.etools.fm.core.model.db2.Db2Object;
import com.ibm.etools.fm.core.model.db2.Db2Subsystem;
import com.ibm.pdtools.common.component.jhost.comms.HostType;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;

public class Db2Tablespace
extends Db2Object {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    public static final String PATTERN_VALID_NAME = ".+";
    private static final Pattern validNameRegexp = Pattern.compile(".+");
    public static final String PATTERN_VALID_CREATOR = "[A-Z0-9]+";
    private static final Pattern validcreatorRegexp = Pattern.compile("[A-Z0-9]+");
    private String creator = "";
    private String database = "";

    public Db2Tablespace(Db2Subsystem subsystem, String name) {
        super(subsystem, name);
        if (!Db2Tablespace.isValidName(name, subsystem.getSystem().getCodePage())) {
            throw new IllegalArgumentException("name='" + (name == null ? "null" : name) + "'");
        }
    }

    public Db2Tablespace(Db2Subsystem subsystem, String name, String creator) {
        super(subsystem, name);
        if (!Db2Tablespace.isValidName(name, subsystem.getSystem().getCodePage())) {
            throw new IllegalArgumentException("name='" + (name == null ? "null" : name) + "'");
        }
        if (Db2Tablespace.isValidCreator(creator, subsystem.getSystem().getCodePage())) {
            this.setCreator(creator);
        }
    }

    public static boolean isValidCreator(String creator, String codepage) {
        Objects.requireNonNull(creator, "Please provicde a non-null creator.");
        String nameCheck = null;
        try {
            nameCheck = new String(creator.getBytes(codepage), HostType.ZOS.getCommunicationEncoding());
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return validcreatorRegexp.matcher(nameCheck).matches();
    }

    public static boolean isValidName(String name, String codepage) {
        Objects.requireNonNull(name, "Must provide a non null name.");
        if (name.length() > 128) {
            return false;
        }
        String nameCheck = null;
        try {
            nameCheck = new String(name.getBytes(codepage), HostType.ZOS.getCommunicationEncoding());
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return validNameRegexp.matcher(nameCheck).matches();
    }

    public String getFormattedName() {
        return this.getCreator() + "." + this.getName();
    }

    public String toString() {
        return this.getFormattedName();
    }

    @Override
    public Db2Object clone() {
        Db2Tablespace copy = new Db2Tablespace(this.getSubsystem(), this.getName());
        for (Map.Entry<Object, Object> entry : this.properties.entrySet()) {
            copy.setPersistentProperty(entry.getKey().toString(), entry.getValue().toString());
        }
        return copy;
    }

    public String getCreator() {
        return this.creator;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public String getDatabase() {
        return this.database;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    @Override
    public String getPDLabel() {
        return this.getName();
    }
}

