/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.core.model.db2;

import com.ibm.etools.fm.core.Messages;
import java.util.Objects;

public enum Db2TableType {
    ALIAS("A", Messages.Db2TableType_ALIAS),
    CLONE_TABLE("C", Messages.Db2TableType_CLONE),
    CREATED_GLOBAL_TEMP_TABLE("G", Messages.Db2TableType_GLOBAL_TEMP),
    HISTORY_TABLE("H", Messages.Db2TableType_HISTORY),
    MATERIALIZED_QUERY_TABLE("M", Messages.Db2TableType_MATERIALIZED_QUERY),
    XML_TABLE("P", Messages.Db2TableType_XML),
    TABLE("T", Messages.Db2TableType_TABLE),
    VIEW("V", Messages.Db2TableType_VIEW),
    AUXILIARY_TABLE("X", Messages.Db2TableType_AUXILARY),
    UNKNOWN("", Messages.Db2TableType_UNKNOWN);

    private final String db2Rep;
    private final String name;

    public static Db2TableType fromDB2Rep(String db2Rep) {
        Db2TableType[] values;
        Objects.requireNonNull(db2Rep, "Please provide a non-null db2Rep.");
        Db2TableType[] db2TableTypeArray = values = Db2TableType.values();
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            Db2TableType db2TableType = db2TableTypeArray[n2];
            if (db2Rep.equals(db2TableType.db2Rep)) {
                return db2TableType;
            }
            ++n2;
        }
        return UNKNOWN;
    }

    private Db2TableType(String db2Rep, String name) {
        this.db2Rep = db2Rep;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }
}

