/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.core.model.db2;

import com.ibm.etools.fm.core.FMCorePlugin;
import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.db2.Db2Database;
import com.ibm.etools.fm.core.model.db2.Db2Object;
import com.ibm.etools.fm.core.model.db2.Db2ObjectQueryAbstract;
import com.ibm.etools.fm.core.model.db2.Db2SqlQuery;
import com.ibm.etools.fm.core.model.db2.Db2SqlQueryBuilder;
import com.ibm.etools.fm.core.model.db2.Db2SqlQueryResultWrapper;
import com.ibm.etools.fm.core.model.db2.Db2Subsystem;
import com.ibm.etools.fm.core.model.db2.Db2Table;
import com.ibm.etools.fm.core.model.db2.Db2TableType;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;

public class Db2TableQuery
extends Db2ObjectQueryAbstract<Db2Table> {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final int NUMBER_OF_PATTERNS = 3;

    public Db2TableQuery(Db2Subsystem subSystem, Class<Db2Table> type) {
        super(subSystem, type);
        this.setPatternList(new String[3]);
    }

    public Db2TableQuery(Db2Subsystem subSystem, Class<Db2Table> type, String[] patternList) {
        super(subSystem, type);
        this.setPatternList(patternList);
    }

    public static Db2ObjectQueryAbstract<Db2Table> createBrowseUserForDatabase(Db2Database db) {
        if (db == null) {
            throw new IllegalArgumentException("Must provide a non-null Db2Datbase.");
        }
        Db2TableQuery tableQuery = new Db2TableQuery(db.getSubsystem(), Db2Table.class);
        tableQuery.setOwnerPattern("CURRENT_USERNAME_QUERY");
        tableQuery.setDatabasePattern(db.getName());
        return tableQuery;
    }

    @Override
    public Db2ObjectQueryAbstract<Db2Table> clone() {
        Db2TableQuery clone = new Db2TableQuery(this.subSystem, Db2Table.class);
        clone.setPatternList(this.patternList);
        if (this.objects != null) {
            clone.objects = new ArrayList(this.objects);
        }
        return clone;
    }

    @Override
    public String[] getPatternList() {
        return this.patternList == null ? null : Arrays.copyOf(this.patternList, this.patternList.length);
    }

    @Override
    public String getSQLQuery() {
        String processedOwner = null;
        processedOwner = "CURRENT_USERNAME_QUERY".equals(this.getOwnerPatternRaw()) ? this.getOwnerPattern() : Db2SqlQueryBuilder.makeLikePattern(this.getOwnerPatternRaw(), false);
        String processedName = Db2SqlQueryBuilder.makeLikePattern(this.getNamePattern(), false);
        String processedDb = Db2SqlQueryBuilder.makeLikePattern(this.getDatabasePattern(), false);
        Db2SqlQueryBuilder statement = new Db2SqlQueryBuilder();
        statement.select("TB.DBNAME", "TB.NAME", "TB.CREATOR", "TB.TSNAME", "TB.TYPE").from("SYSIBM.SYSTABLES TB");
        if (!this.getOwnerPatternRaw().isEmpty()) {
            if (FMCorePlugin.isDb2RtrimCreatorInWhere()) {
                statement.where(Db2SqlQueryBuilder.OPERATOR.AND, "RTRIM(TB.CREATOR) LIKE RTRIM('" + processedOwner + "')");
            } else {
                statement.where(Db2SqlQueryBuilder.OPERATOR.AND, "TB.CREATOR LIKE '" + processedOwner + "'");
            }
        }
        if (!this.getNamePattern().isEmpty()) {
            statement.where(Db2SqlQueryBuilder.OPERATOR.AND, "TB.NAME LIKE '" + processedName + "'");
        }
        if (!this.getDatabasePattern().isEmpty()) {
            statement.where(Db2SqlQueryBuilder.OPERATOR.AND, "TB.DBNAME LIKE '" + processedDb + "'");
        }
        return statement.getSql();
    }

    @Override
    public String getLabel() {
        String savedOwnerPattern = this.getOwnerPatternRaw();
        if ("CURRENT_USERNAME_QUERY".equals(savedOwnerPattern)) {
            return Messages.Db2TableQuery_MyTables;
        }
        String ownerPattern = savedOwnerPattern.isEmpty() ? "*" : savedOwnerPattern;
        String namePattern = this.getNamePattern().isEmpty() ? "*" : this.getNamePattern();
        String databasePattern = this.getDatabasePattern().isEmpty() ? "*" : this.getDatabasePattern();
        return MessageFormat.format(Messages.SystemsLabelProvider_TABLES_X_Y_Z, ownerPattern, namePattern, databasePattern);
    }

    public String getDatabasePattern() {
        return this.patternList == null ? null : this.patternList[2];
    }

    public void setDatabasePattern(String databasePattern) {
        this.initialisePatternListIfNull();
        this.patternList[2] = databasePattern;
    }

    public void setNamePattern(String databasePattern) {
        this.initialisePatternListIfNull();
        this.patternList[1] = databasePattern;
    }

    public String getNamePattern() {
        return this.patternList == null ? null : this.patternList[1];
    }

    public static <U extends Db2Object> Db2TableQuery create(Db2Subsystem subsys, Class<Db2Table> type) {
        return new Db2TableQuery(subsys, type);
    }

    @Override
    public Result<?> loadObjects(IHowIsGoing monitor) throws InterruptedException {
        Db2SqlQuery sqlQuery = new Db2SqlQuery(this.subSystem, this.getSQLQuery());
        Result<String[][]> result = sqlQuery.execute(monitor);
        if (result.getOutput() == null) {
            return result;
        }
        Db2SqlQueryResultWrapper sqlResult = new Db2SqlQueryResultWrapper(result);
        ArrayList<Db2Table> objects = new ArrayList<Db2Table>();
        int i = 1;
        while (i < sqlResult.getNumRows()) {
            String dbname = sqlResult.getString(i, 0);
            String name = sqlResult.getString(i, 1);
            String creator = sqlResult.getString(i, 2);
            String tableSpace = sqlResult.getString(i, 3);
            Db2TableType type = Db2TableType.fromDB2Rep(sqlResult.getString(i, 4));
            Db2Table table = new Db2Table(this.subSystem, name, creator);
            table.setDatabaseName(dbname);
            table.setTableSpaceName(tableSpace);
            table.setType(type);
            objects.add((Db2Table)this.castToQueryObjectType(table));
            ++i;
        }
        this.setObjects(objects);
        return sqlResult.getRawResult();
    }

    @Override
    protected void initialisePatternListIfNull() {
        if (this.patternList == null) {
            this.patternList = new String[3];
        }
    }
}

