/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.core.model.db2;

import com.ibm.etools.fm.core.FMCorePlugin;
import com.ibm.etools.fm.core.model.db2.Db2Database;
import com.ibm.etools.fm.core.model.db2.Db2Object;
import com.ibm.etools.fm.core.model.db2.Db2Subsystem;
import com.ibm.etools.fm.core.model.db2.Db2TableType;
import com.ibm.etools.fm.model.util.DataConversionUtils;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.util.StringUtils;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.Objects;
import java.util.regex.Pattern;

public class Db2Table
extends Db2Object {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    public static final String SUBSYSTEM_SEP = ":";
    public static final String QUALIFIER_SEP = ".";
    public static final String PATTERN_VALID_NAME = ".+";
    private static final Pattern validNameRegexp = Pattern.compile(".+");
    public static final String PATTERN_VALID_OWNER = ".*";
    private static final Pattern validOwnerRegexp = Pattern.compile(".*");
    public static final String PATTERN_VALID_LOCATION = "[^\\s.]*";
    private static final Pattern validLocationRegexp = Pattern.compile("[^\\s.]*");
    public static final String FORMATTED_PREFIX = "DB2:TBL:";
    private static final Pattern parseableRegexp = Pattern.compile("^DB2:TBL:[A-Z0-9#$@]{1,4}:[^\\s.]*.?.*.?.+$");
    private final String location;
    private final String owner;
    private String databaseName = "";
    private Db2TableType type = Db2TableType.UNKNOWN;
    private String tableSpaceName = "";
    private static final PDLogger logger = PDLogger.get(Db2Table.class);

    public static boolean isParseableTable(IPDHost host, String path) {
        Objects.requireNonNull(path, "Please specify a non-null path.");
        String nameCheck = null;
        try {
            nameCheck = new String(path.getBytes(host.getCodePage()), host.getCommunicationCodePage());
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return parseableRegexp.matcher(nameCheck).matches();
    }

    public static Db2Table parseTable(IPDHost host, String path) {
        if (!Db2Table.isParseableTable(host, path)) {
            throw new IllegalArgumentException();
        }
        int subsysEnd = path.indexOf(SUBSYSTEM_SEP, FORMATTED_PREFIX.length());
        String ssid = path.substring(FORMATTED_PREFIX.length(), subsysEnd);
        Db2Subsystem subsys = new Db2Subsystem(host, ssid);
        int tableStart = subsysEnd + SUBSYSTEM_SEP.length();
        String table = path.substring(tableStart);
        String[] qualifiers = table.split(StringUtils.escapeRegex((String)QUALIFIER_SEP));
        if (qualifiers.length == 3) {
            return new Db2Table(subsys, qualifiers[2], qualifiers[1], qualifiers[0]);
        }
        if (qualifiers.length == 2) {
            return new Db2Table(subsys, qualifiers[1], qualifiers[0]);
        }
        return new Db2Table(subsys, qualifiers[0]);
    }

    public static boolean isValidName(IPDHost host, String name) {
        Objects.requireNonNull(name, "Please specify a non-null name.");
        String nameCheck = null;
        try {
            nameCheck = new String(name.getBytes(host.getCodePage()), host.getCommunicationCodePage());
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return validNameRegexp.matcher(nameCheck).matches();
    }

    public static boolean isValidOwner(IPDHost host, String owner) {
        Objects.requireNonNull(owner, "Please specify a non-null owner.");
        String nameCheck = null;
        try {
            nameCheck = new String(owner.getBytes(host.getCodePage()), host.getCommunicationCodePage());
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return validOwnerRegexp.matcher(nameCheck).matches();
    }

    public static boolean isValidLocation(IPDHost host, String location) {
        Objects.requireNonNull(location, "Please specify a non-null location.");
        String nameCheck = null;
        try {
            nameCheck = new String(location.getBytes(host.getCodePage()), host.getCommunicationCodePage());
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return validLocationRegexp.matcher(nameCheck).matches();
    }

    public Db2Table(Db2Subsystem subsystem, String name) {
        this(subsystem, name, "", "");
    }

    public Db2Table(Db2Subsystem subsystem, String name, String owner) {
        this(subsystem, name, owner, "");
    }

    public Db2Table(Db2Subsystem subsystem, String name, String owner, String location) {
        super(subsystem, name);
        if (!Db2Table.isValidName(subsystem.getSystem(), name)) {
            throw new IllegalArgumentException("name='" + (name == null ? "null" : name) + "'");
        }
        if (!Db2Table.isValidOwner(subsystem.getSystem(), owner)) {
            throw new IllegalArgumentException(owner);
        }
        if (!Db2Table.isValidLocation(subsystem.getSystem(), location)) {
            throw new IllegalArgumentException(location);
        }
        this.owner = owner;
        this.location = location;
    }

    public String getOwner() {
        return this.owner;
    }

    public String getOwnerX() {
        if (this.owner == null || this.owner.isEmpty()) {
            return "";
        }
        try {
            byte[] hexBytes = null;
            hexBytes = this.getSystem().getHostType().getCommunicationEncoding() != this.getSystem().getCodePage() ? this.owner.getBytes(this.getSystem().getCodePage()) : this.owner.getBytes(this.getSystem().getHostType().getCommunicationEncoding());
            return "x'" + DataConversionUtils.getHexString(hexBytes) + "'";
        }
        catch (Exception e) {
            logger.error((Object)("Conversion error occurred. Table owner [" + this.owner + "]"), (Throwable)e);
            return "";
        }
    }

    public String getNameX() {
        String name = this.getName();
        if (name == null || name.isEmpty()) {
            return "";
        }
        try {
            byte[] hexBytes = null;
            hexBytes = this.getSystem().getHostType().getCommunicationEncoding() != this.getSystem().getCodePage() ? name.getBytes(this.getSystem().getCodePage()) : name.getBytes(this.getSystem().getHostType().getCommunicationEncoding());
            return "x'" + DataConversionUtils.getHexString(hexBytes) + "'";
        }
        catch (Exception e) {
            logger.error((Object)("Conversion error occurred. Table name [" + name + "]"), (Throwable)e);
            return "";
        }
    }

    public String getLocation() {
        return this.location;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public Db2Database getDatabase() {
        if (Db2Database.isValidName(this.getSubsystem().getSystem(), this.databaseName)) {
            return new Db2Database(this.getSubsystem(), this.databaseName);
        }
        return null;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setTableSpaceName(String tableSpaceName) {
        this.tableSpaceName = Objects.requireNonNull(tableSpaceName, "Must provide a non-null tableSpaceName");
    }

    public String getTableSpaceName() {
        return this.tableSpaceName;
    }

    public void setType(Db2TableType type) {
        this.type = Objects.requireNonNull(type, "Must provide a non-null type");
    }

    public Db2TableType getType() {
        return this.type;
    }

    public String getFormattedName() {
        return FORMATTED_PREFIX + this.getSubsystem().getName() + SUBSYSTEM_SEP + this.getQualifiedName();
    }

    public String getQualifiedName() {
        Object qualifiedName = "";
        if (!this.location.isEmpty()) {
            qualifiedName = (String)qualifiedName + this.location + QUALIFIER_SEP;
        }
        if (!this.owner.isEmpty()) {
            qualifiedName = (String)qualifiedName + this.owner + QUALIFIER_SEP;
        }
        qualifiedName = (String)qualifiedName + this.getName();
        return qualifiedName;
    }

    public String toString() {
        return this.getFormattedName();
    }

    @Override
    public Db2Table clone() {
        Db2Table copy = new Db2Table(this.getSubsystem(), this.getName(), this.owner);
        copy.databaseName = this.databaseName;
        copy.tableSpaceName = this.tableSpaceName;
        copy.type = this.type;
        for (Object key : this.properties.keySet()) {
            copy.setPersistentProperty(key.toString(), this.properties.get(key).toString());
        }
        return copy;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof Db2Table) {
            Db2Table otherTable = (Db2Table)obj;
            if (!this.owner.equals(otherTable.owner)) {
                return false;
            }
            return super.equals(obj);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() * this.owner.hashCode() * this.location.hashCode();
    }

    @Override
    public String getPDImageName() {
        String filename = this.getType() == Db2TableType.TABLE ? "table" : (this.getType() == Db2TableType.VIEW ? "view" : (this.getType() == Db2TableType.ALIAS ? "alias" : "special"));
        return "db2_table" + File.separator + filename;
    }

    @Override
    public String getPDLabel() {
        if (!this.getLocation().isEmpty()) {
            return this.getLocation() + QUALIFIER_SEP + this.getName();
        }
        if (!this.getOwner().isEmpty()) {
            return (FMCorePlugin.isDb2RtrimCreatorInTree() ? this.getOwner().replaceAll(" +$", "") : this.getOwner()) + QUALIFIER_SEP + this.getName();
        }
        return this.getName();
    }
}

