/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.core.model.db2;

import com.ibm.etools.fm.core.Messages;

public class Db2SystemOptions {
    private boolean UCO = false;
    private boolean UCS = true;
    private ENCAPS_TYPE ENCAPS = ENCAPS_TYPE.ALWAYS;
    private EXTERNAL_FORMAT_TIME TIME = EXTERNAL_FORMAT_TIME.ISO;
    private boolean UR = true;
    private boolean FKEY = true;
    private DECFLOAT_TYPE DECFLOAT = DECFLOAT_TYPE.E;

    public String toCommandString() {
        StringBuilder sb = new StringBuilder();
        Db2SystemOptions.appendValueIfNotEmpty(sb, "UCO=" + Db2SystemOptions.bool2Char(this.UCO));
        Db2SystemOptions.appendValueIfNotEmpty(sb, "UCS=" + Db2SystemOptions.bool2Char(this.UCS));
        Db2SystemOptions.appendValueIfNotEmpty(sb, this.ENCAPS.getParameterFormat());
        Db2SystemOptions.appendValueIfNotEmpty(sb, this.TIME.getParameterFormat());
        Db2SystemOptions.appendValueIfNotEmpty(sb, "UR=" + Db2SystemOptions.bool2Char(this.UR));
        Db2SystemOptions.appendValueIfNotEmpty(sb, "FKEY=" + Db2SystemOptions.bool2Char(this.FKEY));
        Db2SystemOptions.appendValueIfNotEmpty(sb, this.DECFLOAT.getParameterFormat());
        return sb.toString().trim();
    }

    public String toCommandStringForTemplateSession() {
        StringBuilder sb = new StringBuilder();
        Db2SystemOptions.appendValueIfNotEmpty(sb, "UCS=" + Db2SystemOptions.bool2Char(this.UCS));
        Db2SystemOptions.appendValueIfNotEmpty(sb, this.ENCAPS.getParameterFormat());
        Db2SystemOptions.appendValueIfNotEmpty(sb, this.TIME.getParameterFormat());
        return sb.toString().trim();
    }

    private static String bool2Char(boolean b) {
        if (b) {
            return "Y";
        }
        return "N";
    }

    private static void appendValueIfNotEmpty(StringBuilder sb, String value) {
        if (value == null || value.isEmpty()) {
            return;
        }
        if (sb.length() > 0) {
            sb.append("," + value);
        } else {
            sb.append(value);
        }
    }

    public boolean getUCS() {
        return this.UCS;
    }

    public void setUCS(boolean uCS) {
        this.UCS = uCS;
    }

    public ENCAPS_TYPE getENCAPS() {
        return this.ENCAPS;
    }

    public void setENCAPS(ENCAPS_TYPE eNCAPS) {
        this.ENCAPS = eNCAPS;
    }

    public EXTERNAL_FORMAT_TIME getTIME() {
        return this.TIME;
    }

    public void setTIME(EXTERNAL_FORMAT_TIME tIME) {
        this.TIME = tIME;
    }

    public boolean getUR() {
        return this.UR;
    }

    public void setUR(boolean uR) {
        this.UR = uR;
    }

    public boolean getFKEY() {
        return this.FKEY;
    }

    public void setFKEY(boolean fKEY) {
        this.FKEY = fKEY;
    }

    public DECFLOAT_TYPE getDECFLOAT() {
        return this.DECFLOAT;
    }

    public void setDECFLOAT(DECFLOAT_TYPE dECFLOAT) {
        this.DECFLOAT = dECFLOAT;
    }

    public Db2SystemOptions clone() {
        Db2SystemOptions aCopy = new Db2SystemOptions();
        aCopy.UCO = this.UCO;
        aCopy.UCS = this.UCS;
        aCopy.ENCAPS = this.ENCAPS;
        aCopy.TIME = this.TIME;
        aCopy.UR = this.UR;
        aCopy.FKEY = this.FKEY;
        aCopy.DECFLOAT = this.DECFLOAT;
        return aCopy;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Db2SystemOptions) {
            Db2SystemOptions other = (Db2SystemOptions)obj;
            return other.UCO == this.UCO && this.UCS == other.UCS && this.UR == other.UR && other.FKEY == this.FKEY && other.DECFLOAT.equals((Object)this.DECFLOAT) && other.ENCAPS.equals((Object)this.ENCAPS) && other.TIME.equals((Object)this.TIME);
        }
        return false;
    }

    public int hashCode() {
        int magic = 42;
        int result = 89;
        result *= magic;
        result += this.UCO ? 0 : 1;
        result *= magic;
        result += this.UCS ? 0 : 1;
        result *= magic;
        result += this.UR ? 0 : 1;
        result *= magic;
        result += this.FKEY ? 0 : 1;
        result *= magic;
        result += this.DECFLOAT.hashCode();
        result *= magic;
        result += this.ENCAPS.hashCode();
        result *= magic;
        return result += this.TIME.hashCode();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum DECFLOAT_TYPE {
        C{

            public String toString() {
                return Messages.Db2SystemOptions_6;
            }

            @Override
            public String getParameterFormat() {
                return "DECFLOAT=C";
            }
        }
        ,
        D{

            public String toString() {
                return Messages.Db2SystemOptions_7;
            }

            @Override
            public String getParameterFormat() {
                return "DECFLOAT=D";
            }
        }
        ,
        F{

            public String toString() {
                return Messages.Db2SystemOptions_8;
            }

            @Override
            public String getParameterFormat() {
                return "DECFLOAT=F";
            }
        }
        ,
        G{

            public String toString() {
                return Messages.Db2SystemOptions_9;
            }

            @Override
            public String getParameterFormat() {
                return "DECFLOAT=G";
            }
        }
        ,
        E{

            public String toString() {
                return Messages.Db2SystemOptions_10;
            }

            @Override
            public String getParameterFormat() {
                return "";
            }
        }
        ,
        H{

            public String toString() {
                return Messages.Db2SystemOptions_11;
            }

            @Override
            public String getParameterFormat() {
                return "DECFLOAT=H";
            }
        }
        ,
        U{

            public String toString() {
                return Messages.Db2SystemOptions_12;
            }

            @Override
            public String getParameterFormat() {
                return "DECFLOAT=U";
            }
        };


        public abstract String getParameterFormat();

        public static DECFLOAT_TYPE getStrValueToType(String value) {
            if (C.toString().equals(value)) {
                return C;
            }
            if (D.toString().equals(value)) {
                return D;
            }
            if (F.toString().equals(value)) {
                return F;
            }
            if (G.toString().equals(value)) {
                return G;
            }
            if (E.toString().equals(value)) {
                return E;
            }
            if (H.toString().equals(value)) {
                return H;
            }
            if (U.toString().equals(value)) {
                return U;
            }
            return E;
        }

        public static DECFLOAT_TYPE getDefault() {
            return E;
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum ENCAPS_TYPE {
        ALWAYS{

            public String toString() {
                return Messages.Db2SystemOptions_0;
            }

            @Override
            public String getParameterFormat() {
                return "";
            }
        }
        ,
        DB2{

            public String toString() {
                return Messages.Db2SystemOptions_1;
            }

            @Override
            public String getParameterFormat() {
                return "ENCAPS=DB2";
            }
        }
        ,
        IBM{

            public String toString() {
                return Messages.Db2SystemOptions_2;
            }

            @Override
            public String getParameterFormat() {
                return "ENCAPS=IBM";
            }
        };


        public abstract String getParameterFormat();

        public static ENCAPS_TYPE getStrValueToType(String value) {
            if (IBM.toString().equals(value)) {
                return IBM;
            }
            if (DB2.toString().equals(value)) {
                return DB2;
            }
            if (ALWAYS.toString().equals(value)) {
                return ALWAYS;
            }
            return ALWAYS;
        }

        public static ENCAPS_TYPE getDefault() {
            return ALWAYS;
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum EXTERNAL_FORMAT_TIME {
        ISO{

            public String toString() {
                return Messages.Db2SystemOptions_3;
            }

            @Override
            public String getParameterFormat() {
                return "";
            }
        }
        ,
        JIS{

            public String toString() {
                return Messages.Db2SystemOptions_4;
            }

            @Override
            public String getParameterFormat() {
                return "TIME=JIS";
            }
        }
        ,
        DB2{

            public String toString() {
                return Messages.Db2SystemOptions_5;
            }

            @Override
            public String getParameterFormat() {
                return "TIME=DB2";
            }
        };


        public abstract String getParameterFormat();

        public static EXTERNAL_FORMAT_TIME getStrValueToType(String value) {
            if (ISO.toString().equals(value)) {
                return ISO;
            }
            if (JIS.toString().equals(value)) {
                return JIS;
            }
            if (DB2.toString().equals(value)) {
                return DB2;
            }
            return ISO;
        }

        public static EXTERNAL_FORMAT_TIME getDefault() {
            return ISO;
        }
    }
}

