/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.core.model.db2;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.FMHost;
import com.ibm.etools.fm.core.model.db2.Db2Subsystem;
import com.ibm.etools.fm.core.socket.func.D2SL;
import com.ibm.etools.fm.core.socket.func.D2SLParser;
import com.ibm.etools.fm.core.socket.func.UtilityFunctionRunner;
import com.ibm.pdtools.common.component.core.model.PDPlatformObject;
import com.ibm.pdtools.common.component.jhost.core.model.IPDConnectEndpoint;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import java.io.UnsupportedEncodingException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;

public class Db2SubsystemQuery
extends PDPlatformObject {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    public static final String MULTI_CHAR_WILDCARD = "*";
    private static final Pattern validRegexp = Pattern.compile("([A-Z0-9#$@*]{1,4}|[*])");
    private final IPDHost system;
    private String query;
    private List<Db2Subsystem> subsystems = null;
    private Object remoteListener = null;

    public static Db2SubsystemQuery createForHost(IPDHost host) {
        Objects.requireNonNull(host, "Must provide a non-null host.");
        return new Db2SubsystemQuery(host, MULTI_CHAR_WILDCARD);
    }

    public static Db2SubsystemQuery createForHost(IPDHost host, String ssid) {
        Objects.requireNonNull(ssid, "Must provide a non-null ssid");
        return new Db2SubsystemQuery(host, ssid);
    }

    public static boolean isValidQuery(IPDHost host, String queryText) {
        Objects.requireNonNull(queryText, "Must provide a non-null queryText");
        if (queryText.isEmpty()) {
            return false;
        }
        String nameCheck = null;
        try {
            nameCheck = new String(queryText.getBytes(host.getCodePage()), host.getCommunicationCodePage());
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return validRegexp.matcher(nameCheck).matches();
    }

    public Db2SubsystemQuery(IPDHost system, String query) {
        if (!Db2SubsystemQuery.isValidQuery(system, query)) {
            throw new IllegalArgumentException(query);
        }
        this.query = query.toUpperCase();
        this.system = Objects.requireNonNull(system, "Must provide a non-null system.");
    }

    public Db2SubsystemQuery clone() {
        Db2SubsystemQuery clone = new Db2SubsystemQuery(this.system, this.query);
        if (this.subsystems != null) {
            clone.setSubsystems(new ArrayList<Db2Subsystem>(this.subsystems));
        }
        return clone;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Db2SubsystemQuery) {
            Db2SubsystemQuery otherQuery = (Db2SubsystemQuery)((Object)obj);
            return this.query.equals(otherQuery.query) && this.system.equals(otherQuery.system);
        }
        return false;
    }

    public int hashCode() {
        return this.query.hashCode() * this.system.hashCode();
    }

    public String getQuery() {
        return this.query;
    }

    public IPDHost getSystem() {
        return this.system;
    }

    protected void setSubsystems(List<Db2Subsystem> subsystems) {
        this.subsystems = subsystems;
    }

    public List<Db2Subsystem> getSubsystems() {
        if (this.subsystems == null) {
            return this.subsystems;
        }
        return Collections.unmodifiableList(this.subsystems);
    }

    public Result<List<Db2Subsystem>> loadSubsystems(IHowIsGoing monitor) throws InterruptedException {
        if (this.getSystem() == null) {
            throw new IllegalStateException("Can't loadSubsystems when system is null.");
        }
        D2SL d2sl = new D2SL();
        d2sl.setSSID(this.getQuery());
        Result result = UtilityFunctionRunner.executeAndParse(this.getSystem(), (IPDConnectEndpoint)FMHost.getSystem((IPDHost)this.getSystem()), d2sl, new D2SLParser(this.getSystem()), monitor);
        List output = (List)result.getOutput();
        if (output == null) {
            result.setRC(8);
            result.add(Messages.Db2SubsystemQuery_NoDb2SubsystemInfoReturnedErr);
            return result;
        }
        HashMap<CallSite, Db2Subsystem> ssidMap = new HashMap<CallSite, Db2Subsystem>();
        for (Db2Subsystem subsystem : output) {
            ssidMap.put((CallSite)((Object)(subsystem.getSubsystemID() + (String)(subsystem.getStatus() == Db2Subsystem.STATUS.GROUP ? " " + Messages.Db2Subsystem_GROUP : ""))), subsystem);
        }
        this.setSubsystems(new ArrayList<Db2Subsystem>(ssidMap.values()));
        return result;
    }

    public void clearSubsystems() {
        this.subsystems = null;
    }

    public String toString() {
        return this.query;
    }

    public void setQuery(String value) {
        if (!Db2SubsystemQuery.isValidQuery(this.getSystem(), value)) {
            throw new IllegalArgumentException(value);
        }
        this.query = value.toUpperCase();
    }

    public Object getLoadFinishedListener() {
        return this.remoteListener;
    }

    public void setLoadFinishedListener(Object listener) {
        this.remoteListener = listener;
    }

    public String getPDPluginId() {
        return "com.ibm.etools.fm.ui";
    }

    public String getPDImageName() {
        return "db2_subsystem_browse";
    }

    public String getPDLabel() {
        return this.getQuery();
    }
}

