/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.core.model.db2;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.db2.Db2SubsystemProvider;
import com.ibm.etools.fm.core.socket.io.CommonConnectionFM;
import com.ibm.etools.fm.core.socket.io.ZosConnectionFM;
import com.ibm.etools.fm.jhost.core.model.FMSubsystemType;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.model.PDPlatformObject;
import com.ibm.pdtools.common.component.jhost.comms.CommunicationException;
import com.ibm.pdtools.common.component.jhost.comms.HostType;
import com.ibm.pdtools.common.component.jhost.comms.PDContext;
import com.ibm.pdtools.common.component.jhost.core.model.IPDConnectEndpoint;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.socket.io.CommonConnectionJhost;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.Objects;
import java.util.Properties;
import java.util.regex.Pattern;

public class Db2Subsystem
extends PDPlatformObject
implements Comparable<Db2Subsystem>,
IZRL,
Db2SubsystemProvider,
IPDConnectEndpoint {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final PDLogger logger = PDLogger.get(Db2Subsystem.class);
    public static final String PATTERN_VALID_NAME = "[A-Z0-9#$@]{1,4}";
    private static final Pattern validRegexp = Pattern.compile("[A-Z0-9#$@]{1,4}");
    public static final String FORMATTED_PREFIX = "DB2:";
    private static final Pattern parseableRegexp = Pattern.compile("^DB2:[A-Z0-9#$@]{1,4}$");
    private final String ssid;
    private STATUS status = STATUS.UNAVAIL;
    private String description = "";
    private String prefix = "";
    private boolean canConnect = true;
    private final Properties subsystemProperties = new Properties();

    public static boolean isParseableSubsystem(IPDHost host, String path) {
        Objects.requireNonNull(path, "Please provide a non-null path.");
        String nameCheck = null;
        try {
            nameCheck = new String(path.getBytes(host.getCodePage()), host.getCommunicationCodePage());
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return parseableRegexp.matcher(nameCheck).matches();
    }

    public static Db2Subsystem parseSubsystem(IPDHost host, String path) {
        Objects.requireNonNull(host, "Please provide a non-null host.");
        if (!Db2Subsystem.isParseableSubsystem(host, path)) {
            throw new IllegalArgumentException(path);
        }
        String name = path.substring(FORMATTED_PREFIX.length());
        return new Db2Subsystem(host, name);
    }

    public static boolean isValidName(IPDHost host, String fullName) {
        Objects.requireNonNull(fullName, "Please provide a non-null fullName.");
        String nameCheck = null;
        try {
            nameCheck = new String(fullName.getBytes(host.getCodePage()), host.getCommunicationCodePage());
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return validRegexp.matcher(nameCheck).matches();
    }

    public Db2Subsystem(IPDHost system, String ssid) {
        if (!Db2Subsystem.isValidName(system, ssid)) {
            throw new IllegalArgumentException("ssid='" + (ssid == null ? "null" : ssid) + "'");
        }
        this.setSystem(system);
        this.ssid = ssid.toUpperCase();
    }

    public Db2Subsystem clone() {
        Db2Subsystem copy = new Db2Subsystem(this.getSystem(), this.ssid);
        copy.setStatus(this.status);
        copy.setDescription(this.description);
        copy.setCanConnect(this.canConnect);
        copy.setPrefix(this.prefix);
        for (Object key : this.subsystemProperties.keySet()) {
            copy.setPersistentProperty(key.toString(), this.subsystemProperties.get(key).toString());
        }
        return copy;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Db2Subsystem) {
            Db2Subsystem anApp = (Db2Subsystem)obj;
            return anApp.getSystem().equals(this.getSystem()) && anApp.ssid.equals(this.ssid);
        }
        return false;
    }

    public int hashCode() {
        return this.getSystem().hashCode() * this.ssid.hashCode() * this.status.hashCode() * this.prefix.hashCode();
    }

    @Override
    public int compareTo(Db2Subsystem o) {
        int systemCompare = this.getSystem().compareTo(o.getSystem());
        if (systemCompare != 0) {
            return systemCompare;
        }
        return this.ssid.compareTo(o.ssid);
    }

    public String getName() {
        return this.ssid;
    }

    public String getNameWithDescription() {
        if (this.description != null && this.description.length() > 0) {
            return this.ssid + (String)(this.getStatus() == STATUS.GROUP ? " " + Messages.Db2Subsystem_GROUP : "") + ": " + this.description;
        }
        return this.ssid;
    }

    public String getFormattedName() {
        return FORMATTED_PREFIX + this.getName();
    }

    public String getSubsystemID() {
        return this.ssid;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public void setStatus(STATUS status) {
        this.status = Objects.requireNonNull(status, "Must provide a non-null status");
    }

    public STATUS getStatus() {
        return this.status;
    }

    public void setCanConnect(boolean canConnect) {
        this.canConnect = canConnect;
    }

    public boolean getCanConnect() {
        return this.canConnect;
    }

    public void setPrefix(String prefix) {
        this.prefix = Objects.requireNonNull(prefix, "Must provide a non-null prefix");
    }

    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public Db2Subsystem getSubsystem() {
        return this;
    }

    public String getPersistentProperty(String key) {
        return this.subsystemProperties.getProperty(key);
    }

    public void setPersistentProperty(String key, String value) {
        this.subsystemProperties.setProperty(key, value);
    }

    public String toString() {
        return this.getName();
    }

    public String toDetailedString() {
        return MessageFormat.format("Subsystem:[ssid={0} status={1} prefix={2} connectable={3} desc={4}]", new Object[]{this.ssid, this.status, this.prefix, this.canConnect, this.description});
    }

    public String getPDImageName() {
        return "db2_subsystem";
    }

    public String getPDLabel() {
        return this.getNameWithDescription();
    }

    public String getPDPluginId() {
        return "com.ibm.etools.fm.ui";
    }

    public String copyName() {
        return this.getFormattedName();
    }

    public String getComponentName() {
        return FMSubsystemType.DB2.getComponentName();
    }

    public String getConfigurationID() {
        return "FM";
    }

    public boolean endPointPDHost(IPDHost pdHost) {
        return this.getSystem().equals(pdHost);
    }

    @Deprecated
    public CommonConnectionJhost getNewConnection(IPDHost pdHost, IHowIsGoing monitor) throws InterruptedException, CommunicationException {
        return this.getNewConnection(pdHost, null, monitor);
    }

    public CommonConnectionJhost getNewConnection(IPDHost pdHost, PDContext pdContext, IHowIsGoing monitor) throws InterruptedException, CommunicationException {
        Result<StringBuffer> compileOptsUpdateResult;
        CommonConnectionFM chosenConnection = null;
        if (HostType.ZOS == pdHost.getHostType()) {
            chosenConnection = new ZosConnectionFM(pdHost, this, monitor);
            logger.debug((Object)("Established z/OS connection for endpoint " + String.valueOf(this) + " on system " + pdHost.toString()));
        }
        if (chosenConnection != null && !(compileOptsUpdateResult = chosenConnection.updateCompilerOptions(monitor)).isSuccessfulWithoutWarnings()) {
            logger.debug((Object)("Failed to set compiler options for endpoint " + String.valueOf(this) + " on system " + pdHost.toString()));
            chosenConnection = null;
        }
        return chosenConnection;
    }

    public static enum STATUS {
        ACTIVE(Messages.Db2Subsystem_ACTIVE),
        INACTIVE(Messages.Db2Subsystem_INACTIVE),
        UNAVAIL(Messages.Db2Subsystem_UNAVAILABLE),
        GROUP(Messages.Db2Subsystem_GROUP);

        private final String name;

        private STATUS(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

