/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.core.model.db2;

import com.ibm.etools.fm.core.model.db2.Db2ColumnComparator;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class Db2SqlQueryResultWrapper {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private final Result<String[][]> result;
    private Map<String, Integer> columnMap;

    public Db2SqlQueryResultWrapper(Result<String[][]> result) {
        this.result = Objects.requireNonNull(result, "Must provide a non-null result");
    }

    public Result<String[][]> getRawResult() {
        return this.result;
    }

    public int getNumRows() {
        this.assertResultHasOutput();
        return ((String[][])this.result.getOutput()).length;
    }

    public int getNumColumns() {
        this.assertResultHasOutput();
        if (((String[][])this.result.getOutput()).length == 0) {
            return 0;
        }
        return ((String[][])this.result.getOutput())[0].length;
    }

    public String getString(int row, int col) {
        this.assertResultHasOutput();
        if (row < 0) {
            throw new IndexOutOfBoundsException(Integer.toString(row));
        }
        if (row >= this.getNumRows()) {
            throw new IndexOutOfBoundsException(Integer.toString(row));
        }
        if (col < 0) {
            throw new IndexOutOfBoundsException(Integer.toString(col));
        }
        if (col >= this.getNumColumns()) {
            throw new IndexOutOfBoundsException(Integer.toString(col));
        }
        return ((String[][])this.result.getOutput())[row][col];
    }

    public String getString(int row, String colName) {
        this.assertResultHasOutput();
        if (this.columnMap == null) {
            this.initialiseColumnMap();
        }
        if (!this.columnMap.containsKey(colName)) {
            throw new IndexOutOfBoundsException(colName);
        }
        return this.getString(row, this.columnMap.get(colName));
    }

    public Db2SqlQueryResultWrapper filter(int col, String value) {
        int numRows = 0;
        int i = 1;
        while (i < this.getNumRows()) {
            if (this.getString(i, col).equals(value)) {
                ++numRows;
            }
            ++i;
        }
        String[][] resultSubset = new String[numRows + 1][this.getNumColumns()];
        int rowIndex = 0;
        int i2 = 0;
        while (i2 < this.getNumRows()) {
            if (this.getString(i2, col).equals(value) || i2 == 0) {
                int j = 0;
                while (j < this.getNumColumns()) {
                    resultSubset[rowIndex][j] = this.getString(i2, j);
                    ++j;
                }
                ++rowIndex;
            }
            ++i2;
        }
        Result filteredResult = new Result((Object)resultSubset);
        filteredResult.addSubResult(this.result);
        Db2SqlQueryResultWrapper filteredResultWrapper = new Db2SqlQueryResultWrapper((Result<String[][]>)filteredResult);
        filteredResultWrapper.columnMap = this.columnMap;
        return filteredResultWrapper;
    }

    public Db2SqlQueryResultWrapper filter(String colName, String value) {
        if (this.columnMap == null) {
            this.initialiseColumnMap();
        }
        return this.filter(this.columnMap.get(colName), value);
    }

    public Db2SqlQueryResultWrapper removeRows(int col, String value) {
        int numRows = 0;
        int i = 1;
        while (i < this.getNumRows()) {
            if (!this.getString(i, col).equals(value)) {
                ++numRows;
            }
            ++i;
        }
        String[][] resultSubset = new String[numRows + 1][this.getNumColumns()];
        int rowIndex = 0;
        int i2 = 0;
        while (i2 < this.getNumRows()) {
            if (!this.getString(i2, col).equals(value) || i2 == 0) {
                int j = 0;
                while (j < this.getNumColumns()) {
                    resultSubset[rowIndex][j] = this.getString(i2, j);
                    ++j;
                }
                ++rowIndex;
            }
            ++i2;
        }
        Result filteredResult = new Result((Object)resultSubset);
        filteredResult.addSubResult(this.result);
        Db2SqlQueryResultWrapper filteredResultWrapper = new Db2SqlQueryResultWrapper((Result<String[][]>)filteredResult);
        filteredResultWrapper.columnMap = this.columnMap;
        return filteredResultWrapper;
    }

    public Db2SqlQueryResultWrapper removeRows(String colName, String value) {
        if (this.columnMap == null) {
            this.initialiseColumnMap();
        }
        return this.removeRows(this.columnMap.get(colName), value);
    }

    public void trim() {
        if (this.result == null) {
            return;
        }
        if (this.columnMap != null) {
            this.columnMap = null;
        }
        String[][] newResult = new String[this.getNumRows()][this.getNumColumns()];
        int i = 0;
        while (i < this.getNumRows()) {
            int j = 0;
            while (j < this.getNumColumns()) {
                newResult[i][j] = this.getString(i, j) == null ? null : Db2SqlQueryResultWrapper.trimTrailing(this.getString(i, j));
                ++j;
            }
            ++i;
        }
        this.result.setOutput((Object)newResult);
    }

    private static String trimTrailing(String string) {
        int i = string.length() - 1;
        while (i >= 0 && string.charAt(i) == ' ') {
            --i;
        }
        return string.substring(0, i + 1);
    }

    public List<String> getHeadings() {
        if (((String[][])this.result.getOutput()).length == 0) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(Arrays.asList(((String[][])this.result.getOutput())[0]));
    }

    private void assertResultHasOutput() {
        if (this.result.getOutput() == null) {
            throw new IllegalStateException();
        }
    }

    private void initialiseColumnMap() {
        this.columnMap = new HashMap<String, Integer>();
        int i = 0;
        while (i < this.getNumColumns()) {
            this.columnMap.put(this.getString(0, i), i);
            ++i;
        }
    }

    public Db2SqlQueryResultWrapper sort(String colName, boolean ascending) {
        if (this.columnMap == null) {
            this.initialiseColumnMap();
        }
        return this.sort(this.columnMap.get(colName), ascending);
    }

    public Db2SqlQueryResultWrapper sort(int col, boolean ascending) {
        List<String[]> rows = Db2SqlQueryResultWrapper.sort((String[][])this.getRawResult().getOutput(), col, ascending);
        String[][] newResultString = new String[this.getNumRows()][this.getNumColumns()];
        int i = 0;
        while (i < newResultString.length) {
            newResultString[i] = rows.get(i);
            ++i;
        }
        Result newResult = new Result((Object)newResultString);
        newResult.addSubResult(this.result);
        Db2SqlQueryResultWrapper newResultWrapper = new Db2SqlQueryResultWrapper((Result<String[][]>)newResult);
        return newResultWrapper;
    }

    private static List<String[]> sort(String[][] result, int col, boolean ascending) {
        LinkedList<String[]> rows = new LinkedList<String[]>();
        int i = 1;
        while (i < result.length) {
            rows.add(result[i]);
            ++i;
        }
        Collections.sort(rows, new Db2ColumnComparator(col));
        if (ascending) {
            rows.add(0, result[0]);
            return rows;
        }
        Collections.reverse(rows);
        rows.add(0, result[0]);
        return rows;
    }
}

