/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.core.model.db2;

import com.ibm.etools.fm.core.util.CollectionUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class Db2SqlQueryBuilder {
    private List<String> select = new ArrayList<String>();
    private List<String> from = new ArrayList<String>();
    private String where = null;
    private List<String> groupBy = new ArrayList<String>();
    private String having = null;
    private List<String> orderBy = new ArrayList<String>();

    public static String escapeSql(String sql) {
        Objects.requireNonNull(sql, "Must provide a non-null sql String.");
        return sql.replaceAll("'", "''");
    }

    public static String makeLikePattern(String string, boolean allowPartialMatch) {
        Objects.requireNonNull(string, "Please specify a non-null string.");
        if (allowPartialMatch) {
            string = (String)string + "%";
        }
        return Db2SqlQueryBuilder.escapeSql((String)string).replaceAll("\\*", "%");
    }

    public Db2SqlQueryBuilder select(String ... columns) {
        this.select.addAll(Arrays.asList(columns));
        return this;
    }

    public Db2SqlQueryBuilder from(String ... tables) {
        this.from.addAll(Arrays.asList(tables));
        return this;
    }

    public Db2SqlQueryBuilder where(OPERATOR operator, String condition) {
        Objects.requireNonNull(operator, "Must provide a non-null operator");
        Objects.requireNonNull(condition, "Must provide a non-null condition");
        if (operator == OPERATOR.AND) {
            this.where = this.where == null ? condition : String.valueOf(this.where) + " AND " + condition;
        } else if (operator == OPERATOR.OR) {
            this.where = this.where == null ? condition : String.valueOf(this.where) + " OR " + condition;
        }
        return this;
    }

    public Db2SqlQueryBuilder groupBy(String items) {
        this.groupBy.addAll(Arrays.asList(items));
        return this;
    }

    public Db2SqlQueryBuilder having(String conditions) {
        this.having = conditions;
        return this;
    }

    public Db2SqlQueryBuilder orderBy(String items) {
        this.orderBy.addAll(Arrays.asList(items));
        return this;
    }

    public String getSql() {
        return this.joinClauses(" ", ", ");
    }

    private String joinClauses(String clauseDelimiter, String columnDelimiter) {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT ");
        sb.append(CollectionUtils.join(this.select, columnDelimiter));
        sb.append(clauseDelimiter);
        sb.append("FROM ");
        sb.append(CollectionUtils.join(this.from, columnDelimiter));
        sb.append(clauseDelimiter);
        if (this.where != null && this.where.length() > 0) {
            sb.append("WHERE ");
            sb.append(this.where);
            sb.append(clauseDelimiter);
        }
        if (this.groupBy.size() > 0) {
            sb.append("GROUP BY ");
            sb.append(CollectionUtils.join(this.groupBy, columnDelimiter));
            sb.append(clauseDelimiter);
        }
        if (this.having != null && this.having.length() > 0) {
            sb.append("HAVING ");
            sb.append(this.having);
            sb.append(clauseDelimiter);
        }
        if (this.orderBy.size() > 0) {
            sb.append("ORDER BY ");
            sb.append(CollectionUtils.join(this.orderBy, columnDelimiter));
            sb.append(clauseDelimiter);
        }
        return sb.toString();
    }

    public String toString() {
        return this.joinClauses("\n", ",\n\t");
    }

    public static enum OPERATOR {
        AND,
        OR;

    }
}

