/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.core.model.db2;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.db2.Db2ObjectQueryAbstract;
import com.ibm.etools.fm.core.model.db2.Db2Schema;
import com.ibm.etools.fm.core.model.db2.Db2SqlQuery;
import com.ibm.etools.fm.core.model.db2.Db2SqlQueryBuilder;
import com.ibm.etools.fm.core.model.db2.Db2SqlQueryResultWrapper;
import com.ibm.etools.fm.core.model.db2.Db2Subsystem;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;

public class Db2SchemaQuery
extends Db2ObjectQueryAbstract<Db2Schema> {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final int NUMBER_OF_PATTERNS = 1;

    public Db2SchemaQuery(Db2Subsystem subSystem, Class<Db2Schema> type) {
        super(subSystem, type);
        this.patternList = new String[1];
    }

    public Db2SchemaQuery(Db2Subsystem subSystem, Class<Db2Schema> type, String[] patternList) {
        super(subSystem, type);
        this.setPatternList(patternList);
    }

    @Override
    public Db2ObjectQueryAbstract<Db2Schema> clone() {
        Db2SchemaQuery clone = new Db2SchemaQuery(this.subSystem, Db2Schema.class);
        clone.setPatternList(this.patternList);
        if (this.objects != null) {
            clone.objects = new ArrayList(this.objects);
        }
        return clone;
    }

    @Override
    public String[] getPatternList() {
        return this.patternList == null ? null : Arrays.copyOf(this.patternList, this.patternList.length);
    }

    @Override
    public String getSQLQuery() {
        String processedName = Db2SqlQueryBuilder.makeLikePattern(this.getNamePattern(), false);
        String statement = "SELECT SCHEMA FROM (SELECT VALUE(D.SCHEMA,R.SCHEMA,T.SCHEMA,Q.SCHEMA, TAB.SCHEMA) AS SCHEMA FROM ((SELECT SCHEMA FROM SYSIBM.SYSDATATYPES T GROUP BY SCHEMA) D FULL OUTER JOIN (SELECT SCHEMA FROM SYSIBM.SYSROUTINES T GROUP BY SCHEMA) R ON D.SCHEMA=R.SCHEMA FULL OUTER JOIN(SELECT SCHEMA FROM SYSIBM.SYSTRIGGERS T GROUP BY SCHEMA) T ON D.SCHEMA=T.SCHEMA AND R.SCHEMA=T.SCHEMA FULL OUTER JOIN (SELECT SCHEMA FROM SYSIBM.SYSSEQUENCES T WHERE T.SEQTYPE='S' GROUP BY SCHEMA) Q ON D.SCHEMA=Q.SCHEMA AND R.SCHEMA=Q.SCHEMA AND T.SCHEMA=Q.SCHEMA FULL OUTER JOIN (SELECT CREATOR AS SCHEMA FROM SYSIBM.SYSTABLES T GROUP BY CREATOR) TAB ON D.SCHEMA=TAB.SCHEMA AND R.SCHEMA=TAB.SCHEMA AND T.SCHEMA=TAB.SCHEMA AND Q.SCHEMA=TAB.SCHEMA)) X WHERE SCHEMA LIKE '" + processedName + "' GROUP BY SCHEMA";
        return statement;
    }

    @Override
    public String getLabel() {
        if ("CURRENT_USERNAME_QUERY".equals(this.getOwnerPatternRaw())) {
            return Messages.Db2SchemaQuery_MySchemas;
        }
        String namePattern = this.getNamePattern().isEmpty() ? "*" : this.getNamePattern();
        return MessageFormat.format(Messages.SystemsLabelProvider_DATABASES_X_Y, namePattern);
    }

    public void setNamePattern(String schemaPattern) {
        this.initialisePatternListIfNull();
        this.patternList[0] = schemaPattern;
    }

    public String getNamePattern() {
        return this.patternList == null ? null : this.patternList[0];
    }

    @Override
    public Result<?> loadObjects(IHowIsGoing monitor) throws InterruptedException {
        Db2SqlQuery sqlQuery = new Db2SqlQuery(this.subSystem, this.getSQLQuery());
        Result<String[][]> result = sqlQuery.execute(monitor);
        if (result.getOutput() == null) {
            return result;
        }
        Db2SqlQueryResultWrapper sqlResult = new Db2SqlQueryResultWrapper(result);
        ArrayList<Db2Schema> objects = new ArrayList<Db2Schema>();
        int i = 1;
        while (i < sqlResult.getNumRows()) {
            String name = sqlResult.getString(i, 0);
            Db2Schema schema = new Db2Schema(this.subSystem, name);
            objects.add((Db2Schema)this.castToQueryObjectType(schema));
            ++i;
        }
        this.setObjects(objects);
        return sqlResult.getRawResult();
    }

    @Override
    protected void initialisePatternListIfNull() {
        if (this.patternList == null) {
            this.patternList = new String[1];
        }
    }
}

