/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.core.model.db2;

import com.ibm.etools.fm.core.model.db2.Db2Object;
import com.ibm.etools.fm.core.model.db2.Db2Subsystem;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;

public class Db2Schema
extends Db2Object {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    public static final String PATTERN_VALID_NAME = ".+";
    private static final Pattern validNameRegexp = Pattern.compile(".+");

    public Db2Schema(Db2Subsystem subsystem, String name) {
        super(subsystem, name);
        if (!Db2Schema.isValidName(subsystem.getSystem(), name)) {
            throw new IllegalArgumentException("name='" + (name == null ? "null" : name) + "'");
        }
    }

    public static boolean isValidName(IPDHost host, String name) {
        Objects.requireNonNull(name, "Please provide a non-null name.");
        if (name.length() > 128) {
            return false;
        }
        String nameCheck = null;
        try {
            nameCheck = new String(name.getBytes(host.getCodePage()), host.getCommunicationCodePage());
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return validNameRegexp.matcher(nameCheck).matches();
    }

    public String getFormattedName() {
        return this.getName();
    }

    @Override
    public Db2Object clone() {
        Db2Schema copy = new Db2Schema(this.getSubsystem(), this.getName());
        for (Map.Entry<Object, Object> entry : this.properties.entrySet()) {
            copy.setPersistentProperty(entry.getKey().toString(), entry.getValue().toString());
        }
        return copy;
    }
}

