/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.core.model.db2;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.db2.Db2Object;
import com.ibm.etools.fm.core.model.db2.Db2ObjectQueryAbstract;
import com.ibm.etools.fm.core.model.db2.Db2Routine;
import com.ibm.etools.fm.core.model.db2.Db2SqlQuery;
import com.ibm.etools.fm.core.model.db2.Db2SqlQueryBuilder;
import com.ibm.etools.fm.core.model.db2.Db2SqlQueryResultWrapper;
import com.ibm.etools.fm.core.model.db2.Db2Subsystem;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;

public class Db2RoutineQuery
extends Db2ObjectQueryAbstract<Db2Routine> {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final int NUMBER_OF_PATTERNS = 2;

    public Db2RoutineQuery(Db2Subsystem subSystem, Class<Db2Routine> type) {
        super(subSystem, type);
        this.setPatternList(new String[2]);
    }

    public Db2RoutineQuery(Db2Subsystem subSystem, Class<Db2Routine> type, String[] patternList) {
        super(subSystem, type);
        this.setPatternList(patternList);
    }

    @Override
    public Db2ObjectQueryAbstract<Db2Routine> clone() {
        Db2RoutineQuery clone = new Db2RoutineQuery(this.subSystem, Db2Routine.class);
        clone.setPatternList(this.patternList);
        if (this.objects != null) {
            clone.objects = new ArrayList(this.objects);
        }
        return clone;
    }

    @Override
    public String[] getPatternList() {
        return this.patternList == null ? null : Arrays.copyOf(this.patternList, this.patternList.length);
    }

    @Override
    public String getSQLQuery() {
        String processedOwner = null;
        processedOwner = "CURRENT_USERNAME_QUERY".equals(this.getOwnerPatternRaw()) ? this.getOwnerPattern() : Db2SqlQueryBuilder.makeLikePattern(this.getOwnerPatternRaw(), false);
        String processedName = Db2SqlQueryBuilder.makeLikePattern(this.getNamePattern(), false);
        Db2SqlQueryBuilder statement = new Db2SqlQueryBuilder();
        statement.select("SPECIFICNAME", "SCHEMA", "ORIGIN", "FUNCTION_TYPE", "ROUTINETYPE", "LANGUAGE").from("SYSIBM.SYSROUTINES");
        if (!this.getOwnerPatternRaw().isEmpty()) {
            statement.where(Db2SqlQueryBuilder.OPERATOR.AND, MessageFormat.format("SCHEMA LIKE ''{0}''", processedOwner));
        }
        if (!this.getNamePattern().isEmpty()) {
            statement.where(Db2SqlQueryBuilder.OPERATOR.AND, MessageFormat.format("SPECIFICNAME LIKE ''{0}''", processedName));
        }
        return statement.getSql();
    }

    @Override
    public String getLabel() {
        String savedSchemaPattern = this.getOwnerPatternRaw();
        if ("CURRENT_USERNAME_QUERY".equals(savedSchemaPattern)) {
            return Messages.Db2RoutineQuery_MyTables;
        }
        String schemaPattern = savedSchemaPattern.isEmpty() ? "*" : savedSchemaPattern;
        String namePattern = this.getNamePattern().isEmpty() ? "*" : this.getNamePattern();
        return MessageFormat.format(Messages.SystemsLabelProvider_TABLES_X_Y_Z, schemaPattern, namePattern);
    }

    public void setNamePattern(String namePattern) {
        this.initialisePatternListIfNull();
        this.patternList[1] = namePattern;
    }

    public String getNamePattern() {
        return this.patternList == null ? null : this.patternList[1];
    }

    public static <U extends Db2Object> Db2RoutineQuery create(Db2Subsystem subsys, Class<Db2Routine> type) {
        Objects.requireNonNull(subsys, "Must provide a non-null Db2Subsystem.");
        return new Db2RoutineQuery(subsys, type);
    }

    @Override
    public Result<?> loadObjects(IHowIsGoing monitor) throws InterruptedException {
        Db2SqlQuery sqlQuery = new Db2SqlQuery(this.subSystem, this.getSQLQuery());
        Result<String[][]> result = sqlQuery.execute(monitor);
        if (result.getOutput() == null) {
            return result;
        }
        Db2SqlQueryResultWrapper sqlResult = new Db2SqlQueryResultWrapper(result);
        ArrayList<Db2Routine> objects = new ArrayList<Db2Routine>();
        int i = 1;
        while (i < sqlResult.getNumRows()) {
            String name = sqlResult.getString(i, 0);
            String schema = sqlResult.getString(i, 1);
            String[] routineType = Db2Routine.getRoutineTypeName(sqlResult.getString(i, 2), sqlResult.getString(i, 3), sqlResult.getString(i, 4), sqlResult.getString(i, 5));
            if (!Db2Routine.RoutineType.NONE.getName().equals(routineType[0])) {
                Db2Routine routine = new Db2Routine(this.subSystem, name, schema);
                routine.setCreator(schema);
                routine.setRoutineType(routineType[0]);
                routine.setRoutineLanguage(routineType[1]);
                objects.add((Db2Routine)this.castToQueryObjectType(routine));
            }
            ++i;
        }
        this.setObjects(objects);
        return sqlResult.getRawResult();
    }

    @Override
    protected void initialisePatternListIfNull() {
        if (this.patternList == null) {
            this.patternList = new String[2];
        }
    }
}

