/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.core.model.db2;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.db2.Db2Object;
import com.ibm.etools.fm.core.model.db2.Db2Subsystem;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;

public class Db2Routine
extends Db2Object {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    protected static final PDLogger logger = PDLogger.get(Db2Routine.class);
    public static final String PATTERN_VALID_NAME = ".+";
    private static final Pattern validNameRegexp = Pattern.compile(".+");
    public static final String PATTERN_VALID_CREATOR = "[A-Z0-9]+";
    private static final Pattern validcreatorRegexp = Pattern.compile("[A-Z0-9]+");
    private String creator = "";
    private String routineType = "";
    private String routineLanguage = "";

    public Db2Routine(Db2Subsystem subsystem, String name) {
        super(subsystem, name);
        if (!Db2Routine.isValidName(subsystem.getSystem(), name)) {
            throw new IllegalArgumentException("name='" + (name == null ? "null" : name) + "'");
        }
    }

    public Db2Routine(Db2Subsystem subsystem, String name, String creator) {
        super(subsystem, name);
        if (!Db2Routine.isValidName(subsystem.getSystem(), name)) {
            throw new IllegalArgumentException("name='" + (name == null ? "null" : name) + "'");
        }
        if (Db2Routine.isValidCreator(subsystem.getSystem(), creator)) {
            this.setCreator(creator);
        }
    }

    public static boolean isValidCreator(IPDHost host, String creator) {
        Objects.requireNonNull(creator, "Please provide a non-null creator.");
        String nameCheck = null;
        try {
            nameCheck = new String(creator.getBytes(host.getCodePage()), host.getCommunicationCodePage());
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return validcreatorRegexp.matcher(nameCheck).matches();
    }

    public static boolean isValidName(IPDHost host, String name) {
        Objects.requireNonNull(name, "Please provide a non-null name.");
        if (name.length() > 128) {
            return false;
        }
        String nameCheck = null;
        try {
            nameCheck = new String(name.getBytes(host.getCodePage()), host.getCommunicationCodePage());
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return validNameRegexp.matcher(nameCheck).matches();
    }

    public String getFormattedName() {
        return this.getCreator() + "." + this.getName();
    }

    public String toString() {
        return this.getFormattedName();
    }

    @Override
    public Db2Object clone() {
        Db2Routine copy = new Db2Routine(this.getSubsystem(), this.getName());
        for (Map.Entry<Object, Object> entry : this.properties.entrySet()) {
            copy.setPersistentProperty(entry.getKey().toString(), entry.getValue().toString());
        }
        return copy;
    }

    public String getCreator() {
        return this.creator;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public String getRoutineType() {
        return this.routineType;
    }

    public void setRoutineType(String routineType) {
        this.routineType = routineType;
    }

    public static RoutineType getRoutineType(String origin, String functionType, String routineType, String language) {
        if ("F".equals(routineType)) {
            if ("E".equals(origin) && "S".equals(functionType)) {
                return RoutineType.FUNCTION_EXT_SCALAR;
            }
            if ("E".equals(origin) && "T".equals(functionType)) {
                return RoutineType.FUNCTION_EXT_TABLE;
            }
            if ("U".equals(origin)) {
                return RoutineType.FUNCTION_SOURCED;
            }
            if ("Q".equals(origin) && "S".equals(functionType)) {
                return RoutineType.FUNCTION_SQL_SCALAR;
            }
            if ("Q".equals(origin) && "T".equals(functionType)) {
                return RoutineType.FUNCTION_SQL_TABLE;
            }
        } else if ("P".equals(routineType)) {
            if ("N".equals(origin)) {
                return RoutineType.PROC_SQL_NATIVE;
            }
            if ("E".equals(origin) && "SQL".equals(language)) {
                return RoutineType.PROC_SQL_EXT;
            }
            if ("E".equals(origin)) {
                return RoutineType.PROC_EXT;
            }
        }
        logger.error((Object)"Routine type not supported.");
        return RoutineType.NONE;
    }

    public static String[] getRoutineTypeName(String origin, String functionType, String routineType, String language) {
        String[] temp = new String[2];
        RoutineType type = Db2Routine.getRoutineType(origin, functionType, routineType, language);
        temp[0] = type.getName();
        temp[1] = language;
        return temp;
    }

    public void setRoutineLanguage(String routineLanguage) {
        this.routineLanguage = routineLanguage;
    }

    public String getRoutineLanguage() {
        return this.routineLanguage;
    }

    @Override
    public String getPDLabel() {
        return this.getName();
    }

    @Override
    public String getPDPluginId() {
        return "com.ibm.etools.fm.ui";
    }

    public static enum RoutineType {
        NONE(Messages.Db2Routine_None),
        FUNCTION_EXT_SCALAR(Messages.Db2Routine_FnExtScaler),
        FUNCTION_EXT_TABLE(Messages.Db2Routine_FnExtTable),
        FUNCTION_SOURCED(Messages.Db2Routine_FnSourced),
        FUNCTION_SQL_SCALAR(Messages.Db2Routine_FnSQLScalar),
        FUNCTION_SQL_TABLE(Messages.Db2Routine_FnSQLTable),
        PROC_EXT(Messages.Db2Routine_StoredProcExternal),
        PROC_SQL_EXT(Messages.Db2Routine_StoredProcSQLExternal),
        PROC_SQL_NATIVE(Messages.Db2Routine_StoredSQLNative);

        private final String name;

        private RoutineType(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public boolean isFunction() {
            return 'F' == this.name.charAt(0);
        }

        public boolean isProcedure() {
            return 'S' == this.name.charAt(0);
        }

        public boolean isSQL() {
            return this.name.matches(".*SQL.*");
        }
    }
}

