/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.core.model.db2;

import com.ibm.etools.fm.core.model.db2.Db2Database;
import com.ibm.etools.fm.core.model.db2.Db2Object;
import com.ibm.etools.fm.core.model.db2.Db2Routine;
import com.ibm.etools.fm.core.model.db2.Db2Subsystem;
import com.ibm.etools.fm.core.model.db2.Db2SubsystemProvider;
import com.ibm.etools.fm.core.model.db2.Db2Table;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.model.PDPlatformObject;
import com.ibm.pdtools.common.component.jhost.comms.AuthDetails;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.registery.EListener;
import com.ibm.pdtools.common.component.jhost.registery.EntityEvent;
import com.ibm.pdtools.common.component.jhost.registery.EntityEventDispatcher;
import com.ibm.pdtools.common.component.jhost.registery.IEntityEventDispatcher;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import com.ibm.pdtools.common.component.jhost.util.StringUtils;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public abstract class Db2ObjectQueryAbstract<T extends Db2Object>
extends PDPlatformObject
implements Db2SubsystemProvider,
IEntityEventDispatcher<Db2ObjectQueryAbstract<T>> {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final String MULTI_CHAR_WILDCARD = "*";
    private static final String MULTI_CHAR_WILDCARD_ALT = "%";
    private static final String SINGLE_CHAR_WILDCARD = "_";
    protected static final String BROWSE_PLACEHOLDER = "CURRENT_USERNAME_QUERY";
    private static final Object PROPERTY_LOADED_OBJECTS = new Object();
    private static final Object PROPERTY_OWNER_PATTERN = new Object();
    private static final Object PROPERTY_NAME_PATTERN = new Object();
    private static final Object PROPERTY_DATABASE_PATTERN = new Object();
    protected final Db2Subsystem subSystem;
    protected String[] patternList;
    private final Class<T> type;
    protected List<T> objects = null;
    private final EntityEventDispatcher<Db2ObjectQueryAbstract<T>> eventDispatcher = new EntityEventDispatcher((Object)this);
    private static final PDLogger logger = PDLogger.get(Db2ObjectQueryAbstract.class);

    public static String stripWildcards(String pattern) {
        return pattern.replaceAll(StringUtils.escapeRegex((String)MULTI_CHAR_WILDCARD), "").replaceAll(StringUtils.escapeRegex((String)MULTI_CHAR_WILDCARD_ALT), "").replaceAll(StringUtils.escapeRegex((String)SINGLE_CHAR_WILDCARD), "");
    }

    public Db2ObjectQueryAbstract(Db2Subsystem subSystem, Class<T> type) {
        this.subSystem = Objects.requireNonNull(subSystem, "Please specify a non-null subSystem.");
        this.type = type;
    }

    public abstract Db2ObjectQueryAbstract<T> clone();

    public boolean equals(Object obj) {
        if (obj instanceof Db2ObjectQueryAbstract) {
            Db2ObjectQueryAbstract otherQuery = (Db2ObjectQueryAbstract)obj;
            if (!this.subSystem.equals(otherQuery.subSystem)) {
                return false;
            }
            if (!this.type.equals(otherQuery.type)) {
                return false;
            }
            if (this.patternList.length != otherQuery.getPatternList().length) {
                return false;
            }
            int i = 0;
            while (i < this.patternList.length) {
                if (this.patternList[i].equals(otherQuery.getPatternList()[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public Object[] getPatternListRaw() {
        return this.patternList == null ? null : Arrays.copyOf(this.patternList, this.patternList.length);
    }

    public void setPatternList(String[] patternList) {
        this.patternList = patternList == null ? null : Arrays.copyOf(patternList, patternList.length);
    }

    public abstract String[] getPatternList();

    public int hashCode() {
        return this.subSystem.hashCode() * this.patternList.hashCode() * this.type.hashCode();
    }

    private static String emptyIfIsJustWildcards(String pattern) {
        String noWildcards = pattern.replaceAll(StringUtils.escapeRegex((String)MULTI_CHAR_WILDCARD), "");
        if ((noWildcards = noWildcards.replaceAll(StringUtils.escapeRegex((String)MULTI_CHAR_WILDCARD_ALT), "")).isEmpty()) {
            return "";
        }
        return pattern;
    }

    public Class<T> getType() {
        return this.type;
    }

    public IPDHost getSystem() {
        return this.subSystem.getSystem();
    }

    @Override
    public Db2Subsystem getSubsystem() {
        return this.subSystem;
    }

    public void setObjects(List<T> objects) {
        this.objects = objects;
        this.eventDispatcher.fireChangedEvent(PROPERTY_LOADED_OBJECTS);
    }

    public List<T> getObjects() {
        return this.objects == null ? null : Collections.unmodifiableList(this.objects);
    }

    public void setOwnerPattern(String ownerPattern) {
        this.initialisePatternListIfNull();
        this.patternList[0] = ownerPattern;
    }

    public String getOwnerPatternRaw() {
        return this.patternList == null ? null : this.patternList[0];
    }

    protected abstract void initialisePatternListIfNull();

    public String getOwnerPattern() {
        String resolvedOwnerPattern = this.patternList[0];
        if (resolvedOwnerPattern.equals(BROWSE_PLACEHOLDER)) {
            AuthDetails details = null;
            try {
                details = this.getSystem().getLogin(false);
            }
            catch (Exception e) {
                logger.trace((Object)"Error getting login for browse db2 objects query in getOwnerPattern()", (Throwable)e);
                details = null;
            }
            if (details != null) {
                resolvedOwnerPattern = details.getUsername();
                logger.trace((Object)("Db2 browse query resolved: " + this.patternList[0] + " -> " + resolvedOwnerPattern));
            } else {
                resolvedOwnerPattern = MULTI_CHAR_WILDCARD;
                logger.debug((Object)MessageFormat.format("Couldn''t resolve db2 browse query {0} because user has not provided username", this.patternList[0]));
            }
        }
        return resolvedOwnerPattern;
    }

    public abstract Result<?> loadObjects(IHowIsGoing var1) throws InterruptedException;

    protected T castToQueryObjectType(Db2Object object) {
        if (!this.type.equals(object.getClass())) {
            throw new IllegalArgumentException();
        }
        return (T)object;
    }

    public abstract String getSQLQuery();

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{Db2Query: Type=");
        sb.append(this.getType().getSimpleName());
        int i = 0;
        while (i < this.patternList.length) {
            if (!this.patternList[i].isEmpty()) {
                sb.append(" Pattern " + i + "=" + this.patternList[i]);
            }
            ++i;
        }
        sb.append("}");
        return sb.toString();
    }

    public abstract String getLabel();

    public void addListener(EListener<EntityEvent<Db2ObjectQueryAbstract<T>>> listener) {
        this.eventDispatcher.addListener(listener);
    }

    public void removeListener(EListener<EntityEvent<Db2ObjectQueryAbstract<T>>> listener) {
        this.eventDispatcher.removeListener(listener);
    }

    public String getPDImageName() {
        Class<T> type = this.getType();
        if (Db2Database.class.equals(type)) {
            return "db2_database_query";
        }
        if (Db2Routine.class.equals(type)) {
            return "db2_routine_query";
        }
        if (Db2Table.class.equals(type)) {
            return "db2_table_query";
        }
        return "";
    }

    public String getPDLabel() {
        return this.getLabel();
    }

    public String getPDPluginId() {
        return "com.ibm.etools.fm.ui";
    }
}

