/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.core.model.db2;

import com.ibm.etools.fm.core.FMCorePlugin;
import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.db2.Db2Database;
import com.ibm.etools.fm.core.model.db2.Db2Object;
import com.ibm.etools.fm.core.model.db2.Db2SqlQuery;
import com.ibm.etools.fm.core.model.db2.Db2SqlQueryBuilder;
import com.ibm.etools.fm.core.model.db2.Db2SqlQueryResultWrapper;
import com.ibm.etools.fm.core.model.db2.Db2Subsystem;
import com.ibm.etools.fm.core.model.db2.Db2SubsystemProvider;
import com.ibm.etools.fm.core.model.db2.Db2Table;
import com.ibm.etools.fm.core.model.db2.Db2TableType;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.model.ISystemsDecoratingLabelProvider;
import com.ibm.pdtools.common.component.core.model.PDPlatformObject;
import com.ibm.pdtools.common.component.jhost.comms.AuthDetails;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.registery.EListener;
import com.ibm.pdtools.common.component.jhost.registery.EntityEvent;
import com.ibm.pdtools.common.component.jhost.registery.EntityEventDispatcher;
import com.ibm.pdtools.common.component.jhost.registery.IEntityEventDispatcher;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import com.ibm.pdtools.common.component.jhost.util.StringUtils;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class Db2ObjectQuery<T extends Db2Object>
extends PDPlatformObject
implements Db2SubsystemProvider,
IEntityEventDispatcher<Db2ObjectQuery<T>>,
ISystemsDecoratingLabelProvider {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    public static final String MULTI_CHAR_WILDCARD = "*";
    public static final String MULTI_CHAR_WILDCARD_ALT = "%";
    public static final String SINGLE_CHAR_WILDCARD = "_";
    public static final String BROWSE_PLACEHOLDER = "CURRENT_USERNAME_QUERY";
    public static final Object PROPERTY_LOADED_OBJECTS = new Object();
    public static final Object PROPERTY_OWNER_PATTERN = new Object();
    public static final Object PROPERTY_NAME_PATTERN = new Object();
    public static final Object PROPERTY_DATABASE_PATTERN = new Object();
    private final Db2Subsystem subSystem;
    private String ownerPattern = "";
    private String namePattern = "";
    private String databasePattern = "";
    private final Class<T> type;
    private List<T> objects = null;
    private final EntityEventDispatcher<Db2ObjectQuery<T>> eventDispatcher = new EntityEventDispatcher((Object)this);
    private static final PDLogger logger = PDLogger.get(Db2ObjectQuery.class);

    public static <U extends Db2Object> Db2ObjectQuery<U> create(Db2Subsystem subsys, Class<U> type) {
        return new Db2ObjectQuery<U>(subsys, type);
    }

    public static String stripWildcards(String pattern) {
        Objects.requireNonNull(pattern, "Must provide a non-null pattern.");
        return pattern.replaceAll(StringUtils.escapeRegex((String)MULTI_CHAR_WILDCARD), "").replaceAll(StringUtils.escapeRegex((String)MULTI_CHAR_WILDCARD_ALT), "").replaceAll(StringUtils.escapeRegex((String)SINGLE_CHAR_WILDCARD), "");
    }

    public static boolean isValidOwnerPattern(String ownerPattern) {
        Objects.requireNonNull(ownerPattern, "Please specify a non-null ownerPattern.");
        return true;
    }

    public static boolean isValidNamePattern(String namePattern) {
        Objects.requireNonNull(namePattern, "Please provide a non-null namePattern.");
        return true;
    }

    public static boolean isValidDatabasePattern(String databasePattern) {
        Objects.requireNonNull(databasePattern, "Please specify a non-null databasePattern.");
        return true;
    }

    public static <E extends Db2Object> Db2ObjectQuery<E> createBrowseUser(Db2Subsystem subSystem, Class<E> type) {
        Db2ObjectQuery<E> query = new Db2ObjectQuery<E>(subSystem, type);
        query.ownerPattern = BROWSE_PLACEHOLDER;
        return query;
    }

    public static Db2ObjectQuery<Db2Table> createBrowseUserForDatabase(Db2Database db) {
        Objects.requireNonNull(db, "Must provide a non-null db.");
        Db2ObjectQuery<Db2Table> tableQuery = new Db2ObjectQuery<Db2Table>(db.getSubsystem(), Db2Table.class);
        tableQuery.ownerPattern = BROWSE_PLACEHOLDER;
        tableQuery.setDatabasePattern(db.getName());
        return tableQuery;
    }

    public Db2ObjectQuery(Db2Subsystem subSystem, Class<T> type) {
        Objects.requireNonNull(subSystem, "Please provide a non-null subsystem.");
        this.subSystem = subSystem;
        this.type = type;
    }

    public Db2ObjectQuery<T> clone() {
        Db2ObjectQuery<T> clone = new Db2ObjectQuery<T>(this.subSystem, this.type);
        clone.setOwnerPattern(this.ownerPattern);
        clone.setNamePattern(this.namePattern);
        clone.setDatabasePattern(this.databasePattern);
        if (this.objects != null) {
            clone.objects = new ArrayList<T>(this.objects);
        }
        return clone;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Db2ObjectQuery) {
            Db2ObjectQuery otherQuery = (Db2ObjectQuery)obj;
            if (!this.subSystem.equals(otherQuery.subSystem)) {
                return false;
            }
            if (!this.ownerPattern.equals(otherQuery.ownerPattern)) {
                return false;
            }
            if (!this.namePattern.equals(otherQuery.namePattern)) {
                return false;
            }
            if (!this.databasePattern.equals(otherQuery.databasePattern)) {
                return false;
            }
            return this.type.equals(otherQuery.type);
        }
        return false;
    }

    public int hashCode() {
        return this.subSystem.hashCode() * this.ownerPattern.hashCode() * this.namePattern.hashCode() * this.databasePattern.hashCode() * this.type.hashCode();
    }

    public void setOwnerPattern(String pattern) {
        if (!Db2ObjectQuery.isValidOwnerPattern(pattern)) {
            throw new IllegalArgumentException(pattern);
        }
        this.ownerPattern = Db2ObjectQuery.emptyIfIsJustWildcards(pattern);
        this.eventDispatcher.fireChangedEvent(PROPERTY_OWNER_PATTERN);
    }

    private static String emptyIfIsJustWildcards(String pattern) {
        String noWildcards = pattern.replaceAll(StringUtils.escapeRegex((String)MULTI_CHAR_WILDCARD), "");
        if ((noWildcards = noWildcards.replaceAll(StringUtils.escapeRegex((String)MULTI_CHAR_WILDCARD_ALT), "")).isEmpty()) {
            return "";
        }
        return pattern;
    }

    public String getOwnerPattern() {
        String resolvedOwnerPattern = this.ownerPattern;
        if (resolvedOwnerPattern.equals(BROWSE_PLACEHOLDER)) {
            AuthDetails details = null;
            try {
                details = this.getSystem().getLogin(false);
            }
            catch (Exception e) {
                logger.trace((Object)"Error getting login for browse db2 objects query in getOwnerPattern()", (Throwable)e);
                details = null;
            }
            if (details != null) {
                String username = details.getUsername();
                resolvedOwnerPattern = username.toUpperCase();
                logger.trace((Object)("Db2 browse query resolved: " + this.ownerPattern + " -> " + resolvedOwnerPattern));
            } else {
                resolvedOwnerPattern = MULTI_CHAR_WILDCARD;
                logger.debug((Object)("Couldn't resolve db2 browse query " + this.ownerPattern + " because user has not provided username"));
            }
        }
        return resolvedOwnerPattern;
    }

    public String getRawOwnerPattern() {
        return this.ownerPattern;
    }

    public void setNamePattern(String pattern) {
        if (!Db2ObjectQuery.isValidNamePattern(pattern)) {
            throw new IllegalArgumentException(pattern);
        }
        this.namePattern = Db2ObjectQuery.emptyIfIsJustWildcards(pattern);
        this.eventDispatcher.fireChangedEvent(PROPERTY_NAME_PATTERN);
    }

    public String getNamePattern() {
        return this.namePattern;
    }

    public void setDatabasePattern(String pattern) {
        if (!Db2ObjectQuery.isValidDatabasePattern(pattern)) {
            throw new IllegalArgumentException();
        }
        this.databasePattern = Db2ObjectQuery.emptyIfIsJustWildcards(pattern);
        this.eventDispatcher.fireChangedEvent(PROPERTY_DATABASE_PATTERN);
    }

    public String getDatabasePattern() {
        return this.databasePattern;
    }

    public Class<T> getType() {
        return this.type;
    }

    public IPDHost getSystem() {
        return this.subSystem.getSystem();
    }

    public void setSystem(IPDHost system) {
        this.subSystem.setSystem(system);
    }

    @Override
    public Db2Subsystem getSubsystem() {
        return this.subSystem;
    }

    public void setObjects(List<T> objects) {
        this.objects = objects;
        this.eventDispatcher.fireChangedEvent(PROPERTY_LOADED_OBJECTS);
    }

    public List<T> getObjects() {
        if (this.objects == null) {
            return this.objects;
        }
        return Collections.unmodifiableList(this.objects);
    }

    public Result<?> loadObjects(IHowIsGoing monitor) throws InterruptedException {
        Db2SqlQuery sqlQuery = new Db2SqlQuery(this.subSystem, this.getSQLQuery());
        Result<String[][]> result = sqlQuery.execute(monitor);
        if (result.getOutput() == null) {
            return result;
        }
        Db2SqlQueryResultWrapper sqlResult = new Db2SqlQueryResultWrapper(result);
        ArrayList<T> objects = new ArrayList<T>();
        int i = 1;
        while (i < sqlResult.getNumRows()) {
            if (Db2Table.class.equals(this.type)) {
                String dbname = sqlResult.getString(i, 0);
                String name = sqlResult.getString(i, 1);
                String creator = sqlResult.getString(i, 2);
                String tableSpace = sqlResult.getString(i, 3);
                Db2TableType type = Db2TableType.fromDB2Rep(sqlResult.getString(i, 4));
                Db2Table table = new Db2Table(this.subSystem, name, creator);
                table.setDatabaseName(dbname);
                table.setTableSpaceName(tableSpace);
                table.setType(type);
                objects.add(this.castToQueryObjectType(table));
            } else if (Db2Database.class.equals(this.type)) {
                String name = sqlResult.getString(i, 0);
                String creator = sqlResult.getString(i, 1);
                Db2Database database = new Db2Database(this.subSystem, name);
                database.setCreator(creator);
                objects.add(this.castToQueryObjectType(database));
            }
            ++i;
        }
        this.setObjects(objects);
        return sqlResult.getRawResult();
    }

    private T castToQueryObjectType(Db2Object object) {
        if (!this.type.equals(object.getClass())) {
            throw new IllegalArgumentException();
        }
        return (T)object;
    }

    private String getSQLQuery() {
        String processedOwner = null;
        processedOwner = BROWSE_PLACEHOLDER.equals(this.ownerPattern) ? this.getOwnerPattern() : Db2SqlQueryBuilder.makeLikePattern(this.ownerPattern, false);
        String processedName = Db2SqlQueryBuilder.makeLikePattern(this.namePattern, false);
        String processedDb = Db2SqlQueryBuilder.makeLikePattern(this.databasePattern, false);
        if (Db2Table.class.equals(this.type)) {
            Db2SqlQueryBuilder statement = new Db2SqlQueryBuilder();
            statement.select("TB.DBNAME", "TB.NAME", "TB.CREATOR", "TB.TSNAME", "TB.TYPE").from("SYSIBM.SYSTABLES TB");
            if (!this.ownerPattern.isEmpty()) {
                if (FMCorePlugin.isDb2RtrimCreatorInWhere()) {
                    statement.where(Db2SqlQueryBuilder.OPERATOR.AND, "RTRIM(TB.CREATOR) LIKE RTRIM('" + processedOwner + "')");
                } else {
                    statement.where(Db2SqlQueryBuilder.OPERATOR.AND, "TB.CREATOR LIKE '" + processedOwner + "'");
                }
            }
            if (!this.namePattern.isEmpty()) {
                statement.where(Db2SqlQueryBuilder.OPERATOR.AND, "TB.NAME LIKE '" + processedName + "'");
            }
            if (!this.databasePattern.isEmpty()) {
                statement.where(Db2SqlQueryBuilder.OPERATOR.AND, "TB.DBNAME LIKE '" + processedDb + "'");
            }
            return statement.getSql();
        }
        if (Db2Database.class.equals(this.type)) {
            Db2SqlQueryBuilder statement = new Db2SqlQueryBuilder();
            statement.select("NAME", "CREATOR").from("SYSIBM.SYSDATABASE DB");
            if (!this.ownerPattern.isEmpty()) {
                if (FMCorePlugin.isDb2RtrimCreatorInWhere()) {
                    statement.where(Db2SqlQueryBuilder.OPERATOR.AND, "RTRIM(DB.CREATOR) LIKE RTRIM('" + processedOwner + "')");
                } else {
                    statement.where(Db2SqlQueryBuilder.OPERATOR.AND, "DB.CREATOR LIKE '" + processedOwner + "'");
                }
            }
            if (!this.namePattern.isEmpty()) {
                statement.where(Db2SqlQueryBuilder.OPERATOR.AND, "DB.NAME LIKE '" + processedName + "'");
            }
            return statement.getSql();
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{Db2Query: Type=");
        sb.append(this.getType().getSimpleName());
        if (!this.ownerPattern.isEmpty()) {
            sb.append(" Owner=");
            sb.append(this.ownerPattern);
        }
        if (!this.namePattern.isEmpty()) {
            sb.append(" Name=");
            sb.append(this.namePattern);
        }
        if (!this.databasePattern.isEmpty()) {
            sb.append(" Database=");
            sb.append(this.databasePattern);
        }
        sb.append("}");
        return sb.toString();
    }

    public String getLabel() {
        String databasePattern;
        String savedOwnerPattern = this.ownerPattern;
        if (BROWSE_PLACEHOLDER.equals(savedOwnerPattern)) {
            if (Db2Database.class.equals(this.getType())) {
                return Messages.Db2ObjectQuery_MyDatabases;
            }
            if (Db2Table.class.equals(this.getType())) {
                return Messages.Db2ObjectQuery_MyTables;
            }
            return Messages._UNKNOWN;
        }
        String ownerPattern = savedOwnerPattern.isEmpty() ? MULTI_CHAR_WILDCARD : savedOwnerPattern;
        String namePattern = this.getNamePattern().isEmpty() ? MULTI_CHAR_WILDCARD : this.getNamePattern();
        String string = databasePattern = this.getDatabasePattern().isEmpty() ? MULTI_CHAR_WILDCARD : this.getDatabasePattern();
        if (Db2Database.class.equals(this.getType())) {
            return MessageFormat.format(Messages.SystemsLabelProvider_DATABASES_X_Y, ownerPattern, namePattern);
        }
        if (Db2Table.class.equals(this.getType())) {
            return MessageFormat.format(Messages.SystemsLabelProvider_TABLES_X_Y_Z, ownerPattern, namePattern, databasePattern);
        }
        return Messages._UNKNOWN;
    }

    public void addListener(EListener<EntityEvent<Db2ObjectQuery<T>>> listener) {
        this.eventDispatcher.addListener(listener);
    }

    public void removeListener(EListener<EntityEvent<Db2ObjectQuery<T>>> listener) {
        this.eventDispatcher.removeListener(listener);
    }

    public String getPDImageName() {
        Class<T> type = this.getType();
        if (Db2Database.class.equals(type)) {
            return "db2_database_query";
        }
        if (Db2Table.class.equals(type)) {
            return "db2_table_query";
        }
        return "";
    }

    public String getPDLabel() {
        return this.getLabel();
    }

    public String getPDPluginId() {
        return "com.ibm.etools.fm.ui";
    }

    public String getToolTipText() {
        if (Db2Database.class.equals(this.getType())) {
            if (this.getNamePattern().length() > 0 && this.getOwnerPattern().length() > 0) {
                return MessageFormat.format(Messages.SystemsDecoratingLabelProvider_DB_NAME_X_OWNER_Y, this.getNamePattern(), this.getOwnerPattern());
            }
            if (!this.getNamePattern().isEmpty()) {
                return MessageFormat.format(Messages.SystemsDecoratingLabelProvider_DB_NAME_X, this.getNamePattern());
            }
            if (!this.getOwnerPattern().isEmpty()) {
                return MessageFormat.format(Messages.SystemsDecoratingLabelProvider_DB_OWNER_X, this.getOwnerPattern());
            }
            return Messages.SystemsDecoratingLabelProvider_DB_ALL;
        }
        if (Db2Table.class.equals(this.getType())) {
            if (this.getDatabasePattern().length() > 0 && this.getNamePattern().length() > 0 && this.getOwnerPattern().length() > 0) {
                return MessageFormat.format(Messages.SystemsDecoratingLabelProvider_TBL_DB_X_NAME_Y_OWNER_Z, this.getDatabasePattern(), this.getNamePattern(), this.getOwnerPattern());
            }
            if (this.getDatabasePattern().length() > 0 && this.getNamePattern().length() > 0) {
                return MessageFormat.format(Messages.SystemsDecoratingLabelProvider_TBL_DB_X_NAME_Y, this.getDatabasePattern(), this.getNamePattern());
            }
            if (this.getDatabasePattern().length() > 0 && this.getOwnerPattern().length() > 0) {
                return MessageFormat.format(Messages.SystemsDecoratingLabelProvider_TBL_DB_X_OWNER_Y, this.getDatabasePattern(), this.getOwnerPattern());
            }
            if (this.getNamePattern().length() > 0 && this.getOwnerPattern().length() > 0) {
                return MessageFormat.format(Messages.SystemsDecoratingLabelProvider_TBL_DB_NAME_X_OWNER_Y, this.getNamePattern(), this.getOwnerPattern());
            }
            if (!this.getDatabasePattern().isEmpty()) {
                return MessageFormat.format(Messages.SystemsDecoratingLabelProvider_TBL_DB_X, this.getDatabasePattern());
            }
            if (!this.getNamePattern().isEmpty()) {
                return MessageFormat.format(Messages.SystemsDecoratingLabelProvider_TBL_NAME_X, this.getNamePattern());
            }
            if (!this.getOwnerPattern().isEmpty()) {
                return MessageFormat.format(Messages.SystemsDecoratingLabelProvider_TBL_OWNER_X, this.getOwnerPattern());
            }
            return Messages.SystemsDecoratingLabelProvider_TBL_ALL;
        }
        return null;
    }
}

