/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.core.model.db2;

import com.ibm.etools.fm.core.model.db2.Db2Database;
import com.ibm.etools.fm.core.model.db2.Db2Subsystem;
import com.ibm.etools.fm.core.model.db2.Db2SubsystemProvider;
import com.ibm.etools.fm.core.model.db2.Db2Table;
import com.ibm.pdtools.common.component.core.model.PDPlatformObject;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import java.util.Objects;
import java.util.Properties;

public abstract class Db2Object
extends PDPlatformObject
implements IZRL,
Db2SubsystemProvider {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private final String name;
    protected final Properties properties = new Properties();
    private final Db2Subsystem subsystem;

    public Db2Object(Db2Subsystem subsystem, String name) {
        this.subsystem = Objects.requireNonNull(subsystem, "Must provide a non-null subsystem");
        this.name = Objects.requireNonNull(name, "Must provide a non-null name");
    }

    public String getName() {
        return this.name;
    }

    @Override
    public Db2Subsystem getSubsystem() {
        return this.subsystem;
    }

    public IPDHost getSystem() {
        return this.subsystem.getSystem();
    }

    public String getPersistentProperty(String key) {
        return this.properties.getProperty(key);
    }

    public void setPersistentProperty(String key, String value) {
        this.properties.setProperty(key, value);
    }

    public abstract Db2Object clone();

    public boolean equals(Object obj) {
        if (obj instanceof Db2Object) {
            Db2Object otherDb2Object = (Db2Object)obj;
            if (!this.subsystem.equals(otherDb2Object.subsystem)) {
                return false;
            }
            return this.name.equals(otherDb2Object.name);
        }
        return false;
    }

    public int hashCode() {
        return this.subsystem.hashCode() * this.name.hashCode();
    }

    public String getPDImageName() {
        return "";
    }

    public String getPDLabel() {
        return "";
    }

    public String getPDPluginId() {
        return "com.ibm.etools.fm.ui";
    }

    public String copyName() {
        return this.getFormattedName();
    }

    public static final class Db2Objects {
        public static boolean isParseableDb2Object(IPDHost host, String path) {
            Objects.requireNonNull(path, "Must provide a non-null path");
            return Db2Database.isParseableDatabase(host, path) || Db2Table.isParseableTable(host, path);
        }

        public static Db2Object parseDb2Object(IPDHost host, String path) {
            Objects.requireNonNull(host, "Must provide a non-null host");
            if (!Db2Objects.isParseableDb2Object(host, path)) {
                throw new IllegalArgumentException(path);
            }
            if (path.toUpperCase().startsWith("DB2:DB:")) {
                return Db2Database.parseDatabase(host, path);
            }
            if (Db2Table.isParseableTable(host, path)) {
                return Db2Table.parseTable(host, path);
            }
            return null;
        }

        private Db2Objects() {
        }
    }
}

