/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.core.model.db2;

import com.ibm.etools.fm.core.model.DummyDataSet;
import com.ibm.etools.fm.core.model.FMHost;
import com.ibm.etools.fm.core.model.db2.Db2Database;
import com.ibm.etools.fm.core.model.db2.Db2EditorOptions;
import com.ibm.etools.fm.core.model.db2.Db2Subsystem;
import com.ibm.etools.fm.core.model.db2.Db2SubsystemProvider;
import com.ibm.etools.fm.core.model.db2.Db2SystemOptions;
import com.ibm.etools.fm.core.model.db2.Db2Table;
import com.ibm.etools.fm.jhost.core.model.FMHostJhost;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import java.util.Objects;

public class Db2EditOptions
implements Db2SubsystemProvider {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2025. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    public static final String DEFAULT_START_POSITION = "1";
    public static final String DEFAULT_ROW_COUNT = "ALL";
    public static final String TYPE_D2E = "D2E ";
    public static final String TYPE_D2V = "D2V ";
    private IPDHost aHost = null;
    private Db2Subsystem aSubsystem = null;
    private Db2Table aTable = null;
    private Db2Database db2Database = null;
    private boolean edit = true;
    private String startPosition = "";
    private String rowCount = "ALL";
    private String encoding = null;
    private String dbcsEncoding = "";
    private String bidiFormat = null;
    private boolean genRep = false;
    private IZRL templateDS = null;
    private WhereClause whereClause = null;

    public void setTable(Db2Table aTable) {
        Objects.requireNonNull(aTable, "Must specify a non-null aTable.");
        this.aTable = aTable;
        this.aSubsystem = aTable.getSubsystem();
        this.aHost = aTable.getSystem();
        this.encoding = aTable.getSystem().getCodePage();
        this.bidiFormat = aTable.getSystem().getBidiFormat();
    }

    public void setOwner(Db2Database aDatabase) {
        Objects.requireNonNull(aDatabase, "Must specify a non-null aTable.");
        this.db2Database = aDatabase;
        this.aSubsystem = aDatabase.getSubsystem();
        this.aHost = aDatabase.getSystem();
        this.encoding = aDatabase.getSystem().getCodePage();
        this.bidiFormat = aDatabase.getSystem().getBidiFormat();
    }

    public void setSubsystem(Db2Subsystem aSubsystem) {
        Objects.requireNonNull(aSubsystem, "Must specify a non-null aSubsystem.");
        this.aSubsystem = aSubsystem;
        this.aHost = aSubsystem.getSystem();
        this.encoding = aSubsystem.getSystem().getCodePage();
        this.bidiFormat = aSubsystem.getSystem().getBidiFormat();
    }

    public void setHost(IPDHost aHost) {
        Objects.requireNonNull(aHost, "Must specify a non-null aHost.");
        this.aHost = aHost;
        this.encoding = aHost.getCodePage();
        this.aSubsystem = null;
        this.aTable = null;
        this.db2Database = null;
        this.bidiFormat = aHost.getBidiFormat();
    }

    public void setWhereClause(REL_TYPE relType, String whereClause) {
        this.whereClause = new WhereClause(relType, whereClause);
        if (!this.whereClause.isValidWhereClause()) {
            this.whereClause = null;
        }
    }

    public void setWhereClause(char relType, String whereClause) {
        this.whereClause = new WhereClause(relType, whereClause);
        if (!this.whereClause.isValidWhereClause()) {
            this.whereClause = null;
        }
    }

    public WhereClause getWhereClause() {
        return this.whereClause;
    }

    public String toCommandString() {
        String xmlVerstionTag;
        String editorOptsCmd;
        String systemOptsCmd;
        StringBuilder sb = new StringBuilder();
        Db2EditOptions.append(sb, "Creator=" + this.aTable.getOwnerX());
        Db2EditOptions.append(sb, "Name=" + this.aTable.getNameX());
        if (!this.startPosition.isEmpty()) {
            Db2EditOptions.append(sb, "Start=" + this.startPosition);
        }
        if (!this.rowCount.isEmpty()) {
            Db2EditOptions.append(sb, "Rowcnt=" + this.rowCount);
        }
        if (this.templateDS != null && !DummyDataSet.isDummyDataSetOrMember(this.templateDS)) {
            if (this.genRep) {
                Db2EditOptions.append(sb, "Genrep=Y");
            } else {
                Db2EditOptions.append(sb, "Genrep=N");
            }
            Db2EditOptions.append(sb, "TCin=" + this.templateDS.getFormattedName());
        }
        if (!(systemOptsCmd = this.getSystemOptions().toCommandString()).isEmpty()) {
            Db2EditOptions.append(sb, systemOptsCmd);
        }
        if (!(editorOptsCmd = this.getEditorOptions().toCommandString()).isEmpty()) {
            Db2EditOptions.append(sb, editorOptsCmd);
        }
        if (!(xmlVerstionTag = FMHostJhost.getXmlVersionTag((IPDHost)this.aHost)).isEmpty()) {
            Db2EditOptions.append(sb, xmlVerstionTag);
        }
        if (this.edit) {
            return TYPE_D2E + sb.toString();
        }
        return TYPE_D2V + sb.toString();
    }

    private static void append(StringBuilder sb, String newParam) {
        if (sb.length() == 0) {
            sb.append(newParam);
        } else {
            sb.append("," + newParam);
        }
    }

    public Db2Table getTable() {
        return this.aTable;
    }

    public Db2Database getDb2Database() {
        return this.db2Database;
    }

    @Override
    public Db2Subsystem getSubsystem() {
        return this.aSubsystem;
    }

    public IPDHost getSystem() {
        return this.aHost;
    }

    public boolean isEdit() {
        return this.edit;
    }

    public void setEdit(boolean edit) {
        this.edit = edit;
    }

    public String getCreator() {
        if (this.aTable != null) {
            return this.aTable.getOwner();
        }
        if (this.db2Database != null) {
            return this.db2Database.getCreator();
        }
        return "";
    }

    public String getName() {
        if (this.aTable != null) {
            return this.aTable.getName();
        }
        if (this.db2Database != null) {
            return this.db2Database.getName();
        }
        return "";
    }

    public String getStartPosition() {
        return this.startPosition;
    }

    public boolean setStartPosition(String startPosition) {
        if (startPosition == null) {
            this.startPosition = "";
            return false;
        }
        this.startPosition = startPosition;
        return true;
    }

    public String getRowCount() {
        return this.rowCount;
    }

    public boolean setRowCount(String rowCount) {
        if (rowCount == null) {
            this.rowCount = DEFAULT_ROW_COUNT;
            return false;
        }
        this.rowCount = rowCount;
        return true;
    }

    public boolean isGenRep() {
        return this.genRep;
    }

    public void setGenRep(boolean genRep) {
        this.genRep = genRep;
    }

    public IZRL getTemplate() {
        return this.templateDS;
    }

    public void setTemplate(IZRL templateDS) {
        this.templateDS = templateDS;
    }

    public Db2SystemOptions getSystemOptions() {
        return ((FMHost)FMHost.getSystem((IPDHost)this.getSubsystem().getSystem())).getDb2SystemOptions(this.getSubsystem().getSubsystemID());
    }

    public void setSystemOptions(Db2SystemOptions options) {
        ((FMHost)FMHost.getSystem((IPDHost)this.getSubsystem().getSystem())).putDb2SystemOptions(this.getSubsystem().getSubsystemID(), options);
    }

    public Db2EditorOptions getEditorOptions() {
        return ((FMHost)FMHost.getSystem((IPDHost)this.getSubsystem().getSystem())).getDb2EditorOptions(this.getSubsystem().getSubsystemID());
    }

    public void putEditorOptions(Db2EditorOptions options) {
        ((FMHost)FMHost.getSystem((IPDHost)this.getSubsystem().getSystem())).putDb2EditorOptions(this.getSubsystem().getSubsystemID(), options);
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getBidiFormat() {
        return this.bidiFormat;
    }

    public void setBidiFormat(String bidiFormat) {
        this.bidiFormat = bidiFormat;
    }

    public void setDbcsEncoding(String dbcsEncoding) {
        this.dbcsEncoding = dbcsEncoding;
    }

    public String getDbcsEncoding() {
        if (this.dbcsEncoding.isEmpty()) {
            return "cp930";
        }
        return this.dbcsEncoding;
    }

    public boolean isDbcsEcndoingValueSet() {
        return this.dbcsEncoding != null && !this.dbcsEncoding.isEmpty();
    }

    public Db2EditOptions clone() {
        Db2EditOptions aCopy = new Db2EditOptions();
        aCopy.aTable = this.aTable;
        aCopy.db2Database = this.db2Database;
        aCopy.aSubsystem = this.aSubsystem;
        aCopy.aHost = this.aHost;
        aCopy.edit = this.edit;
        aCopy.startPosition = this.startPosition;
        aCopy.rowCount = this.rowCount;
        aCopy.genRep = this.genRep;
        aCopy.templateDS = this.templateDS != null ? this.templateDS : null;
        aCopy.encoding = this.encoding;
        aCopy.dbcsEncoding = this.dbcsEncoding;
        aCopy.bidiFormat = this.bidiFormat;
        aCopy.whereClause = this.whereClause == null ? null : new WhereClause(this.whereClause.getRelType(), this.whereClause.getWhereClause());
        return aCopy;
    }

    public int hashCode() {
        int prime = 37;
        int result = 1;
        result = 37 * result + (this.aHost == null ? 0 : this.aHost.hashCode());
        result = 37 * result + (this.aSubsystem == null ? 0 : this.aSubsystem.hashCode());
        result = 37 * result + (this.aTable == null ? 0 : this.aTable.hashCode());
        result = 37 * result + (this.db2Database == null ? 0 : this.db2Database.hashCode());
        result = 37 * result + (this.dbcsEncoding == null ? 0 : this.dbcsEncoding.hashCode());
        result = 37 * result + (this.edit ? 1231 : 1237);
        result = 37 * result + (this.encoding == null ? 0 : this.encoding.hashCode());
        result = 37 * result + (this.bidiFormat == null ? 0 : this.bidiFormat.hashCode());
        result = 37 * result + (this.genRep ? 1231 : 1237);
        result = 37 * result + (this.rowCount == null ? 0 : this.rowCount.hashCode());
        result = 37 * result + (this.startPosition == null ? 0 : this.startPosition.hashCode());
        result = 37 * result + (this.templateDS == null ? 0 : this.templateDS.hashCode());
        result = 37 * result + (this.whereClause == null ? 0 : this.whereClause.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Db2EditOptions)) {
            return false;
        }
        Db2EditOptions other = (Db2EditOptions)obj;
        if (this.aHost == null ? other.aHost != null : !this.aHost.equals(other.aHost)) {
            return false;
        }
        if (this.aSubsystem == null ? other.aSubsystem != null : !this.aSubsystem.equals(other.aSubsystem)) {
            return false;
        }
        if (this.aTable == null ? other.aTable != null : !this.aTable.equals(other.aTable)) {
            return false;
        }
        if (this.db2Database == null ? other.db2Database != null : !this.db2Database.equals(other.db2Database)) {
            return false;
        }
        if (this.dbcsEncoding == null ? other.dbcsEncoding != null : !this.dbcsEncoding.equals(other.dbcsEncoding)) {
            return false;
        }
        if (this.edit != other.edit) {
            return false;
        }
        if (this.encoding == null ? other.encoding != null : !this.encoding.equals(other.encoding)) {
            return false;
        }
        if (this.bidiFormat == null ? other.bidiFormat != null : !this.bidiFormat.equals(other.bidiFormat)) {
            return false;
        }
        if (this.genRep != other.genRep) {
            return false;
        }
        if (this.rowCount == null ? other.rowCount != null : !this.rowCount.equals(other.rowCount)) {
            return false;
        }
        if (this.startPosition == null ? other.startPosition != null : !this.startPosition.equals(other.startPosition)) {
            return false;
        }
        if (this.templateDS == null ? other.templateDS != null : !this.templateDS.equals(other.templateDS)) {
            return false;
        }
        return !(this.whereClause == null ? other.whereClause != null : !this.whereClause.equals(other.whereClause));
    }

    public static enum REL_TYPE {
        D,
        P;

    }

    public static class WhereClause {
        private REL_TYPE relType = REL_TYPE.D;
        private String whereClause = null;

        public WhereClause(REL_TYPE relType, String whereClause) {
            this.relType = relType;
            this.whereClause = whereClause == null || whereClause.trim().isEmpty() ? null : whereClause;
        }

        public WhereClause(char relType, String whereClause) {
            if (relType == 'D') {
                this.relType = REL_TYPE.D;
            } else if (relType == 'P') {
                this.relType = REL_TYPE.P;
            } else {
                throw new IllegalArgumentException();
            }
            this.whereClause = whereClause == null || whereClause.trim().isEmpty() ? null : whereClause;
        }

        public boolean equals(Object o) {
            if (o instanceof WhereClause) {
                WhereClause other = (WhereClause)o;
                return this.relType == other.relType && (this.whereClause == null && other.whereClause == null || this.whereClause.equals(other.whereClause));
            }
            return false;
        }

        public int hashCode() {
            int r = 37;
            r = 37 * r + this.relType.hashCode();
            r = 37 * r + (this.whereClause == null ? 0 : this.whereClause.hashCode());
            return r;
        }

        public REL_TYPE getRelType() {
            return this.relType;
        }

        public String getWhereClause() {
            return this.whereClause;
        }

        public boolean isValidWhereClause() {
            return this.whereClause != null;
        }

        public String toString() {
            if (this.whereClause == null) {
                return "";
            }
            return (this.relType == REL_TYPE.P ? "P" : "D") + this.whereClause;
        }
    }
}

