/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.core.model.db2;

import com.ibm.etools.fm.core.FMCorePlugin;
import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.db2.Db2Database;
import com.ibm.etools.fm.core.model.db2.Db2Object;
import com.ibm.etools.fm.core.model.db2.Db2ObjectQueryAbstract;
import com.ibm.etools.fm.core.model.db2.Db2SqlQuery;
import com.ibm.etools.fm.core.model.db2.Db2SqlQueryBuilder;
import com.ibm.etools.fm.core.model.db2.Db2SqlQueryResultWrapper;
import com.ibm.etools.fm.core.model.db2.Db2Subsystem;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;

public class Db2DatabaseQuery
extends Db2ObjectQueryAbstract<Db2Database> {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2018. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final int NUMBER_OF_PATTERNS = 2;

    public Db2DatabaseQuery(Db2Subsystem subSystem, Class<Db2Database> type) {
        super(subSystem, type);
        this.patternList = new String[2];
    }

    public Db2DatabaseQuery(Db2Subsystem subSystem, Class<Db2Database> type, String[] patternList) {
        super(subSystem, type);
        this.setPatternList(patternList);
    }

    @Override
    public Db2ObjectQueryAbstract<Db2Database> clone() {
        Db2DatabaseQuery clone = new Db2DatabaseQuery(this.subSystem, Db2Database.class);
        clone.setPatternList(this.patternList);
        if (this.objects != null) {
            clone.objects = new ArrayList(this.objects);
        }
        return clone;
    }

    @Override
    public String[] getPatternList() {
        return this.patternList == null ? null : Arrays.copyOf(this.patternList, this.patternList.length);
    }

    @Override
    public String getSQLQuery() {
        String processedOwner = null;
        processedOwner = "CURRENT_USERNAME_QUERY".equals(this.getOwnerPatternRaw()) ? this.getOwnerPattern() : Db2SqlQueryBuilder.makeLikePattern(this.getOwnerPatternRaw(), false);
        String processedName = Db2SqlQueryBuilder.makeLikePattern(this.getNamePattern(), false);
        Db2SqlQueryBuilder statement = new Db2SqlQueryBuilder();
        statement.select("NAME", "CREATOR").from("SYSIBM.SYSDATABASE DB");
        if (!this.getOwnerPatternRaw().isEmpty()) {
            if (FMCorePlugin.isDb2RtrimCreatorInWhere()) {
                statement.where(Db2SqlQueryBuilder.OPERATOR.AND, MessageFormat.format("RTRIM(DB.CREATOR) LIKE RTRIM(''{0}'')", processedOwner));
            } else {
                statement.where(Db2SqlQueryBuilder.OPERATOR.AND, MessageFormat.format("DB.CREATOR LIKE ''{0}''", processedOwner));
            }
        }
        if (!this.getNamePattern().isEmpty()) {
            statement.where(Db2SqlQueryBuilder.OPERATOR.AND, MessageFormat.format("DB.NAME LIKE ''{0}''", processedName));
        }
        return statement.getSql();
    }

    @Override
    public String getLabel() {
        if ("CURRENT_USERNAME_QUERY".equals(this.getOwnerPatternRaw())) {
            return Messages.Db2DatabaseQuery_MyDatabases;
        }
        String ownerPattern = this.getOwnerPatternRaw().isEmpty() ? "*" : this.getOwnerPatternRaw();
        String namePattern = this.getNamePattern().isEmpty() ? "*" : this.getNamePattern();
        return MessageFormat.format(Messages.SystemsLabelProvider_DATABASES_X_Y, ownerPattern, namePattern);
    }

    public static Db2DatabaseQuery createBrowseUserForDatabase(Db2Database db) {
        if (db == null) {
            throw new IllegalArgumentException("Must provide a non-null Db2Database.");
        }
        Db2DatabaseQuery databaseQuery = new Db2DatabaseQuery(db.getSubsystem(), Db2Database.class);
        databaseQuery.setOwnerPattern("CURRENT_USERNAME_QUERY");
        databaseQuery.setNamePattern(db.getName());
        return databaseQuery;
    }

    public void setNamePattern(String databasePattern) {
        this.initialisePatternListIfNull();
        this.patternList[1] = databasePattern;
    }

    public String getNamePattern() {
        return this.patternList == null ? null : this.patternList[1];
    }

    public static <U extends Db2Object> Db2DatabaseQuery create(Db2Subsystem subsys, Class<Db2Database> type) {
        return new Db2DatabaseQuery(subsys, type);
    }

    @Override
    public Result<?> loadObjects(IHowIsGoing monitor) throws InterruptedException {
        Db2SqlQuery sqlQuery = new Db2SqlQuery(this.subSystem, this.getSQLQuery());
        Result<String[][]> result = sqlQuery.execute(monitor);
        if (result.getOutput() == null) {
            return result;
        }
        Db2SqlQueryResultWrapper sqlResult = new Db2SqlQueryResultWrapper(result);
        ArrayList<Db2Database> objects = new ArrayList<Db2Database>();
        int i = 1;
        while (i < sqlResult.getNumRows()) {
            String name = sqlResult.getString(i, 0);
            String creator = sqlResult.getString(i, 1);
            Db2Database database = new Db2Database(this.subSystem, name);
            database.setCreator(creator);
            objects.add((Db2Database)this.castToQueryObjectType(database));
            ++i;
        }
        this.setObjects(objects);
        return sqlResult.getRawResult();
    }

    @Override
    protected void initialisePatternListIfNull() {
        if (this.patternList == null) {
            this.patternList = new String[2];
        }
    }
}

