/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.core.model.db2;

import com.ibm.etools.fm.core.model.db2.Db2Object;
import com.ibm.etools.fm.core.model.db2.Db2Subsystem;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import java.io.UnsupportedEncodingException;
import java.util.Objects;
import java.util.regex.Pattern;

public class Db2Database
extends Db2Object {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    public static final String PATTERN_VALID_NAME = "[@#$A-Z0-9_]+\\s*";
    private static final Pattern validNameRegexp = Pattern.compile("[@#$A-Z0-9_]+\\s*");
    public static final String FORMATTED_PREFIX = "DB2:DB:";
    private static final Pattern parseableRegexp = Pattern.compile("^DB2:DB:[A-Z0-9#$@]{1,4}:[@#$A-Z0-9_]+\\s*$");
    private String creator = "";

    public static boolean isParseableDatabase(IPDHost host, String path) {
        Objects.requireNonNull(path, "Please specify a non-null path.");
        String nameCheck = null;
        try {
            nameCheck = new String(path.getBytes(host.getCodePage()), host.getCommunicationCodePage());
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return parseableRegexp.matcher(nameCheck).matches();
    }

    public static Db2Database parseDatabase(IPDHost host, String path) {
        if (!Db2Database.isParseableDatabase(host, path)) {
            throw new IllegalArgumentException(path);
        }
        int subsysEnd = path.indexOf(":", FORMATTED_PREFIX.length());
        String ssid = path.substring(FORMATTED_PREFIX.length(), subsysEnd);
        Db2Subsystem subsys = new Db2Subsystem(host, ssid);
        String name = path.substring(subsysEnd + 1);
        return new Db2Database(subsys, name);
    }

    public static boolean isValidName(IPDHost host, String name) {
        Objects.requireNonNull(name, "Please specify a non-null name.");
        if (name.length() > 8) {
            return false;
        }
        String nameCheck = null;
        try {
            nameCheck = new String(name.getBytes(host.getCodePage()), host.getCommunicationCodePage());
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return validNameRegexp.matcher(nameCheck).matches();
    }

    public Db2Database(Db2Subsystem subsystem, String name) {
        super(subsystem, name);
        if (!Db2Database.isValidName(subsystem.getSystem(), name)) {
            throw new IllegalArgumentException("name='" + (name == null ? "null" : name) + "'");
        }
    }

    public void setCreator(String creator) {
        this.creator = Objects.requireNonNull(creator, "Must provide a non-null creator");
    }

    public String getCreator() {
        return this.creator;
    }

    public String getFormattedName() {
        return FORMATTED_PREFIX + this.getSubsystem().getName() + ":" + this.getName();
    }

    public String toString() {
        return this.getFormattedName();
    }

    @Override
    public Db2Database clone() {
        Db2Database copy = new Db2Database(this.getSubsystem(), this.getName());
        this.setCreator(this.getCreator());
        for (Object key : this.properties.keySet()) {
            copy.setPersistentProperty(key.toString(), this.properties.get(key).toString());
        }
        return copy;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof Db2Database && super.equals(obj);
    }

    @Override
    public String getPDImageName() {
        return "db2_database";
    }

    @Override
    public String getPDLabel() {
        return this.getName();
    }

    @Override
    public String getPDPluginId() {
        return "com.ibm.etools.fm.ui";
    }
}

