/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.core.model.cics;

import com.ibm.etools.fm.core.model.FMHost;
import com.ibm.etools.fm.core.model.cics.CicsAppl;
import com.ibm.etools.fm.core.model.cics.CicsResourceQuery;
import com.ibm.etools.fm.core.model.cics.CicsTransientData;
import com.ibm.etools.fm.core.socket.func.CTDL;
import com.ibm.etools.fm.core.socket.func.CTDLParser;
import com.ibm.etools.fm.core.socket.func.UtilityFunctionRunner;
import com.ibm.pdtools.common.component.jhost.core.model.IPDConnectEndpoint;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class CicsTransientDataQuery
extends CicsResourceQuery<CicsTransientData> {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final Pattern validRegexp = Pattern.compile("[a-zA-Z0-9$@#./_%&\ufffd?!:|\"\ufffd,;<>=*-]{1,4}?");

    public static CicsTransientDataQuery create(CicsAppl cicsAppl, String query) {
        return new CicsTransientDataQuery(cicsAppl, query);
    }

    public static CicsTransientDataQuery createForApplication(CicsAppl cicsAppl) {
        return new CicsTransientDataQuery(cicsAppl, "*");
    }

    public static boolean isValidQuery(IPDHost host, String queryText) throws IllegalArgumentException {
        if (queryText == null) {
            throw new IllegalArgumentException("Must provide a non-null parameter");
        }
        String nameCheck = null;
        try {
            nameCheck = new String(queryText.getBytes(host.getCodePage()), host.getCommunicationCodePage());
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return validRegexp.matcher(nameCheck).matches();
    }

    public CicsTransientDataQuery(CicsAppl cicsAppl, String query) {
        super(cicsAppl, query);
    }

    public CicsTransientDataQuery clone() {
        CicsTransientDataQuery clone = CicsTransientDataQuery.create(this.getCICSAppl(), this.getQuery());
        if (this.getCICSResources() != null) {
            clone.setCICSResources(new ArrayList(this.getCICSResources()));
        }
        return clone;
    }

    @Override
    public String getLabel() {
        return "TD:" + this.getCICSAppl().getName() + ":" + this.getQuery();
    }

    @Override
    public boolean isValidCICSQuery(CicsAppl cicsAppl, String queryText) {
        return CicsTransientDataQuery.isValidQuery(cicsAppl.getSystem(), queryText);
    }

    @Override
    public Result<List<CicsTransientData>> loadCICSResources(IHowIsGoing monitor) throws InterruptedException {
        CTDL ctdl = new CTDL();
        ctdl.setApplId(this.getCICSAppl().getName());
        ctdl.setResource(this.getQuery());
        Result result = UtilityFunctionRunner.executeAndParse(this.getSystem(), (IPDConnectEndpoint)FMHost.getSystem((IPDHost)this.getSystem()), ctdl, new CTDLParser(this.getCICSAppl()), monitor);
        this.setCICSResources((List)result.getOutput());
        return result;
    }
}

