/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.core.model.cics;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.FMHost;
import com.ibm.etools.fm.core.model.cics.CicsAppl;
import com.ibm.etools.fm.core.model.cics.CicsResource;
import com.ibm.etools.fm.core.socket.func.CTDL;
import com.ibm.etools.fm.core.socket.func.CTDLParser;
import com.ibm.etools.fm.core.socket.func.UtilityFunctionRunner;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.jhost.core.model.IPDConnectEndpoint;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import java.io.UnsupportedEncodingException;
import java.util.Formatter;
import java.util.List;
import java.util.regex.Pattern;

public class CicsTransientData
extends CicsResource {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2023. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    public static final String PREFIX = "TD:";
    public static final String PATTERN_VALID_NAME = "[a-zA-Z0-9$@#./_%&\ufffd?!:|\"\ufffd,;<>=-]{1,4}";
    private static final Pattern validRegexp = Pattern.compile("[a-zA-Z0-9$@#./_%&\ufffd?!:|\"\ufffd,;<>=-]{1,4}");
    private TD_TYPE tdType = null;
    private static final PDLogger logger = PDLogger.get(CicsTransientData.class);

    public static CicsTransientData create(CicsAppl cicsAppl, String fullName) {
        return new CicsTransientData(cicsAppl, fullName);
    }

    public static boolean isValidName(IPDHost host, String fullName) throws IllegalArgumentException {
        if (fullName == null) {
            throw new IllegalArgumentException("Must provide a non-null fullName.");
        }
        String checkName = null;
        try {
            checkName = new String(fullName.getBytes(host.getCodePage()), host.getCommunicationCodePage());
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return validRegexp.matcher(checkName).matches();
    }

    protected CicsTransientData(CicsAppl cicsAppl, String name) {
        super(cicsAppl, name);
    }

    @Override
    public CicsTransientData clone() {
        CicsTransientData copy = CicsTransientData.create(this.getCICSAppl(), this.getName());
        copy.setTDType(this.getTDType());
        copy.setProperties(this.getProperties());
        copy.setConfirmedExists(this.getConfirmedExists());
        for (Object key : this.getPersistentProperties().keySet()) {
            copy.setPersistentProperty(key.toString(), this.getPersistentProperties().get(key).toString());
        }
        copy.setTDType(this.getTDType());
        return copy;
    }

    public String getFormattedName() {
        return PREFIX + this.getCICSAppl().getName() + ":" + this.getName();
    }

    public String getAnnotatedName() {
        Formatter f = null;
        try {
            if (this.getTDType() == TD_TYPE.INDIRECT_TD || this.getTDType() == TD_TYPE.REMOTE_TD) {
                StringBuilder sb = new StringBuilder();
                f = new Formatter(sb);
                String target = this.getProperties().getPropertyValue(this.getTDType() == TD_TYPE.INDIRECT_TD ? "iname" : "rname");
                if (target == null) {
                    target = "";
                }
                f.format("%-4s --> %s", this.getName(), target);
                String string = f.toString();
                return string;
            }
            String string = this.getName();
            return string;
        }
        finally {
            if (f != null) {
                f.flush();
                f.close();
            }
        }
    }

    public void setTDType(TD_TYPE type) {
        this.tdType = type;
    }

    public TD_TYPE getTDType() {
        return this.tdType;
    }

    @Override
    protected boolean isValidCICSName(IPDHost host, String name) {
        return CicsTransientData.isValidName(host, name);
    }

    @Override
    protected synchronized Result<?> doRefresh(IHowIsGoing monitor, boolean doFullRefresh) throws InterruptedException {
        CTDL ctdl = new CTDL();
        ctdl.setApplId(this.getCICSAppl().getName());
        ctdl.setResource(this.getName());
        Result result = UtilityFunctionRunner.executeAndParse(this.getSystem(), (IPDConnectEndpoint)FMHost.getSystem((IPDHost)this.getSystem()), ctdl, new CTDLParser(this.getCICSAppl()), monitor);
        List cicsTDs = (List)result.getOutput();
        CicsTransientData updateFrom = null;
        if (cicsTDs == null) {
            logger.trace(new Object[]{"Error refreshingSelf for CICS transient data ", this.getFormattedName()});
        } else if (cicsTDs.isEmpty()) {
            logger.trace(new Object[]{"CICS transient data does not exist: ", this});
        } else {
            CicsTransientData matchingCicsTD = (CicsTransientData)cicsTDs.get(0);
            if (!this.getName().equals(matchingCicsTD.getName())) {
                logger.error(new Object[]{this.getName(), " expected but got CICS transient data name of ", matchingCicsTD.getName()});
                return result;
            }
            updateFrom = matchingCicsTD;
        }
        this.updateFrom(updateFrom);
        return result;
    }

    private void updateFrom(CicsTransientData updateFrom) {
        if (updateFrom == null) {
            this.setConfirmedExists(false);
            this.setProperties(null);
        } else {
            this.setConfirmedExists(true);
            this.setProperties(updateFrom.getProperties());
            this.setTDType(updateFrom.getTDType());
        }
    }

    public String getPDImageName() {
        return "cicsTD";
    }

    public String getPDLabel() {
        return this.getAnnotatedName();
    }

    public String getPDPluginId() {
        return "com.ibm.etools.fm.ui";
    }

    public static enum TD_TYPE {
        INDIRECT_TD(Messages.CICS_TD_TYPE_INDRECT),
        EXTRAPARTITION_TD(Messages.CICS_TD_TYPE_EXTRAPARTITION),
        INTRAPARTITION_TD(Messages.CICS_TD_TYPE_INTRAPARTITION),
        REMOTE_TD(Messages.CICS_TD_TYPE_REMOTE);

        private final String label;

        private TD_TYPE(String label) {
            this.label = label;
        }

        public String getLabel() {
            return this.label;
        }
    }
}

