/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.core.model.cics;

import com.ibm.etools.fm.core.model.FMHost;
import com.ibm.etools.fm.core.model.cics.CicsAppl;
import com.ibm.etools.fm.core.model.cics.CicsResource;
import com.ibm.etools.fm.core.socket.func.CTSL;
import com.ibm.etools.fm.core.socket.func.CTSLParser;
import com.ibm.etools.fm.core.socket.func.UtilityFunctionRunner;
import com.ibm.etools.fm.core.util.StringUtils;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.jhost.core.model.IPDConnectEndpoint;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;

public class CicsTemporaryStorage
extends CicsResource {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    public static final String PREFIX = "TS:";
    private static final PDLogger logger = PDLogger.get(CicsTemporaryStorage.class);

    public static CicsTemporaryStorage create(CicsAppl cicsAppl, String name) {
        return new CicsTemporaryStorage(cicsAppl, name);
    }

    public static boolean isValidName(IPDHost host, String fullName) throws IllegalArgumentException {
        if (fullName == null) {
            throw new IllegalArgumentException("Must provide a non-null parameter");
        }
        int len = CicsTemporaryStorage.stripHexValue(fullName).length();
        return len >= 1 && len <= 16;
    }

    public static String stripHexValue(String fullName) {
        int ind;
        Objects.requireNonNull(fullName, "Must provide a non-null fullName.");
        return fullName.endsWith("'/") && (ind = fullName.lastIndexOf("\\x'")) > 0 ? fullName.substring(0, ind) : fullName;
    }

    protected CicsTemporaryStorage(CicsAppl cicsAppl, String name) {
        super(cicsAppl, name);
    }

    @Override
    public CicsTemporaryStorage clone() {
        CicsTemporaryStorage copy = CicsTemporaryStorage.create(this.getCICSAppl(), this.getName());
        copy.setConfirmedExists(this.getConfirmedExists());
        copy.setProperties(this.getProperties());
        Properties props = this.getPersistentProperties();
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            copy.setPersistentProperty(entry.getKey().toString(), entry.getValue().toString());
        }
        return copy;
    }

    @Override
    public String getName() {
        String name = super.getName();
        if (name.matches(".*\\p{C}.*")) {
            if (this.getSystem().getHostType().getCommunicationEncoding() != this.getSystem().getCodePage()) {
                return name.replaceAll("\\p{C}", ".") + "\\x'" + StringUtils.convertToHex((String)name, (String)this.getSystem().getCodePage()) + "'/";
            }
            return name.replaceAll("\\p{C}", ".") + "\\x'" + StringUtils.convertToHex((String)name, (String)this.getSystem().getHostType().getCommunicationEncoding()) + "'/";
        }
        return name;
    }

    public String getFormattedName() {
        return PREFIX + this.getCICSAppl().getName() + ":" + this.getName();
    }

    @Override
    protected boolean isValidCICSName(IPDHost host, String name) {
        return CicsTemporaryStorage.isValidName(host, name);
    }

    @Override
    public synchronized Result<?> doRefresh(IHowIsGoing monitor, boolean doFullRefresh) throws InterruptedException {
        CTSL ctsl = new CTSL();
        ctsl.setApplid(this.getCICSAppl().getName());
        ctsl.setResource(this.getName());
        Result result = UtilityFunctionRunner.executeAndParse(this.getSystem(), (IPDConnectEndpoint)FMHost.getSystem((IPDHost)this.getSystem()), ctsl, new CTSLParser(this.getCICSAppl()), monitor);
        List cicsTSs = (List)result.getOutput();
        CicsTemporaryStorage updateFrom = null;
        if (cicsTSs == null) {
            logger.trace(new Object[]{"Error refreshingSelf for CICS temporary storage ", this.getFormattedName()});
        } else if (cicsTSs.isEmpty()) {
            logger.trace(new Object[]{"CICS temporary storage does not exist: ", this});
        } else {
            CicsTemporaryStorage matchingCicsTS = (CicsTemporaryStorage)cicsTSs.get(0);
            if (!this.getName().equals(matchingCicsTS.getName())) {
                logger.error(new Object[]{this.getName(), " expected but got CICS temporary storage name of ", matchingCicsTS.getName()});
                return result;
            }
            updateFrom = matchingCicsTS;
        }
        this.updateFrom(updateFrom);
        return result;
    }

    private void updateFrom(CicsTemporaryStorage updateFrom) {
        if (updateFrom == null) {
            this.setConfirmedExists(false);
            this.setProperties(null);
        } else {
            this.setConfirmedExists(true);
            this.setProperties(updateFrom.getProperties());
        }
    }

    public String getPDImageName() {
        return "cicsTS";
    }

    public String getPDLabel() {
        return this.getName();
    }

    public String getPDPluginId() {
        return "com.ibm.etools.fm.ui";
    }
}

