/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.core.model.cics;

import com.ibm.etools.fm.core.model.cics.CicsAppl;
import com.ibm.etools.fm.core.model.cics.CicsResource;
import com.ibm.pdtools.common.component.core.model.PDPlatformObject;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.registery.EListener;
import com.ibm.pdtools.common.component.jhost.registery.EntityEvent;
import com.ibm.pdtools.common.component.jhost.registery.EntityEventDispatcher;
import com.ibm.pdtools.common.component.jhost.registery.IEntityEventDispatcher;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import com.ibm.pdtools.common.component.jhost.util.StringUtils;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;

public abstract class CicsResourceQuery<E extends CicsResource>
extends PDPlatformObject
implements IEntityEventDispatcher<CicsResourceQuery<E>> {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    public static final Object PROPERTY_APPL = new Object();
    public static final Object PROPERTY_LOADED_RESOURCES = new Object();
    public static final Object PROPERTY_QUERY = new Object();
    public static final String MULTI_CHAR_WILDCARD = "*";
    private CicsAppl cicsAppl;
    private String query;
    private Pattern pattern;
    private List<E> cicsTSs = null;
    protected final EntityEventDispatcher<CicsResourceQuery<E>> eventDispatcher = new EntityEventDispatcher((Object)this);

    public static Pattern convertToRegexp(String query) {
        String matchString = StringUtils.escapeRegex((String)query);
        matchString = matchString.replaceAll(StringUtils.escapeRegex((String)"\\*"), ".*");
        matchString = matchString.replaceAll("%", ".");
        return Pattern.compile(matchString, 66);
    }

    public CicsResourceQuery(CicsAppl cicsAppl, String query) {
        this.setCICSApplID(cicsAppl);
        this.setQuery(query);
    }

    public boolean equals(Object obj) {
        if (obj != null && ((Object)((Object)this)).getClass().equals(obj.getClass())) {
            CicsResourceQuery otherQuery = (CicsResourceQuery)((Object)obj);
            return this.query.equals(otherQuery.query) && this.cicsAppl.equals(otherQuery.cicsAppl);
        }
        return false;
    }

    public int hashCode() {
        return ((Object)((Object)this)).getClass().hashCode() * this.query.hashCode() * this.cicsAppl.hashCode();
    }

    public String toString() {
        return this.getLabel();
    }

    public abstract String getLabel();

    public abstract CicsResourceQuery<E> clone();

    public String getQuery() {
        return this.query;
    }

    public IPDHost getSystem() {
        return this.cicsAppl.getSystem();
    }

    public void setSystem(IPDHost system) {
        this.cicsAppl.setSystem(system);
    }

    public CicsAppl getCICSAppl() {
        return this.cicsAppl;
    }

    public Pattern getPattern() {
        if (this.pattern == null) {
            this.pattern = CicsResourceQuery.convertToRegexp(this.query);
        }
        return this.pattern;
    }

    public void setCICSApplID(CicsAppl cicsAppl) {
        this.cicsAppl = cicsAppl;
        this.eventDispatcher.fireChangedEvent(PROPERTY_APPL);
    }

    protected void setCICSResources(List<E> cicsTSs) {
        this.cicsTSs = cicsTSs;
        this.eventDispatcher.fireChangedEvent(PROPERTY_LOADED_RESOURCES);
    }

    public List<E> getCICSResources() {
        if (this.cicsTSs == null) {
            return this.cicsTSs;
        }
        return Collections.unmodifiableList(this.cicsTSs);
    }

    public abstract Result<List<E>> loadCICSResources(IHowIsGoing var1) throws InterruptedException;

    public void setQuery(String value) {
        this.query = value;
        this.eventDispatcher.fireChangedEvent(PROPERTY_QUERY);
    }

    public abstract boolean isValidCICSQuery(CicsAppl var1, String var2);

    public void addListener(EListener<EntityEvent<CicsResourceQuery<E>>> listener) {
        this.eventDispatcher.addListener(listener);
    }

    public void removeListener(EListener<EntityEvent<CicsResourceQuery<E>>> listener) {
        this.eventDispatcher.removeListener(listener);
    }

    public String getPDImageName() {
        return "cicsQuery";
    }

    public String getPDLabel() {
        return this.getLabel();
    }

    public String getPDPluginId() {
        return "com.ibm.etools.fm.ui";
    }
}

