/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.core.model.cics;

import com.ibm.etools.fm.core.model.cics.CicsAppl;
import com.ibm.etools.fm.core.model.cics.CicsFile;
import com.ibm.etools.fm.core.model.cics.CicsTemporaryStorage;
import com.ibm.etools.fm.core.model.cics.CicsTransientData;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.model.IRefreshable;
import com.ibm.pdtools.common.component.core.model.PDPlatformObject;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.core.model.data.ImmutableProperties;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import java.util.Properties;

public abstract class CicsResource
extends PDPlatformObject
implements Comparable<CicsResource>,
IRefreshable {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    protected final PDLogger logger = PDLogger.get(this.getClass());
    private String name = "";
    private Properties persistentProps = new Properties();
    private CicsAppl cicsAppl = null;
    private boolean confirmedExists = false;
    private ImmutableProperties properties = null;

    public static CicsResource parseCICSResource(IPDHost host, String path) {
        if (!CicsResource.isParseable(host, path)) {
            throw new IllegalArgumentException("Specified path is not parseable as a CICS Resource: " + path);
        }
        int firstColon = path.indexOf(":");
        int secondColon = path.indexOf(":", firstColon + 1);
        if (firstColon == -1 || secondColon == -1) {
            throw new IllegalArgumentException(path);
        }
        String applId = path.substring(firstColon + 1, secondColon);
        CicsAppl cicsAppl = CicsAppl.create(host, applId);
        String resource = path.substring(secondColon + 1);
        if (path.toUpperCase().startsWith("FI:")) {
            return CicsFile.create(cicsAppl, resource);
        }
        if (path.toUpperCase().startsWith("TD:")) {
            return CicsTransientData.create(cicsAppl, resource);
        }
        if (path.toUpperCase().startsWith("TS:")) {
            return CicsTemporaryStorage.create(cicsAppl, resource);
        }
        throw new IllegalArgumentException(path);
    }

    public static boolean isParseable(IPDHost host, String path) {
        String upcasePath = path.toUpperCase();
        if (path.length() < 6) {
            return false;
        }
        int firstColon = path.indexOf(":");
        int secondColon = path.indexOf(":", firstColon + 1);
        if (firstColon == -1 || secondColon == -1) {
            return false;
        }
        String applId = path.substring(firstColon + 1, secondColon);
        if (!CicsAppl.isValidName(applId, host.getCodePage())) {
            return false;
        }
        String resource = path.substring(secondColon + 1);
        if (upcasePath.startsWith("FI:")) {
            return CicsFile.isValidName(host, resource);
        }
        if (upcasePath.startsWith("TD:")) {
            return CicsTransientData.isValidName(host, resource);
        }
        if (upcasePath.startsWith("TS:")) {
            return CicsTemporaryStorage.isValidName(host, resource);
        }
        return false;
    }

    public CicsResource(CicsAppl cicsAppl, String name) {
        if (cicsAppl == null) {
            throw new IllegalArgumentException("Must provide a non-null cicsAppl.");
        }
        if (!this.isValidCICSName(cicsAppl.getSystem(), name)) {
            throw new IllegalArgumentException("An error parsing value " + name);
        }
        this.name = name;
        this.cicsAppl = cicsAppl;
    }

    public String getName() {
        return this.name;
    }

    protected void setName(String name) {
        this.name = name;
    }

    public IPDHost getSystem() {
        return this.cicsAppl.getSystem();
    }

    public CicsAppl getCICSAppl() {
        return this.cicsAppl;
    }

    public boolean getConfirmedExists() {
        return this.confirmedExists;
    }

    public String getPersistentProperty(String key) {
        return this.persistentProps.getProperty(key);
    }

    public void setPersistentProperty(String key, String value) {
        this.persistentProps.setProperty(key, value);
    }

    protected void clearPersistentProperties() {
        this.persistentProps.clear();
    }

    public Properties getPersistentProperties() {
        return this.persistentProps;
    }

    public void setProperties(ImmutableProperties properties) {
        this.properties = properties;
    }

    public ImmutableProperties getProperties() {
        return this.properties;
    }

    public void setConfirmedExists(boolean confirmedExists) {
        this.confirmedExists = confirmedExists;
    }

    public boolean equals(Object obj) {
        if (obj instanceof CicsResource && this.getClass().equals(obj.getClass())) {
            CicsResource cicsRes = (CicsResource)obj;
            return cicsRes.cicsAppl.equals(this.cicsAppl) && cicsRes.name.equals(this.name);
        }
        return false;
    }

    @Override
    public int compareTo(CicsResource o) {
        int applIDCompare = this.cicsAppl.compareTo(o.cicsAppl);
        if (applIDCompare != 0) {
            return applIDCompare;
        }
        int classCompare = this.getClass().getSimpleName().compareTo(o.getClass().getSimpleName());
        if (classCompare != 0) {
            return classCompare;
        }
        return this.name.compareTo(o.name);
    }

    public int hashCode() {
        return this.getClass().hashCode() * this.name.hashCode() * this.cicsAppl.hashCode();
    }

    public abstract IZRL clone();

    protected abstract boolean isValidCICSName(IPDHost var1, String var2);

    public String toString() {
        return this.getFormattedName();
    }

    public Result<?> refreshSelf(IHowIsGoing monitor) throws InterruptedException {
        return this.doRefresh(monitor, true);
    }

    public Result<?> refreshExistence(IHowIsGoing monitor) throws InterruptedException {
        return this.doRefresh(monitor, false);
    }

    protected abstract Result<?> doRefresh(IHowIsGoing var1, boolean var2) throws InterruptedException;

    public String copyName() {
        return this.getFormattedName();
    }
}

