/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.core.model.cics;

import com.ibm.etools.fm.core.model.FMHost;
import com.ibm.etools.fm.core.model.cics.CicsAppl;
import com.ibm.etools.fm.core.model.cics.CicsFile;
import com.ibm.etools.fm.core.model.cics.CicsResourceQuery;
import com.ibm.etools.fm.core.socket.func.CFIL;
import com.ibm.etools.fm.core.socket.func.CFILParser;
import com.ibm.etools.fm.core.socket.func.UtilityFunctionRunner;
import com.ibm.pdtools.common.component.jhost.comms.HostType;
import com.ibm.pdtools.common.component.jhost.core.model.IPDConnectEndpoint;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class CicsFileQuery
extends CicsResourceQuery<CicsFile> {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final Pattern validFMZRegexp = Pattern.compile("[A-Z0-9$@#*]{1,8}");
    private static final Pattern validFMDRegexp = Pattern.compile("[a-zA-Z0-9$@#*]{1,8}");

    public static CicsFileQuery create(CicsAppl cicsAppl, String query) {
        return new CicsFileQuery(cicsAppl, query);
    }

    public static CicsFileQuery createForApplication(CicsAppl cicsAppl) {
        return new CicsFileQuery(cicsAppl, "*");
    }

    public static boolean isValidQuery(CicsAppl cicsAppl, String queryText) throws IllegalArgumentException {
        if (queryText == null) {
            throw new IllegalArgumentException("Must provide a non-null queryText.");
        }
        String nameCheck = null;
        try {
            nameCheck = new String(queryText.getBytes(cicsAppl.getSystem().getCodePage()), cicsAppl.getSystem().getCommunicationCodePage());
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        if (cicsAppl == null || cicsAppl.getSystem().getHostType() != HostType.ZOS) {
            return validFMDRegexp.matcher(nameCheck).matches();
        }
        return validFMZRegexp.matcher(nameCheck).matches();
    }

    public CicsFileQuery(CicsAppl cicsAppl, String query) {
        super(cicsAppl, query);
    }

    public CicsFileQuery clone() {
        CicsFileQuery clone = CicsFileQuery.create(this.getCICSAppl(), this.getQuery());
        if (this.getCICSResources() != null) {
            clone.setCICSResources(new ArrayList(this.getCICSResources()));
        }
        return clone;
    }

    @Override
    public String getLabel() {
        return "FI:" + this.getCICSAppl().getName() + ":" + this.getQuery();
    }

    @Override
    public boolean isValidCICSQuery(CicsAppl cicsAppl, String queryText) {
        return CicsFileQuery.isValidQuery(cicsAppl, queryText);
    }

    @Override
    public Result<List<CicsFile>> loadCICSResources(IHowIsGoing monitor) throws InterruptedException {
        CFIL cfil = new CFIL();
        cfil.setApplid(this.getCICSAppl().getName());
        cfil.setResource(this.getQuery());
        Result result = UtilityFunctionRunner.executeAndParse(this.getSystem(), (IPDConnectEndpoint)FMHost.getSystem((IPDHost)this.getSystem()), cfil, new CFILParser(this.getCICSAppl()), monitor);
        this.setCICSResources((List)result.getOutput());
        return result;
    }
}

