/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.core.model.cics;

import com.ibm.etools.fm.core.model.FMHost;
import com.ibm.etools.fm.core.model.cics.CicsAppl;
import com.ibm.etools.fm.core.model.cics.CicsResource;
import com.ibm.etools.fm.core.socket.func.CFIL;
import com.ibm.etools.fm.core.socket.func.CFILParser;
import com.ibm.etools.fm.core.socket.func.UtilityFunctionRunner;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.jhost.comms.HostType;
import com.ibm.pdtools.common.component.jhost.core.model.IPDConnectEndpoint;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.core.model.data.ImmutableProperties;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;

public class CicsFile
extends CicsResource {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    public static final String PREFIX = "FI:";
    public static final String PATTERN_FMD_VALID_NAME = "[A-Za-z0-9$@#]{1,8}";
    public static final String PATTERN_FMZ_VALID_NAME = "[A-Z0-9$@#]{1,8}";
    private static final Pattern validFmdRegexp = Pattern.compile("[A-Za-z0-9$@#]{1,8}");
    private static final Pattern validFmzRegexp = Pattern.compile("[A-Z0-9$@#]{1,8}");
    private static final PDLogger logger = PDLogger.get(CicsFile.class);

    public static boolean isValidName(IPDHost host, String fullName) throws IllegalArgumentException {
        if (fullName == null) {
            throw new IllegalArgumentException("Must provide a non-null fullName");
        }
        String nameCheck = null;
        try {
            nameCheck = new String(fullName.getBytes(host.getCodePage()), host.getCommunicationCodePage());
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        if (host.getHostType() == null) {
            return validFmdRegexp.matcher(nameCheck).matches();
        }
        if (host.getHostType() == HostType.ZOS) {
            return validFmzRegexp.matcher(nameCheck).matches();
        }
        return validFmdRegexp.matcher(nameCheck).matches();
    }

    public static CicsFile create(CicsAppl cicsAppl, String fullName) {
        return new CicsFile(cicsAppl, fullName);
    }

    protected CicsFile(CicsAppl cicsAppl, String name) {
        super(cicsAppl, name);
    }

    @Override
    public CicsFile clone() {
        CicsFile copy = CicsFile.create(this.getCICSAppl(), this.getName());
        copy.setConfirmedExists(this.getConfirmedExists());
        copy.setProperties(this.getProperties());
        Properties props = this.getPersistentProperties();
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            copy.setPersistentProperty(entry.getKey().toString(), entry.getValue().toString());
        }
        return copy;
    }

    public String getFormattedName() {
        return PREFIX + this.getCICSAppl().getName() + ":" + this.getName();
    }

    public int getKeyLength() {
        return this.getIntProp("keylen", -1);
    }

    public int getKeyStartLocation() {
        return this.getIntProp("keypos", -1);
    }

    private int getIntProp(String propertyKey, int defaultValue) {
        ImmutableProperties properties = this.getProperties();
        if (properties == null) {
            return defaultValue;
        }
        String prop = properties.getPropertyValue(propertyKey);
        if (prop == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(prop.trim());
        }
        catch (NumberFormatException e) {
            logger.debug((Object)MessageFormat.format("Can't parse integer property from {0} for property {1} with value {2}", this.getFormattedName(), propertyKey, prop.trim()));
            return defaultValue;
        }
    }

    public boolean isEnabled() {
        return this.isPropEqualTo("ena", "ENABLED");
    }

    public boolean isOpen() {
        return this.isPropEqualTo("ope", "OPEN");
    }

    private boolean isPropEqualTo(String propertyKey, String expectedValue) {
        ImmutableProperties properties = this.getProperties();
        if (properties == null) {
            logger.debug((Object)MessageFormat.format("Properties for {0} not known, can't parse int prop: {1}", this.getFormattedName(), propertyKey));
            return false;
        }
        String prop = properties.getPropertyValue(propertyKey);
        return prop == null ? expectedValue == null : prop.equals(expectedValue);
    }

    @Override
    protected boolean isValidCICSName(IPDHost host, String name) {
        return CicsFile.isValidName(host, name);
    }

    @Override
    protected synchronized Result<?> doRefresh(IHowIsGoing monitor, boolean doFullRefresh) throws InterruptedException {
        CFIL cfil = new CFIL();
        cfil.setApplid(this.getCICSAppl().getName());
        cfil.setResource(this.getName());
        Result result = UtilityFunctionRunner.executeAndParse(this.getSystem(), (IPDConnectEndpoint)FMHost.getSystem((IPDHost)this.getSystem()), cfil, new CFILParser(this.getCICSAppl()), monitor);
        List cicsFiles = (List)result.getOutput();
        CicsFile updateFrom = null;
        if (cicsFiles == null) {
            logger.trace(new Object[]{"Error refreshingSelf for CICS file ", this.getFormattedName()});
        } else if (cicsFiles.isEmpty()) {
            logger.trace(new Object[]{"CICS file does not exist: ", this});
        } else {
            CicsFile matchingCicsFile = (CicsFile)cicsFiles.get(0);
            if (!this.getName().equals(matchingCicsFile.getName())) {
                logger.error(new Object[]{this.getName(), " expected but got CICS file name of ", matchingCicsFile.getName()});
                return result;
            }
            updateFrom = matchingCicsFile;
        }
        this.updateFrom(updateFrom);
        return result;
    }

    private void updateFrom(CicsFile updateFrom) {
        if (updateFrom == null) {
            this.setConfirmedExists(false);
            this.setProperties(null);
        } else {
            this.setConfirmedExists(true);
            this.setProperties(updateFrom.getProperties());
        }
    }

    public String getPDImageName() {
        return "cicsFile";
    }

    public String getPDLabel() {
        return this.getName();
    }

    public String getPDPluginId() {
        return "com.ibm.etools.fm.ui";
    }
}

