/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.core.model.cics;

import com.ibm.etools.fm.core.model.FMHost;
import com.ibm.etools.fm.core.model.cics.CicsAppl;
import com.ibm.etools.fm.core.socket.func.CAPL;
import com.ibm.etools.fm.core.socket.func.CAPLParser;
import com.ibm.etools.fm.core.socket.func.UtilityFunctionRunner;
import com.ibm.pdtools.common.component.core.model.PDPlatformObject;
import com.ibm.pdtools.common.component.jhost.comms.HostType;
import com.ibm.pdtools.common.component.jhost.core.model.IPDConnectEndpoint;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.registery.EListener;
import com.ibm.pdtools.common.component.jhost.registery.EntityEvent;
import com.ibm.pdtools.common.component.jhost.registery.EntityEventDispatcher;
import com.ibm.pdtools.common.component.jhost.registery.IEntityEventDispatcher;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;

public class CicsApplIDQuery
extends PDPlatformObject
implements IEntityEventDispatcher<CicsApplIDQuery> {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    public static final String MULTI_CHAR_WILDCARD = "*";
    public static final Object PROPERTY_QUERY = new Object();
    public static final Object PROPERTY_LOADED_CICS_APPLS = new Object();
    private static final Pattern validRegexp = Pattern.compile("([A-Z0-9#$@*]{1,8})|([*])");
    private String query;
    private List<CicsAppl> cicsApps = null;
    private final EntityEventDispatcher<CicsApplIDQuery> eventDispatcher = new EntityEventDispatcher((Object)this);

    public static CicsApplIDQuery create(IPDHost system, String query) {
        return new CicsApplIDQuery(system, query);
    }

    public static CicsApplIDQuery createForHost(IPDHost system) {
        return new CicsApplIDQuery(system, MULTI_CHAR_WILDCARD);
    }

    public static boolean isValidQuery(String queryText, String codepage) throws IllegalArgumentException {
        if (queryText == null) {
            throw new IllegalArgumentException("Must specify a non-null queryText.");
        }
        if (queryText.isEmpty()) {
            return false;
        }
        String nameCheck = null;
        try {
            nameCheck = new String(queryText.getBytes(codepage), HostType.ZOS.getCommunicationEncoding());
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return validRegexp.matcher(nameCheck).matches();
    }

    public CicsApplIDQuery(IPDHost system, String query) throws IllegalArgumentException {
        if (system == null) {
            throw new IllegalArgumentException("Must provide a non-null parameter");
        }
        if (!CicsApplIDQuery.isValidQuery(query, system.getCodePage())) {
            throw new IllegalArgumentException(query);
        }
        this.query = query.toUpperCase();
        this.setSystem(system);
    }

    public CicsApplIDQuery clone() {
        CicsApplIDQuery clone = CicsApplIDQuery.create(this.getSystem(), this.query);
        if (this.cicsApps != null) {
            clone.setCICSApps(new ArrayList<CicsAppl>(this.cicsApps));
        }
        return clone;
    }

    public boolean equals(Object obj) {
        if (obj instanceof CicsApplIDQuery) {
            CicsApplIDQuery otherQuery = (CicsApplIDQuery)((Object)obj);
            return this.query.equals(otherQuery.query) && this.getSystem().equals(otherQuery.getSystem());
        }
        return false;
    }

    public int hashCode() {
        return this.query.hashCode() * this.getSystem().hashCode();
    }

    public String getQuery() {
        return this.query;
    }

    protected void setCICSApps(List<CicsAppl> cicsApps) {
        this.cicsApps = cicsApps;
        this.eventDispatcher.fireChangedEvent(PROPERTY_LOADED_CICS_APPLS);
    }

    public List<CicsAppl> getCICSApps() {
        if (this.cicsApps == null) {
            return this.cicsApps;
        }
        return Collections.unmodifiableList(this.cicsApps);
    }

    public Result<List<CicsAppl>> loadCICSApps(IHowIsGoing monitor) throws InterruptedException {
        CAPL capl = new CAPL();
        capl.setApplId(this.getQuery());
        Result result = UtilityFunctionRunner.executeAndParse(this.getSystem(), (IPDConnectEndpoint)FMHost.getSystem((IPDHost)this.getSystem()), capl, new CAPLParser(this.getSystem()), monitor);
        this.setCICSApps((List)result.getOutput());
        return result;
    }

    public String toString() {
        return this.query;
    }

    public void setQuery(String value) {
        if (!CicsApplIDQuery.isValidQuery(value, this.getSystem().getCodePage())) {
            throw new IllegalArgumentException(value);
        }
        this.query = value.toUpperCase();
        this.eventDispatcher.fireChangedEvent(PROPERTY_QUERY);
    }

    public void addListener(EListener<EntityEvent<CicsApplIDQuery>> listener) {
        this.eventDispatcher.addListener(listener);
    }

    public void removeListener(EListener<EntityEvent<CicsApplIDQuery>> listener) {
        this.eventDispatcher.removeListener(listener);
    }

    public String getPDImageName() {
        return "cicsApplIDQuery";
    }

    public String getPDLabel() {
        return this.getQuery();
    }

    public String getPDPluginId() {
        return "com.ibm.etools.fm.ui";
    }
}

