/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.core.model.cics;

import com.ibm.etools.fm.core.model.FMHost;
import com.ibm.etools.fm.core.socket.func.CAPL;
import com.ibm.etools.fm.core.socket.func.CAPLParser;
import com.ibm.etools.fm.core.socket.func.UtilityFunctionRunner;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.model.PDPlatformObject;
import com.ibm.pdtools.common.component.jhost.comms.HostType;
import com.ibm.pdtools.common.component.jhost.core.model.IPDConnectEndpoint;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.ISystemsLabelDecorator;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.regex.Pattern;

public class CicsAppl
extends PDPlatformObject
implements Comparable<CicsAppl>,
IZRL,
ISystemsLabelDecorator {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final PDLogger logger = PDLogger.get(CicsAppl.class);
    public static final String PATTERN_VALID_NAME = "[A-Z0-9#$@]{1,8}";
    private static final Pattern validRegexp = Pattern.compile("[A-Z0-9#$@]{1,8}");
    public static final String SUFFIX = ":";
    private String applId = "";
    private String description = "";
    private boolean canConnect = true;
    private ArrayList<String> messages = new ArrayList();
    private boolean confirmedExists = false;
    private final Properties cicsAppProperties = new Properties();

    public static CicsAppl create(IPDHost system, String applId) {
        return new CicsAppl(system, applId);
    }

    public static boolean isValidName(String fullName, String codepage) throws IllegalArgumentException {
        if (fullName == null) {
            throw new IllegalArgumentException("Must provide a non-null parameter");
        }
        String nameCheck = null;
        try {
            nameCheck = new String(fullName.getBytes(codepage), HostType.ZOS.getCommunicationEncoding());
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return validRegexp.matcher(nameCheck).matches();
    }

    protected CicsAppl(IPDHost system, String applId) {
        if (system == null) {
            throw new IllegalArgumentException("System cannot be null");
        }
        if (!CicsAppl.isValidName(applId, system.getCodePage())) {
            throw new IllegalArgumentException("applId='" + (applId == null ? "null" : applId) + "'");
        }
        this.applId = applId.toUpperCase();
        this.setSystem(system);
    }

    public CicsAppl clone() {
        CicsAppl copy = CicsAppl.create(this.getSystem(), this.applId);
        copy.setDescription(this.description);
        copy.setCanConnect(this.canConnect);
        copy.setConfirmedExists(this.confirmedExists);
        for (Object key : this.cicsAppProperties.keySet()) {
            copy.setPersistentProperty(key.toString(), this.cicsAppProperties.get(key).toString());
        }
        for (String aMsg : this.getMessages()) {
            copy.addMessage(aMsg);
        }
        return copy;
    }

    public boolean equals(Object obj) {
        if (obj instanceof CicsAppl) {
            CicsAppl anApp = (CicsAppl)obj;
            return anApp.getSystem().equals(this.getSystem()) && anApp.applId.equals(this.applId);
        }
        return false;
    }

    public int hashCode() {
        return this.applId.hashCode() * this.getSystem().hashCode();
    }

    @Override
    public int compareTo(CicsAppl o) {
        int systemCompare = this.getSystem().compareTo(o.getSystem());
        if (systemCompare != 0) {
            return systemCompare;
        }
        return this.applId.compareTo(o.applId);
    }

    public String getName() {
        return this.applId;
    }

    protected void setName(String name) {
        this.applId = name;
    }

    public String getNameWithDescription() {
        if (this.description != null && this.description.length() > 0) {
            return this.applId + ": " + this.description;
        }
        return this.applId;
    }

    public String getFormattedName() {
        return this.getName();
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean canConnect() {
        return this.canConnect;
    }

    public void setCanConnect(boolean canConnect) {
        this.canConnect = canConnect;
    }

    public ArrayList<String> getMessages() {
        return this.messages;
    }

    public void addMessage(String msg) {
        this.messages.add(msg);
    }

    public void setConfirmedExists(boolean confirmedExists) {
        this.confirmedExists = confirmedExists;
    }

    public boolean getConfirmedExists() {
        return this.confirmedExists;
    }

    public String getPersistentProperty(String key) {
        return this.cicsAppProperties.getProperty(key);
    }

    public void setPersistentProperty(String key, String value) {
        this.cicsAppProperties.setProperty(key, value);
    }

    private void renameTo(IPDHost host, String newName) {
        if (newName == null) {
            throw new IllegalArgumentException();
        }
        if (!this.isValidNewName(host, newName)) {
            throw new IllegalArgumentException(newName);
        }
        this.setName(newName);
        this.setConfirmedExists(false);
    }

    public boolean isValidNewName(IPDHost host, String newName) {
        if (newName.toUpperCase().equals(this.getName().toUpperCase())) {
            return false;
        }
        return CicsAppl.isValidName(newName, host.getCodePage());
    }

    public String toString() {
        return this.getName();
    }

    public Result<?> refreshSelf(IHowIsGoing monitor) throws InterruptedException {
        return this.doRefresh(monitor, true);
    }

    public Result<?> refreshExistence(IHowIsGoing monitor) throws InterruptedException {
        return this.doRefresh(monitor, false);
    }

    private synchronized Result<?> doRefresh(IHowIsGoing monitor, boolean doFullRefresh) throws InterruptedException {
        CAPL capl = new CAPL();
        capl.setApplId(this.getName());
        Result result = UtilityFunctionRunner.executeAndParse(this.getSystem(), (IPDConnectEndpoint)FMHost.getSystem((IPDHost)this.getSystem()), capl, new CAPLParser(this.getSystem()), monitor);
        List cicsApps = (List)result.getOutput();
        CicsAppl updateFrom = null;
        if (cicsApps == null) {
            logger.trace(new Object[]{"Error refreshingSelf for CICS apps ", this.getFormattedName()});
        } else if (cicsApps.isEmpty()) {
            logger.trace(new Object[]{"CICS App does not exist: ", this});
        } else {
            CicsAppl matchingCICSapp = (CicsAppl)cicsApps.get(0);
            if (!this.getName().equals(matchingCICSapp.getName())) {
                logger.error(new Object[]{this.getName(), " expected but got CICS app name of ", matchingCICSapp.getName()});
                return result;
            }
            updateFrom = matchingCICSapp;
        }
        this.updateFrom(updateFrom);
        return result;
    }

    public void updateFrom(CicsAppl updateFrom) {
        if (updateFrom == null) {
            this.setConfirmedExists(false);
            this.setDescription("");
            this.setCanConnect(false);
            this.getMessages().clear();
        } else {
            this.setConfirmedExists(true);
            this.setDescription(updateFrom.getDescription());
            this.setCanConnect(updateFrom.canConnect());
            this.getMessages().clear();
            for (String aMsg : updateFrom.getMessages()) {
                this.addMessage(aMsg);
            }
        }
    }

    public String getPDImageName() {
        return "cicsApplid";
    }

    public String getPDLabel() {
        return this.getNameWithDescription();
    }

    public String getPDPluginId() {
        return "com.ibm.etools.fm.ui";
    }

    public boolean checkDecorateImageStatic() {
        return !this.canConnect();
    }

    public Object getNewImage(Object anImage) {
        return anImage;
    }

    public String copyName() {
        return this.getFormattedName();
    }
}

