/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.core.model;

import com.ibm.etools.fm.core.model.DataSet;
import com.ibm.etools.fm.core.model.Member;
import com.ibm.etools.fm.core.model.MessageQueue;
import com.ibm.etools.fm.core.model.UssFile;
import com.ibm.etools.fm.core.model.cics.CicsFile;
import com.ibm.etools.fm.core.model.cics.CicsResource;
import com.ibm.etools.fm.core.model.cics.CicsTemporaryStorage;
import com.ibm.etools.fm.core.model.cics.CicsTransientData;
import com.ibm.etools.fm.core.model.db2.Db2Object;
import com.ibm.etools.fm.core.model.db2.Db2Subsystem;
import com.ibm.pdtools.common.component.jhost.comms.HostType;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class ZRLs {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final Class<?>[] ALL_RESOURCE_TYPES_FOR_ZOS = new Class[]{DataSet.class, Member.class, UssFile.class, MessageQueue.class, CicsFile.class, CicsTransientData.class, CicsTemporaryStorage.class};

    public static Class<?>[] getEditableResourceTypes(IPDHost aHost) {
        Objects.requireNonNull(aHost, "Must provide a non-null IPDHost.");
        Class<Object>[] types = aHost.getHostType() == HostType.ZOS ? ALL_RESOURCE_TYPES_FOR_ZOS : new Class[]{};
        return types != null ? Arrays.copyOf(types, types.length) : new Class[]{};
    }

    public static boolean isSupportedResourceType(IPDHost aHost, IZRL aResource) {
        Objects.requireNonNull(aHost, "Must specify a non-null IPDHost.");
        if (aHost.getHostType() == HostType.ZOS) {
            return ZRLs.isMemberOf(ALL_RESOURCE_TYPES_FOR_ZOS, aResource);
        }
        return false;
    }

    private static boolean isMemberOf(Class<?>[] types, IZRL aResource) {
        Objects.requireNonNull(types, "Must provide a non-null array of types.");
        Objects.requireNonNull(aResource, "Must provide a non-null IZRL.");
        int i = 0;
        while (i < types.length) {
            if (aResource.getClass().equals(types[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static List<String> convertZRLListToFormattedNames(List<IZRL> zrlList) {
        if (zrlList == null || zrlList.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<String> formattedNameList = new ArrayList<String>();
        for (IZRL zrl : zrlList) {
            formattedNameList.add(zrl.getFormattedName());
        }
        return formattedNameList;
    }

    public static IZRL parseZRL(IPDHost host, String path) {
        Objects.requireNonNull(path, "Provided a null String path to parseZRL(Host, String)");
        if (path.trim().isEmpty()) {
            throw new IllegalArgumentException("Must provide a non-empty path.");
        }
        Objects.requireNonNull(host, "Provided a null Host object to parseZRL(Host, String)");
        if (path.isEmpty()) {
            throw new IllegalArgumentException();
        }
        if ("/".equals(path.substring(0, "/".length()))) {
            return UssFile.parse(host, path);
        }
        if (path.toUpperCase().startsWith("MQ:")) {
            return MessageQueue.parse(host, path);
        }
        if (path.toUpperCase().startsWith("FI:") || path.toUpperCase().startsWith("TD:") || path.toUpperCase().startsWith("TS:")) {
            return CicsResource.parseCICSResource(host, path);
        }
        if (Db2Object.Db2Objects.isParseableDb2Object(host, path)) {
            return Db2Object.Db2Objects.parseDb2Object(host, path);
        }
        if (path.toUpperCase().startsWith("DB2:")) {
            return Db2Subsystem.parseSubsystem(host, path);
        }
        return Member.parse(host, path);
    }

    public static boolean isParseable(IPDHost host, String path) {
        if (host == null) {
            throw new IllegalArgumentException("System cannot be null");
        }
        return ZRLs.isParseable(host, path, host.getCodePage());
    }

    public static boolean isParseable(IPDHost host, String path, String codepage) {
        if (path == null) {
            return false;
        }
        boolean parseableUssPath = UssFile.isParseableAbsolutePath(host, path);
        boolean parseableMQ = MessageQueue.isParseable(path, codepage);
        boolean parseableDataSetOrMember = false;
        parseableDataSetOrMember = Member.isParseable(path, false, codepage);
        boolean parseableCicsResource = CicsResource.isParseable(host, path);
        boolean parseableDb2Database = Db2Object.Db2Objects.isParseableDb2Object(host, path);
        return parseableUssPath || parseableMQ || parseableDataSetOrMember || parseableCicsResource || parseableDb2Database;
    }

    public static Class<?>[] getAllResourceTypesForZos() {
        return Arrays.copyOf(ALL_RESOURCE_TYPES_FOR_ZOS, ALL_RESOURCE_TYPES_FOR_ZOS.length);
    }
}

