/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.core.model;

import com.ibm.pdtools.common.component.core.model.PDPlatformObject;
import com.ibm.pdtools.common.component.jhost.comms.HostType;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.util.EncodingUtils;
import java.util.Objects;
import java.util.regex.Pattern;

public class Volume
extends PDPlatformObject
implements Comparable<Volume> {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private final int hashcode;
    private static final String PATTERN_VOLSER = "[@#$A-Z0-9]{1,6}";
    private static final Pattern validVolserRegexp = Pattern.compile("[@#$A-Z0-9]{1,6}");
    protected final String volserID;

    public static Volume create(IPDHost system, String volserID) {
        return new Volume(system, volserID);
    }

    public static boolean isValid(String volserID, String codepage) {
        Objects.requireNonNull(volserID, "Please provide a non-null volserID");
        volserID = EncodingUtils.codepageConverter((String)volserID, (String)codepage, (String)HostType.ZOS.getCommunicationEncoding());
        return volserID.trim().equals("*") || validVolserRegexp.matcher(volserID).matches();
    }

    protected Volume(IPDHost hostProvider, String volserID) {
        Objects.requireNonNull(hostProvider, "Please provide a non-null hostProvider.");
        if (!Volume.isValid(volserID, hostProvider.getCodePage())) {
            throw new IllegalArgumentException(volserID);
        }
        this.setSystem(hostProvider.getSystem());
        this.volserID = volserID;
        this.hashcode = hostProvider.getSystem().hashCode() + volserID.hashCode();
    }

    public String getVolserID() {
        return this.volserID;
    }

    public String toString() {
        return this.volserID;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Volume) {
            Volume otherVol = (Volume)obj;
            return otherVol.getSystem().equals(this.getSystem()) && otherVol.volserID.equals(this.volserID);
        }
        return false;
    }

    public int hashCode() {
        return this.hashcode;
    }

    @Override
    public int compareTo(Volume volume) {
        return this.volserID.compareTo(volume.volserID);
    }

    public String getPDImageName() {
        return null;
    }

    public String getPDLabel() {
        return null;
    }

    public String getPDPluginId() {
        return "com.ibm.etools.fm.ui";
    }
}

