/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.core.model;

import com.ibm.etools.fm.core.Messages;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public enum UssFileType {
    Dir(Messages.UssFileType_DIRECTORY),
    Char(Messages.UssFileType_SPECIAL_FILE),
    File(Messages.UssFileType_FILE),
    FIFO(Messages.UssFileType_PIPE),
    Syml(Messages.UssFileType_SYMBOLIC_LINK),
    Sckt(Messages.UssFileType_SOCKET),
    BlkS(Messages.UssFileType_BLOCK_SPECIAL_FILE),
    Extl(Messages.UssFileType_EXTERNAL_LINK),
    Unkn(Messages.UssFileType_UNKNOWN);

    private String name;
    private static final List<UssFileType> NON_STANDARD_VALUES;
    public static final List<UssFileType> STANDARD_VALUES;

    static {
        NON_STANDARD_VALUES = Collections.unmodifiableList(Arrays.asList(Unkn));
        UssFileType[] values = UssFileType.values();
        UssFileType[] standardValues = new UssFileType[values.length - NON_STANDARD_VALUES.size()];
        int j = 0;
        int i = 0;
        while (i < values.length) {
            boolean isStandard = true;
            int k = 0;
            while (k < NON_STANDARD_VALUES.size()) {
                if (NON_STANDARD_VALUES.get(k) == values[i]) {
                    isStandard = false;
                    break;
                }
                ++k;
            }
            if (isStandard) {
                standardValues[j++] = values[i];
            }
            ++i;
        }
        STANDARD_VALUES = Collections.unmodifiableList(Arrays.asList(standardValues));
    }

    private UssFileType(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static UssFileType parse(String name) {
        Objects.requireNonNull(name, "Please specify a non-null name.");
        name = name.toLowerCase();
        UssFileType[] ussFileTypeArray = UssFileType.values();
        int n = ussFileTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            UssFileType fileType = ussFileTypeArray[n2];
            if (fileType.toString().toLowerCase().equals(name) || fileType.getName().toLowerCase().equals(name)) {
                return fileType;
            }
            ++n2;
        }
        throw new IllegalArgumentException();
    }
}

