/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.core.model;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.FMHost;
import com.ibm.etools.fm.core.model.UssFile;
import com.ibm.etools.fm.core.model.UssFileType;
import com.ibm.etools.fm.core.socket.func.UFL;
import com.ibm.etools.fm.core.socket.func.UFLParser;
import com.ibm.etools.fm.core.socket.func.UtilityFunctionRunner;
import com.ibm.pdtools.common.component.core.model.PDPlatformObject;
import com.ibm.pdtools.common.component.jhost.core.model.IPDConnectEndpoint;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.registery.EListener;
import com.ibm.pdtools.common.component.jhost.registery.EntityEvent;
import com.ibm.pdtools.common.component.jhost.registery.EntityEventDispatcher;
import com.ibm.pdtools.common.component.jhost.registery.IEntityEventDispatcher;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import com.ibm.pdtools.common.component.jhost.util.StringUtils;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;

public class UssFileQuery
extends PDPlatformObject
implements IEntityEventDispatcher<UssFileQuery> {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    public static final String SINGLE_CHAR_WILDCARD = "%";
    public static final String MULTI_CHAR_WILDCARD = "*";
    public static final Object PROPERTY_QUERY = new Object();
    public static final Object PROPERTY_LOADED_FILES = new Object();
    public static final Object PROPERTY_TYPE_FILTER = new Object();
    private static final Pattern VALID_REGEXP = Pattern.compile("\\A/([^/*%\\u0000]+/)*[^/\\u0000]*\\Z");
    private UssFile dir;
    private String query;
    private Pattern pattern;
    private List<UssFile> files;
    protected ArrayList<UssFileType> typesFiltered = new ArrayList();
    private final EntityEventDispatcher<UssFileQuery> eventDispatcher = new EntityEventDispatcher((Object)this);

    public static UssFileQuery create(IPDHost system, String query) {
        return new UssFileQuery(system, query);
    }

    public static UssFileQuery createForHost(IPDHost system) {
        return new UssFileQuery(system, "/");
    }

    public static boolean isValidQuery(IPDHost host, String queryText) {
        Objects.requireNonNull(queryText, "Please provide a non-null queryText.");
        String nameCheck = null;
        try {
            nameCheck = new String(queryText.getBytes(host.getCodePage()), host.getCommunicationCodePage());
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return VALID_REGEXP.matcher(nameCheck).matches();
    }

    public static Pattern convertToRegexp(String query) {
        String matchString = StringUtils.escapeRegex((String)query);
        matchString = matchString.replaceAll(StringUtils.escapeRegex((String)"\\*"), ".*");
        matchString = matchString.replaceAll(SINGLE_CHAR_WILDCARD, ".");
        return Pattern.compile(matchString, 66);
    }

    protected UssFileQuery(IPDHost system, String query) {
        Objects.requireNonNull(system, "Please provide a non-null system.");
        this.setSystem(system);
        this.setQuery(query);
    }

    public UssFileQuery clone() {
        UssFileQuery clone = UssFileQuery.create(this.getSystem(), this.query);
        if (this.files != null) {
            clone.setFiles(new ArrayList<UssFile>(this.files));
        }
        clone.setTypesFiltered(this.typesFiltered);
        return clone;
    }

    public boolean equals(Object obj) {
        if (obj instanceof UssFileQuery) {
            UssFileQuery otherQuery = (UssFileQuery)((Object)obj);
            return otherQuery.getSystem().equals(this.getSystem()) && otherQuery.query.equals(this.query) && otherQuery.typesFiltered.equals(this.typesFiltered);
        }
        return false;
    }

    public int hashCode() {
        return this.getSystem().hashCode() * this.query.hashCode() * this.typesFiltered.hashCode();
    }

    public Pattern getPattern() {
        if (this.pattern == null) {
            this.pattern = UssFileQuery.convertToRegexp(this.query);
        }
        return this.pattern;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        if (!UssFileQuery.isValidQuery(this.getSystem(), (String)query)) {
            throw new IllegalArgumentException((String)query);
        }
        if (((String)query).length() > 0 && ((String)query).charAt(((String)query).length() - 1) == "/".charAt(0)) {
            query = (String)query + MULTI_CHAR_WILDCARD;
        }
        this.query = query;
        this.dir = UssFile.parse(this.getSystem(), (String)query);
        if (!this.dir.isDirectory()) {
            this.dir = this.dir.getParent();
        }
        this.eventDispatcher.fireChangedEvent(PROPERTY_QUERY);
    }

    public List<UssFile> getFiles() {
        if (this.files == null) {
            return this.files;
        }
        return Collections.unmodifiableList(this.files);
    }

    protected void setFiles(List<UssFile> files) {
        this.files = files;
    }

    public List<UssFileType> getTypesFiltered() {
        return Collections.unmodifiableList(this.typesFiltered);
    }

    public void setTypesFiltered(Collection<UssFileType> typesFiltered) {
        Objects.requireNonNull(typesFiltered, "Must provide a non-null typesFiltered");
        this.typesFiltered.clear();
        this.typesFiltered.addAll(typesFiltered);
        this.eventDispatcher.fireChangedEvent(PROPERTY_TYPE_FILTER);
    }

    public void addListener(EListener<EntityEvent<UssFileQuery>> listener) {
        this.eventDispatcher.addListener(listener);
    }

    public void removeListener(EListener<EntityEvent<UssFileQuery>> listener) {
        this.eventDispatcher.removeListener(listener);
    }

    public Result<List<UssFile>> loadFiles(IHowIsGoing monitor) throws InterruptedException {
        UFL ufl = new UFL();
        ufl.setPath(this.dir.getFormattedName());
        ufl.setProps(true);
        Result refreshResult = UtilityFunctionRunner.executeAndParse(this.getSystem(), (IPDConnectEndpoint)FMHost.getSystem((IPDHost)this.getSystem()), ufl, new UFLParser(this.dir), monitor);
        if (refreshResult.getOutput() != null) {
            if (this.dir.isDirectory()) {
                ArrayList modifiedResultFiles = new ArrayList((Collection)refreshResult.getOutput());
                int i = 0;
                while (i < ((List)refreshResult.getOutput()).size()) {
                    UssFile ussFile = (UssFile)((List)refreshResult.getOutput()).get(i);
                    if (".".equals(ussFile.getName())) {
                        modifiedResultFiles.remove(i);
                    }
                    ++i;
                }
                refreshResult.setOutput(modifiedResultFiles);
            }
            refreshResult.setOutput(this.filterByNames((List)refreshResult.getOutput()));
            refreshResult.setOutput(this.filterByTypes((List)refreshResult.getOutput()));
        }
        this.setFiles((List)refreshResult.getOutput());
        this.eventDispatcher.fireChangedEvent(PROPERTY_LOADED_FILES);
        return refreshResult;
    }

    private List<UssFile> filterByNames(List<UssFile> files) {
        ArrayList<UssFile> filtered = new ArrayList<UssFile>(files.size());
        int i = 0;
        while (i < files.size()) {
            UssFile ussFile = files.get(i);
            String formattedName = ussFile.getFormattedName();
            if (ussFile.isDirectory()) {
                formattedName = formattedName.substring(0, formattedName.length() - 1);
            }
            if (this.getPattern().matcher(formattedName).matches()) {
                filtered.add(ussFile);
            }
            ++i;
        }
        return filtered;
    }

    private List<UssFile> filterByTypes(List<UssFile> files) {
        ArrayList<UssFile> filtered = new ArrayList<UssFile>(files.size());
        int i = 0;
        while (i < files.size()) {
            UssFile ussFile = files.get(i);
            if (this.getTypesFiltered().isEmpty() || this.getTypesFiltered().contains((Object)ussFile.getType())) {
                filtered.add(ussFile);
            }
            ++i;
        }
        return filtered;
    }

    public String toString() {
        return MessageFormat.format(Messages.UssFileQuery_0, this.query);
    }

    public String getPDImageName() {
        return "uss_query";
    }

    public String getPDLabel() {
        return this.getQuery();
    }

    public String getPDPluginId() {
        return "com.ibm.etools.fm.ui";
    }
}

