/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.core.model;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.FMHost;
import com.ibm.etools.fm.core.model.IDeletable;
import com.ibm.etools.fm.core.model.UssFileType;
import com.ibm.etools.fm.core.model.data.UssFileProperties;
import com.ibm.etools.fm.core.socket.func.UFDEL;
import com.ibm.etools.fm.core.socket.func.UFDELD;
import com.ibm.etools.fm.core.socket.func.UFL;
import com.ibm.etools.fm.core.socket.func.UFLParser;
import com.ibm.etools.fm.core.socket.func.UtilityFunctionRunner;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.model.PDPlatformObject;
import com.ibm.pdtools.common.component.jhost.core.model.IPDConnectEndpoint;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.regex.Pattern;

public class UssFile
extends PDPlatformObject
implements IDeletable {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2020. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    public static final String FILE_SEPARATOR = "/";
    private static final Pattern PARSEABLE_REGEXP = Pattern.compile("/([^\\u0000/]+/?)*");
    private static final Pattern VALID_NAME_REGEXP = Pattern.compile("(/|[^\\u0000/]+/?)");
    private final String name;
    private final UssFileType type;
    private final UssFile parent;
    private final List<UssFile> path;
    private final Properties resourceProperties = new Properties();
    private UssFileProperties properties;
    private boolean confirmedExists = false;
    protected List<UssFile> files = null;
    private static final PDLogger logger = PDLogger.get(UssFile.class);

    public static UssFile parse(IPDHost host, String strPath) {
        if (!UssFile.isParseableAbsolutePath(host, strPath)) {
            throw new IllegalArgumentException(strPath);
        }
        boolean isFile = true;
        if (strPath.substring(strPath.length() - 1).equals(FILE_SEPARATOR)) {
            isFile = false;
        }
        String[] items = strPath.split(FILE_SEPARATOR);
        UssFile prev = new UssFile(host);
        int i = 0;
        while (i < items.length) {
            if (!items[i].isEmpty()) {
                UssFileType type = UssFileType.Dir;
                if (isFile && i == items.length - 1) {
                    type = UssFileType.File;
                }
                prev = new UssFile(prev, items[i], type);
            }
            ++i;
        }
        return prev;
    }

    public static final boolean isParseableAbsolutePath(IPDHost host, String path) {
        Objects.requireNonNull(path, "Must provide a non-null path.");
        if (path.isEmpty()) {
            return false;
        }
        String nameCheck = null;
        try {
            nameCheck = new String(path.getBytes(host.getCodePage()), host.getCommunicationCodePage());
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return PARSEABLE_REGEXP.matcher(nameCheck).matches();
    }

    public static final boolean isValidName(IPDHost host, String name) {
        Objects.requireNonNull(name, "Must provide a non-null name.");
        if (name.isEmpty()) {
            return false;
        }
        String nameCheck = null;
        try {
            nameCheck = new String(name.getBytes(host.getCodePage()), host.getCommunicationCodePage());
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return VALID_NAME_REGEXP.matcher(nameCheck).matches();
    }

    public UssFile(IPDHost system) {
        this.setSystem(Objects.requireNonNull(system, "Must provide a non-null system"));
        this.name = FILE_SEPARATOR;
        this.type = UssFileType.Dir;
        this.parent = null;
        ArrayList<UssFile> path = new ArrayList<UssFile>();
        path.add(this);
        this.path = Collections.unmodifiableList(path);
    }

    public UssFile(UssFile parent, String name, UssFileType type) {
        Objects.requireNonNull(parent, "Must provide a non-null parent");
        Objects.requireNonNull(type, "Must provide a non-null type");
        if (!UssFile.isValidName(parent.getSystem(), (String)name)) {
            throw new IllegalArgumentException("name='" + (String)(name == null ? "null" : name) + "'");
        }
        this.setSystem(parent.getSystem());
        if (type == UssFileType.Dir && !((String)name).substring(((String)name).length() - 1).equals(FILE_SEPARATOR)) {
            name = (String)name + FILE_SEPARATOR;
        }
        this.name = name;
        this.type = type;
        this.parent = parent;
        ArrayList<UssFile> path = new ArrayList<UssFile>();
        if (!parent.isDirectory()) {
            throw new IllegalArgumentException(parent.getFormattedName());
        }
        path.addAll(parent.getAncestors());
        path.add(this);
        this.path = Collections.unmodifiableList(path);
    }

    public UssFile clone() {
        UssFile copy = this.isRootDirectory() ? new UssFile(this.getSystem()) : UssFile.parse(this.getSystem(), this.getFormattedName());
        copy.setProperties(this.properties);
        copy.setConfirmedExists(this.confirmedExists);
        for (Object key : this.resourceProperties.keySet()) {
            copy.setPersistentProperty(key.toString(), this.resourceProperties.get(key).toString());
        }
        return copy;
    }

    public UssFileType getType() {
        return this.type;
    }

    public boolean isDirectory() {
        return this.type == UssFileType.Dir;
    }

    public boolean isRootDirectory() {
        return this.isDirectory() && this.parent == null && this.name.equals(FILE_SEPARATOR);
    }

    public boolean hasAbsolutePath() {
        return this.path.get(0).isRootDirectory();
    }

    public String getName() {
        if (this.isDirectory()) {
            return this.name.substring(0, this.name.length() - 1);
        }
        return this.name;
    }

    public List<UssFile> getAncestors() {
        return this.path;
    }

    public UssFile getParent() {
        return this.parent;
    }

    public boolean equals(Object obj) {
        if (obj instanceof UssFile) {
            UssFile other = (UssFile)obj;
            if (this.getSystem().equals(other.getSystem()) && this.name.equals(other.name)) {
                if (this.parent == null && other.parent == null) {
                    return true;
                }
                if (this.parent != null && other.parent != null) {
                    return this.parent.equals(other.parent);
                }
            }
        }
        return false;
    }

    public int hashCode() {
        return this.getSystem().hashCode() * this.name.hashCode() * (this.parent == null ? 1 : this.parent.hashCode());
    }

    public String toString() {
        return this.name;
    }

    public List<UssFile> getFiles() {
        return this.files;
    }

    public Result<List<UssFile>> loadFiles(IHowIsGoing monitor, boolean loadProperties) throws InterruptedException {
        return this.refreshSelf(monitor);
    }

    public String getFormattedName() {
        StringBuilder nameSb = new StringBuilder();
        for (UssFile file : this.path) {
            nameSb.append(file.name);
        }
        return nameSb.toString();
    }

    public String getPersistentProperty(String key) {
        return this.resourceProperties.getProperty(key);
    }

    public void setPersistentProperty(String key, String value) {
        this.resourceProperties.setProperty(key, value);
    }

    public void setProperties(UssFileProperties properties) {
        this.properties = properties;
    }

    public UssFileProperties getProperties() {
        return this.properties;
    }

    public void setConfirmedExists(boolean confirmedExists) {
        this.confirmedExists = confirmedExists;
    }

    public boolean getConfirmedExists() {
        return this.confirmedExists;
    }

    public Result<List<UssFile>> refreshSelf(IHowIsGoing monitor) throws InterruptedException {
        return this.doRefresh(monitor, true);
    }

    public Result<?> refreshExistence(IHowIsGoing monitor) throws InterruptedException {
        return this.doRefresh(monitor, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result<List<UssFile>> doRefresh(IHowIsGoing monitor, boolean doFullRefresh) throws InterruptedException {
        UssFile ussFile = this;
        synchronized (ussFile) {
            UFL ufl = new UFL();
            ufl.setPath(this.isDirectory() ? this.getFormattedName() : this.getParent().getFormattedName());
            ufl.setProps(doFullRefresh);
            Result refreshResult = UtilityFunctionRunner.executeAndParse(this.getSystem(), (IPDConnectEndpoint)FMHost.getSystem((IPDHost)this.getSystem()), ufl, new UFLParser(this.isDirectory() ? this : this.getParent()), monitor);
            List resultFiles = (List)refreshResult.getOutput();
            UssFile updateFrom = null;
            if (resultFiles == null) {
                logger.error((Object)("Error refreshingSelf for " + this.getFormattedName()));
            } else if (resultFiles.isEmpty()) {
                logger.trace((Object)("No matching files for " + this.getFormattedName()));
            } else if (this.isDirectory()) {
                ArrayList<UssFile> modifiedResultFiles = new ArrayList<UssFile>(resultFiles);
                int i = 0;
                while (i < resultFiles.size()) {
                    UssFile ussFile2 = (UssFile)resultFiles.get(i);
                    if (".".equals(ussFile2.getName())) {
                        modifiedResultFiles.remove(i);
                        updateFrom = ussFile2;
                    }
                    ++i;
                }
                refreshResult.setOutput(modifiedResultFiles);
                this.files = modifiedResultFiles;
            } else {
                this.files = null;
                for (UssFile ussFile3 : resultFiles) {
                    if (!this.getName().equals(ussFile3.getName())) continue;
                    updateFrom = ussFile3;
                }
            }
            this.updateFrom(updateFrom);
            return refreshResult;
        }
    }

    public void updateFrom(UssFile updateFrom) {
        if (updateFrom == null) {
            this.setProperties(null);
            this.setConfirmedExists(false);
        } else {
            this.setProperties(updateFrom.getProperties());
            this.setConfirmedExists(true);
        }
    }

    @Override
    public Result<StringBuffer> deleteOnHost(IHowIsGoing monitor) throws InterruptedException {
        UFDEL ufdel = new UFDEL();
        ufdel.setPath(this.getFormattedName());
        Result<StringBuffer> result = UtilityFunctionRunner.execute(this.getSystem(), (IPDConnectEndpoint)FMHost.getSystem((IPDHost)this.getSystem()), ufdel, monitor);
        this.setConfirmedExists(!result.isSuccessfulWithoutWarnings());
        return result;
    }

    public Result<StringBuffer> deleteDirectoryWithFilesOnHost(IHowIsGoing monitor) throws InterruptedException {
        UFDELD ufdel = new UFDELD();
        ufdel.setPath(this.getFormattedName());
        Result<StringBuffer> result = UtilityFunctionRunner.execute(this.getSystem(), (IPDConnectEndpoint)FMHost.getSystem((IPDHost)this.getSystem()), ufdel, monitor);
        this.setConfirmedExists(!result.isSuccessfulWithoutWarnings());
        return result;
    }

    public String getPDImageName() {
        return this.isDirectory() ? "uss_dir" : "uss_file";
    }

    public String getPDLabel() {
        if (this.isRootDirectory()) {
            return Messages.SystemsLabelProvider_HFS;
        }
        return this.getName();
    }

    public String getPDPluginId() {
        return "com.ibm.etools.fm.ui";
    }

    public String copyName() {
        return this.getFormattedName();
    }
}

