/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.core.model;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.AbstractSessionTemplate;
import com.ibm.etools.fm.core.socket.io.ConnPoolManagerFM;
import com.ibm.etools.fm.core.socket.io.ZosConnectionFM;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.util.PDFileSystemUtil;
import com.ibm.pdtools.common.component.jhost.core.model.IHostProviderName;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.Date;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class SessionTemplate
extends AbstractSessionTemplate {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2021. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static final PDLogger logger = PDLogger.get(SessionTemplate.class);
    private Date started = new Date();
    protected IFile fromCacheFile;
    protected IFile toCacheFile;
    protected ZosConnectionFM connection;
    protected IZRL fromTemplate;
    protected IZRL toTemplate;

    public SessionTemplate(IZRL template) {
        super(template.getSystem(), null);
        this.fromTemplate = template;
        this.toTemplate = null;
    }

    public SessionTemplate(IZRL fromTemplate, IZRL toTemplate) {
        super(fromTemplate.getSystem(), null);
        this.fromTemplate = fromTemplate;
        this.toTemplate = toTemplate;
    }

    public boolean equals(Object obj) {
        if (obj instanceof AbstractSessionTemplate) {
            AbstractSessionTemplate otherSession = (AbstractSessionTemplate)obj;
            return otherSession.getFromTemplate().equals(this.getFromTemplate());
        }
        return false;
    }

    public int hashCode() {
        return this.fromTemplate.hashCode();
    }

    @Override
    public Result<StringBuffer> start(IHowIsGoing monitor) throws InterruptedException {
        return this.start(monitor, null);
    }

    @Override
    public Result<StringBuffer> start(IHowIsGoing monitor, String xmlBuffer) throws InterruptedException {
        logger.trace((Object)"starting a new template edit session.");
        Result result = new Result((Object)new StringBuffer());
        try {
            this.connection = (ZosConnectionFM)ConnPoolManagerFM.instance().getConnection(this.getSystem(), this.getEndpoint(), monitor);
            this.fromCacheFile = PDFileSystemUtil.getLocalCacheFile((String)"FM", (IHostProviderName)this.fromTemplate, (String)"", (String)".fmt");
            if (xmlBuffer != null) {
                this.connection.browseTemplateInXML(this.fromTemplate, this.fromCacheFile.getLocation().toString(), (Result<StringBuffer>)result, monitor, xmlBuffer);
            } else {
                this.connection.browseTemplateInXML(this.fromTemplate, this.fromCacheFile.getLocation().toString(), (Result<StringBuffer>)result, monitor);
            }
            return result;
        }
        catch (InterruptedException ie) {
            throw ie;
        }
        catch (Exception e) {
            result.add(MessageFormat.format(Messages.CommEditTemplateSession_START_ERR, this.fromTemplate.getFormattedName()));
            result.add((Throwable)e);
            return result;
        }
    }

    @Override
    public Result<StringBuffer> startMappingSession(IHowIsGoing monitor, boolean overwriteOldMapping) throws InterruptedException {
        logger.trace((Object)("starting a new template mapping session. from: " + this.fromTemplate.getFormattedName() + " to: " + this.toTemplate.getFormattedName()));
        Result result = new Result((Object)new StringBuffer());
        try {
            this.connection = (ZosConnectionFM)ConnPoolManagerFM.instance().getConnection(this.getSystem(), this.getEndpoint(), monitor);
            this.fromCacheFile = PDFileSystemUtil.getLocalCacheFile((String)"FM", (IHostProviderName)this.fromTemplate, (String)"", (String)".fmt");
            this.toCacheFile = PDFileSystemUtil.getLocalCacheFile((String)"FM", (IHostProviderName)this.toTemplate, (String)"TO_TEMPLE-", (String)".fmt");
            this.connection.startTemplateMappingSessionInXML(this.fromTemplate, this.toTemplate, this.fromCacheFile.getLocation().toString(), this.toCacheFile.getLocation().toString(), (Result<StringBuffer>)result, monitor, overwriteOldMapping);
            this.fromCacheFile.refreshLocal(1, (IProgressMonitor)monitor.getMonitor());
            this.toCacheFile.refreshLocal(1, (IProgressMonitor)monitor.getMonitor());
            return result;
        }
        catch (InterruptedException ie) {
            throw ie;
        }
        catch (Exception e) {
            String errMsg = MessageFormat.format(Messages.CommEditTemplateSession_START_MAPPING_ERR, this.fromTemplate.getFormattedName(), this.toTemplate.getFormattedName());
            logger.error((Object)errMsg, (Throwable)e);
            result.add(errMsg);
            result.add((Throwable)e);
            return result;
        }
    }

    @Override
    public Result<StringBuffer> startNew(IHowIsGoing monitor, StringBuffer newTemplateContents) throws InterruptedException {
        logger.trace((Object)("starting a new template. XML contents: " + String.valueOf(newTemplateContents)));
        Result result = new Result((Object)new StringBuffer());
        try {
            this.connection = (ZosConnectionFM)ConnPoolManagerFM.instance().getConnection(this.getSystem(), this.getEndpoint(), monitor);
            this.fromCacheFile = PDFileSystemUtil.getLocalCacheFile((String)"FM", (IHostProviderName)this.fromTemplate, (String)"", (String)".fmt");
            this.connection.createNewTemplate(this.fromTemplate, this.fromCacheFile.getLocation().toString(), newTemplateContents, (Result<StringBuffer>)result, monitor);
            return result;
        }
        catch (InterruptedException ie) {
            throw ie;
        }
        catch (Exception e) {
            result.add(MessageFormat.format(Messages.CommEditTemplateSession_START_ERR, this.fromTemplate.getFormattedName()));
            result.add((Throwable)e);
            return result;
        }
    }

    @Override
    public Result<StringBuffer> updateAndStart(IHowIsGoing monitor, StringBuffer newTemplateContents) throws InterruptedException {
        logger.trace((Object)("starting a new template. XML contents: " + String.valueOf(newTemplateContents)));
        Result result = new Result((Object)new StringBuffer());
        try {
            this.connection = (ZosConnectionFM)ConnPoolManagerFM.instance().getConnection(this.getSystem(), this.getEndpoint(), monitor);
            this.fromCacheFile = PDFileSystemUtil.getLocalCacheFile((String)"FM", (IHostProviderName)this.fromTemplate, (String)"", (String)".fmt");
            this.connection.updateAndStartTemplateEditSession(this.fromTemplate, this.fromCacheFile.getLocation().toString(), newTemplateContents, (Result<StringBuffer>)result, monitor);
            return result;
        }
        catch (InterruptedException ie) {
            throw ie;
        }
        catch (Exception e) {
            result.add(MessageFormat.format(Messages.CommEditTemplateSession_START_ERR, this.fromTemplate.getFormattedName()));
            result.add((Throwable)e);
            return result;
        }
    }

    @Override
    public Result<StringBuffer> getCompilerListing(IHowIsGoing monitor, IFile listingFile) throws InterruptedException {
        logger.trace((Object)"Getting compiler listing for the current template edit session.");
        Result result = new Result((Object)new StringBuffer());
        this.connection.getCompilerListing((Result<StringBuffer>)result, listingFile, monitor);
        return result;
    }

    @Override
    public IFile getFromCacheFile() {
        return this.fromCacheFile;
    }

    @Override
    public IFile getToCacheFile() {
        return this.toCacheFile;
    }

    @Override
    public void deleteCache() {
        if (this.fromCacheFile != null && this.fromCacheFile.exists()) {
            try {
                this.fromCacheFile.delete(true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public StringBuffer updateTemplate(StringBuffer updateInputXml, IHowIsGoing monitor, Result<StringBuffer> result, boolean retrieveNewTemplate, boolean updateToTemplate) throws InterruptedException {
        logger.trace((Object)("updating template. new XML contents: " + String.valueOf(updateInputXml)));
        logger.trace((Object)("Retrieve template after? " + retrieveNewTemplate));
        return this.connection.updateTemplate(updateInputXml, monitor, result, retrieveNewTemplate, updateToTemplate);
    }

    @Override
    public StringBuffer getCurrentTemplateContents(IHowIsGoing monitor, Result<StringBuffer> result) throws InterruptedException {
        try {
            return this.connection.getTemplateXMLData(monitor, result);
        }
        catch (InterruptedException ie) {
            throw ie;
        }
        catch (Exception e) {
            String errMsg = Messages.Connection_GET_TEMPLATE_EX;
            logger.error((Object)errMsg, (Throwable)e);
            result.add(errMsg);
            result.add((Throwable)e);
            return null;
        }
    }

    @Override
    public IFile saveAs(IZRL target, IHowIsGoing monitor, Result<StringBuffer> overallResult) throws InterruptedException {
        logger.trace((Object)("saveAs for current template. Target: " + target.getFormattedName()));
        Result<StringBuffer> saveAsResult = this.connection.sessionSaveAs(target, monitor);
        overallResult.addSubResult(saveAsResult);
        if (saveAsResult.getRC() > 4) {
            return null;
        }
        this.fromTemplate = target;
        try {
            this.fromCacheFile = PDFileSystemUtil.getLocalCacheFile((String)"FM", (IHostProviderName)this.fromTemplate, (String)"", (String)".fmt");
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
        Result<StringBuffer> result = this.connection.doGETRECX(this.fromCacheFile.getLocation().toString(), monitor);
        overallResult.addSubResult(result);
        if (!result.isSuccessfulWithoutWarnings()) {
            return null;
        }
        return this.fromCacheFile;
    }

    @Override
    public IFile saveTOAs(IZRL target, IHowIsGoing monitor, Result<StringBuffer> overallResult) throws InterruptedException {
        logger.trace((Object)("saveAs for current template field mapping. Target: " + target.getFormattedName()));
        Result<StringBuffer> saveAsResult = this.connection.sessionSaveAs(target, monitor);
        overallResult.addSubResult(saveAsResult);
        if (saveAsResult.getRC() > 4) {
            return null;
        }
        this.toTemplate = target;
        try {
            this.toCacheFile = PDFileSystemUtil.getLocalCacheFile((String)"FM", (IHostProviderName)this.toTemplate, (String)"TO_TEMPLE-", (String)".fmt");
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
        return this.toCacheFile;
    }

    @Override
    public void unlock() {
        if (this.connection != null) {
            this.connection.unlock();
        }
    }

    @Override
    public Result<StringBuffer> retrieveToMappingTemplate(IHowIsGoing monitor) throws InterruptedException {
        return this.connection.readToMappingTemplate(this.toTemplate, this.toCacheFile.getFullPath().toString(), monitor);
    }

    @Override
    public StringBuffer updateTOTemplate(StringBuffer updateInputXml, IHowIsGoing monitor, Result<StringBuffer> result) throws InterruptedException {
        logger.trace((Object)("updating TO template. new XML contents: " + String.valueOf(updateInputXml)));
        return this.connection.updateTOTemplate(updateInputXml, monitor, result);
    }

    @Override
    public Result<StringBuffer> generateMapping(IHowIsGoing monitor) {
        return this.connection.sendGenMapCommand(monitor);
    }

    @Override
    public StringBuffer getTOTemplate(IHowIsGoing monitor, Result<StringBuffer> result) throws InterruptedException {
        return this.connection.getTemplateXML2Data(monitor, result);
    }

    @Override
    public void closeConnection() {
        if (this.connection == null) {
            return;
        }
        this.connection.forceConnectionClose();
    }

    @Override
    public void end(IHowIsGoing monitor) {
        if (this.connection == null) {
            return;
        }
        this.connection.sessionQuit(monitor);
        this.connection.unlock();
    }

    @Override
    public Result<StringBuffer> save(IHowIsGoing monitor) throws InterruptedException {
        logger.trace((Object)"saving the current template.");
        return this.connection.sessionSave(monitor);
    }

    @Override
    public Result<StringBuffer> saveTO(IHowIsGoing monitor) throws InterruptedException {
        logger.trace((Object)"saving the current To template.");
        return this.connection.sessionSave(monitor);
    }

    public String toString() {
        return "Template Edit Session - " + DateFormat.getInstance().format(this.started);
    }

    @Override
    public IZRL getFromTemplate() {
        return this.fromTemplate;
    }

    @Override
    public IZRL getToTemplate() {
        return this.toTemplate;
    }

    @Override
    public Result<StringBuffer> retrieveSupportedCcsids(IHowIsGoing monitor) throws InterruptedException {
        if (this.connection == null) {
            Result result = new Result(8);
            result.add(Messages.SessionTemplate_0);
            return result;
        }
        return this.connection.getSupportedCcsid(monitor);
    }
}

