/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fm.core.model;

import com.ibm.etools.fm.core.Messages;
import com.ibm.etools.fm.core.model.AbstractSessionFormatted;
import com.ibm.etools.fm.core.model.BaseEditorOptions;
import com.ibm.etools.fm.core.model.FMHost;
import com.ibm.etools.fm.core.model.db2.Db2EditOptions;
import com.ibm.etools.fm.core.model.ims.ImsEditorOptions;
import com.ibm.etools.fm.core.model.ims.ImsSegmentsInformation;
import com.ibm.etools.fm.core.model.ims.ImsSubsystemConfig;
import com.ibm.etools.fm.core.socket.io.CommonConnectionFM;
import com.ibm.etools.fm.core.socket.io.ConnPoolManagerFM;
import com.ibm.etools.fm.core.socket.io.RemoteToken;
import com.ibm.etools.fm.core.socket.io.ZosConnectionFM;
import com.ibm.etools.fm.editor.formatted.FMEditSessionProperties;
import com.ibm.etools.fm.jhost.core.model.FMHostJhost;
import com.ibm.etools.fm.jhost.core.version.FMFeature;
import com.ibm.etools.fm.model.formatted.RecType;
import com.ibm.pdtools.common.component.core.logging.PDLogger;
import com.ibm.pdtools.common.component.core.util.PDFileSystemUtil;
import com.ibm.pdtools.common.component.core.util.PDUtils;
import com.ibm.pdtools.common.component.jhost.comms.CommunicationException;
import com.ibm.pdtools.common.component.jhost.core.model.IHostProviderName;
import com.ibm.pdtools.common.component.jhost.core.model.IPDConnectEndpoint;
import com.ibm.pdtools.common.component.jhost.core.model.IPDHost;
import com.ibm.pdtools.common.component.jhost.core.model.IZRL;
import com.ibm.pdtools.common.component.jhost.core.model.Result;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import com.ibm.pdtools.common.component.jhost.version.PDFeature;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Objects;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class SessionFormatted
extends AbstractSessionFormatted {
    public static final String COPYRIGHT_STATEMENT_DO_NOT_REMOVE = "\u00a9 Copyright HCL Technologies Ltd. 2017, 2021. All rights reserved. \u00a9 Copyright IBM Corp. 2013, 2017. All rights reserved.";
    private static PDLogger logger = PDLogger.get(SessionFormatted.class);
    private Date started = new Date();
    private ZosConnectionFM connection;
    private AbstractSessionFormatted.SessionType sessionType;
    private BaseEditorOptions baseOptions;
    private Db2EditOptions db2Options;
    private ImsEditorOptions imsOptions;
    private ImsSegmentsInformation imsSegInfo;
    private IFile cacheFile;
    private IFile templateCacheFile;
    private FMEditSessionProperties props;
    private final int hashcode;

    protected SessionFormatted(BaseEditorOptions baseOptions, FMEditSessionProperties props) {
        super(baseOptions.getaResource().getSystem(), (IPDConnectEndpoint)FMHost.getSystem((IPDHost)baseOptions.getaResource().getSystem()));
        if (props == null || baseOptions.getaResource() == null) {
            throw new NullPointerException();
        }
        if (baseOptions.getaTemplate() != null && !baseOptions.getaResource().getSystem().equals(baseOptions.getaTemplate().getSystem())) {
            try {
                if (!FMHostJhost.isRMSupportedBetween((IPDHost)baseOptions.getaResource().getSystem(), (IPDHost)baseOptions.getaTemplate().getSystem(), (IHowIsGoing)PDUtils.convertIprogressToIHowIsGoing((IProgressMonitor)new NullProgressMonitor()))) {
                    throw new IllegalArgumentException("Resource to edit and template are on different systems and remote services between the selected systems is not supported!");
                }
            }
            catch (CommunicationException | InterruptedException e) {
                logger.error((Object)"Error occurred while attempting to determine if different systems are compatible for RM support!", e);
                throw new IllegalArgumentException(e);
            }
        }
        this.baseOptions = baseOptions;
        this.props = props;
        this.hashcode = baseOptions.getaResource().hashCode() + (baseOptions.getaTemplate() != null ? baseOptions.getaTemplate().hashCode() : 0) + (baseOptions.isEditSession() ? 1 : 0);
        this.sessionType = AbstractSessionFormatted.SessionType.BASE;
    }

    protected SessionFormatted(Db2EditOptions db2Options, FMEditSessionProperties props) {
        super(db2Options.getTable().getSystem(), db2Options.getSubsystem());
        if (props == null || db2Options.getTable() == null) {
            throw new NullPointerException();
        }
        if (db2Options.getTemplate() != null && !db2Options.getTable().getSystem().equals(db2Options.getTemplate().getSystem())) {
            throw new IllegalArgumentException("Resource to edit and template are on different systems!");
        }
        this.db2Options = db2Options;
        this.props = props;
        this.hashcode = db2Options.getTable().hashCode() + (db2Options.getTemplate() != null ? db2Options.getTemplate().hashCode() : 0) + (db2Options.isEdit() ? 1 : 0);
        this.sessionType = AbstractSessionFormatted.SessionType.DB2;
    }

    protected SessionFormatted(ImsEditorOptions imsOptions, FMEditSessionProperties props) {
        super(imsOptions.getSystem(), imsOptions.getSubsystem());
        this.imsOptions = imsOptions;
        this.props = props;
        ImsSubsystemConfig canonicalConfig = imsOptions.getSubsystem().getCanonicalConfig();
        this.hashcode = canonicalConfig.getLabel().hashCode() + (imsOptions.getTemplate() != null ? imsOptions.getTemplate().hashCode() : 0) + (imsOptions.isEditSession() ? 1 : 0);
        this.sessionType = AbstractSessionFormatted.SessionType.IMS;
    }

    public int hashCode() {
        return this.hashcode;
    }

    public boolean equals(Object obj) {
        if (this.sessionType == AbstractSessionFormatted.SessionType.BASE) {
            if (obj instanceof SessionFormatted) {
                SessionFormatted otherSession = (SessionFormatted)((Object)obj);
                if (this.baseOptions.getaTemplate() == null) {
                    if (otherSession.baseOptions.getaTemplate() != null) {
                        return false;
                    }
                    return otherSession.baseOptions.getaResource().equals(this.baseOptions.getaResource()) && otherSession.baseOptions.isEditSession() == this.baseOptions.isEditSession();
                }
                if (otherSession.baseOptions.getaTemplate() == null) {
                    return false;
                }
                return otherSession.baseOptions.getaResource().equals(this.baseOptions.getaResource()) && otherSession.baseOptions.getaTemplate().equals(this.baseOptions.getaTemplate()) && otherSession.baseOptions.isEditSession() == this.baseOptions.isEditSession();
            }
            return false;
        }
        if (this.sessionType == AbstractSessionFormatted.SessionType.DB2) {
            if (obj instanceof SessionFormatted) {
                SessionFormatted otherSession = (SessionFormatted)((Object)obj);
                if (this.db2Options.getTemplate() == null) {
                    if (otherSession.db2Options.getTemplate() != null) {
                        return false;
                    }
                    return otherSession.db2Options.getTable().equals(this.db2Options.getTable()) && otherSession.db2Options.isEdit() == this.db2Options.isEdit();
                }
                if (otherSession.db2Options.getTemplate() == null) {
                    return false;
                }
                return otherSession.db2Options.getTable().equals(this.db2Options.getTable()) && otherSession.db2Options.getTemplate().equals(this.db2Options.getTemplate()) && otherSession.db2Options.isEdit() == this.db2Options.isEdit();
            }
            return false;
        }
        if (this.sessionType == AbstractSessionFormatted.SessionType.IMS) {
            if (obj instanceof SessionFormatted) {
                SessionFormatted otherSession = (SessionFormatted)((Object)obj);
                return !this.imsOptions.equals(otherSession.imsOptions);
            }
            return false;
        }
        return false;
    }

    @Override
    public boolean isEditingEnabled() {
        if (this.sessionType == AbstractSessionFormatted.SessionType.BASE) {
            return this.baseOptions.isEditSession();
        }
        if (this.sessionType == AbstractSessionFormatted.SessionType.DB2) {
            return this.db2Options.isEdit();
        }
        if (this.sessionType == AbstractSessionFormatted.SessionType.IMS) {
            return this.imsOptions.isEditSession();
        }
        return false;
    }

    public String toString() {
        return "Formatted Edit Session - " + DateFormat.getInstance().format(this.started);
    }

    @Override
    public Result<StringBuffer> startBase(IHowIsGoing monitor, String editSessionInitParms) throws InterruptedException {
        logger.trace((Object)("Starting formatted edit session with target " + this.baseOptions.getaResource().getFormattedName() + " and template " + (this.baseOptions.getaTemplate() == null ? "nothing" : this.baseOptions.getaTemplate().getFormattedName())));
        Result result = new Result((Object)new StringBuffer());
        try {
            this.cacheFile = PDFileSystemUtil.getLocalCacheFile((String)"FM", (IHostProviderName)this.baseOptions.getaResource(), (String)"", (String)".fme");
            this.connection = this.baseOptions.getaTemplate() != null && !this.baseOptions.getaResource().getSystem().isSameSystem(this.baseOptions.getaTemplate().getSystem()) ? (ZosConnectionFM)RemoteToken.getRMPrefix(this.baseOptions.getaResource().getSystem(), this.baseOptions.getaTemplate().getSystem(), monitor).getConnection() : (ZosConnectionFM)ConnPoolManagerFM.instance().getConnection(this.getSystem(), this.getEndpoint(), this.baseOptions.getPDContext(), monitor);
            this.connection.startEditSession(this.baseOptions, this.props, editSessionInitParms, (Result<StringBuffer>)result, monitor);
            return result;
        }
        catch (InterruptedException ie) {
            if (this.connection != null) {
                this.connection.unlock();
            }
            throw ie;
        }
        catch (Exception e) {
            String errMsg = "Exception while starting a Base edit session.";
            result.add(errMsg);
            result.add((Throwable)e);
            logger.error((Object)errMsg, (Throwable)e);
            if (this.connection != null) {
                this.connection.unlock();
            }
            return result;
        }
    }

    @Override
    public Result<StringBuffer> startBase(IHowIsGoing monitor, String editSessionInitParms, String xmlBuffer) throws InterruptedException {
        logger.trace((Object)("Starting formatted edit session with target " + this.baseOptions.getaResource().getFormattedName() + " and template " + (this.baseOptions.getaTemplate() == null ? "nothing" : this.baseOptions.getaTemplate().getFormattedName())));
        Result result = new Result((Object)new StringBuffer());
        try {
            this.cacheFile = PDFileSystemUtil.getLocalCacheFile((String)"FM", (IHostProviderName)this.baseOptions.getaResource(), (String)"", (String)".fme");
            this.connection = this.baseOptions.getaTemplate() != null && !this.baseOptions.getaResource().getSystem().isSameSystem(this.baseOptions.getaTemplate().getSystem()) ? (ZosConnectionFM)RemoteToken.getRMPrefix(this.baseOptions.getaResource().getSystem(), this.baseOptions.getaTemplate().getSystem(), monitor).getConnection() : (ZosConnectionFM)ConnPoolManagerFM.instance().getConnection(this.getSystem(), this.getEndpoint(), this.baseOptions.getPDContext(), monitor);
            this.connection.startEditSession(this.baseOptions, this.props, editSessionInitParms, xmlBuffer, (Result<StringBuffer>)result, monitor);
            return result;
        }
        catch (InterruptedException ie) {
            if (this.connection != null) {
                this.connection.unlock();
            }
            throw ie;
        }
        catch (Exception e) {
            String errMsg = "Exception while starting a Base edit session.";
            result.add(errMsg);
            result.add((Throwable)e);
            logger.error((Object)errMsg, (Throwable)e);
            if (this.connection != null) {
                this.connection.unlock();
            }
            return result;
        }
    }

    @Override
    public Result<StringBuffer> startDB2Session(IHowIsGoing monitor) throws InterruptedException {
        Result result = new Result((Object)new StringBuffer());
        try {
            this.cacheFile = PDFileSystemUtil.getLocalCacheFile((String)"FM", (IHostProviderName)this.db2Options.getTable(), (String)"", (String)".fme");
            this.connection = (ZosConnectionFM)ConnPoolManagerFM.instance().getConnection(this.db2Options.getTable().getSubsystem().getSystem(), this.db2Options.getTable().getSubsystem(), monitor);
            return this.connection.startEdit2Session(this.db2Options, this.props, monitor);
        }
        catch (InterruptedException ie) {
            if (this.connection != null) {
                this.connection.unlock();
            }
            throw ie;
        }
        catch (Exception e) {
            String errMsg = "Exception while starting a DB2 edit session.";
            result.add(errMsg);
            result.add((Throwable)e);
            logger.error((Object)errMsg, (Throwable)e);
            if (this.connection != null) {
                this.connection.unlock();
            }
            return result;
        }
    }

    @Override
    public Result<StringBuffer> createIMSEditSession(IHowIsGoing monitor) throws InterruptedException {
        Result result = new Result((Object)new StringBuffer());
        try {
            this.cacheFile = PDFileSystemUtil.getLocalCacheFile((String)"FM", (IHostProviderName)this.imsOptions.getImsResource(), (String)"", (String)".fme1");
            this.connection = (ZosConnectionFM)ConnPoolManagerFM.instance().getConnection(this.imsOptions.getSystem(), this.imsOptions.getSubsystem(), monitor);
            return result;
        }
        catch (InterruptedException ie) {
            if (this.connection != null) {
                this.connection.unlock();
            }
            throw ie;
        }
        catch (Exception e) {
            String errMsg = "Exception while starting a IMS edit session.";
            result.add(errMsg);
            result.add((Throwable)e);
            logger.error((Object)errMsg, (Throwable)e);
            if (this.connection != null) {
                this.connection.unlock();
            }
            return result;
        }
    }

    @Override
    public Result<StringBuffer> startIMSEditSession(IHowIsGoing monitor) throws InterruptedException {
        try {
            return this.connection.startEdit1Session(this.imsOptions, this.props, monitor);
        }
        catch (InterruptedException ie) {
            if (this.connection != null) {
                this.connection.unlock();
            }
            throw ie;
        }
        catch (Exception e) {
            Result result = new Result((Object)new StringBuffer());
            String errMsg = "Exception while starting a IMS edit session.";
            result.add(errMsg);
            result.add((Throwable)e);
            logger.error((Object)errMsg, (Throwable)e);
            if (this.connection != null) {
                this.connection.unlock();
            }
            return result;
        }
    }

    @Override
    public ImsSegmentsInformation getImsSegInfo() {
        return this.imsSegInfo;
    }

    @Override
    public void setImsSegInfo(ImsSegmentsInformation segInfo) {
        this.imsSegInfo = segInfo;
    }

    @Override
    public IFile getCacheFile() {
        return this.cacheFile;
    }

    @Override
    public void removeCacheFile(IHowIsGoing monitor) {
        if (this.cacheFile != null && this.cacheFile.exists()) {
            try {
                this.cacheFile.refreshLocal(1, (IProgressMonitor)monitor.getMonitor());
                this.cacheFile.delete(true, (IProgressMonitor)monitor.getMonitor());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.templateCacheFile != null && this.templateCacheFile.exists()) {
            try {
                this.templateCacheFile.refreshLocal(1, (IProgressMonitor)monitor.getMonitor());
                this.templateCacheFile.delete(true, (IProgressMonitor)monitor.getMonitor());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public IFile getAssociatedTemplate(IHowIsGoing monitor) throws InterruptedException {
        try {
            if (this.connection == null) {
                throw new IllegalStateException("Must start a connection before getting template.");
            }
            if (this.sessionType == AbstractSessionFormatted.SessionType.BASE) {
                this.templateCacheFile = PDFileSystemUtil.getLocalCacheFile((String)"FM", (IHostProviderName)this.baseOptions.getaTemplate(), (String)"editor-", (String)".fmt");
                Result result = this.connection.editTemplateRetrieve(this.baseOptions.getaTemplate(), this.templateCacheFile.getLocation().toString(), monitor);
                if (!result.isSuccessfulWithoutWarnings()) {
                    return null;
                }
                return this.templateCacheFile;
            }
            if (this.sessionType == AbstractSessionFormatted.SessionType.DB2) {
                this.templateCacheFile = PDFileSystemUtil.getLocalCacheFile((String)"FM", (IHostProviderName)this.db2Options.getTemplate(), (String)"editor-", (String)".fmt2");
                Result result = this.connection.editTemplateRetrieve(this.db2Options.getTemplate(), this.templateCacheFile.getLocation().toString(), monitor);
                if (!result.isSuccessfulWithoutWarnings()) {
                    return null;
                }
                return this.templateCacheFile;
            }
            if (this.sessionType != AbstractSessionFormatted.SessionType.IMS) {
                return null;
            }
            this.templateCacheFile = PDFileSystemUtil.getLocalCacheFile((String)"FM", (IHostProviderName)this.imsOptions.getTemplate(), (String)"editor-", (String)".fmt1");
            Result result = this.connection.editTemplateRetrieve((IZRL)this.imsOptions.getTemplate(), this.templateCacheFile.getLocation().toString(), monitor);
            if (!result.isSuccessfulWithoutWarnings()) {
                return null;
            }
            return this.templateCacheFile;
        }
        catch (InterruptedException ie) {
            throw ie;
        }
        catch (Exception e) {
            String errMsg = Messages.CommEditFormattedSession_GET_ASSOCIATED_TEMPLATE_EX;
            logger.error((Object)errMsg, (Throwable)e);
            return null;
        }
    }

    @Override
    public Result<StringBuffer> sendCommand(String command, String additionalData, IHowIsGoing monitor) throws InterruptedException {
        logger.trace((Object)("Sending formatted editor command [" + command + "]."));
        Result result = new Result((Object)new StringBuffer());
        try {
            if (!this.connection.sendEditorCommand(command, additionalData, result, monitor)) {
                logger.debug((Object)("Command '" + command + "' failed"));
                return result;
            }
            return result;
        }
        catch (InterruptedException ie) {
            throw ie;
        }
        catch (Exception e) {
            result.add((Throwable)e);
            return result;
        }
    }

    @Override
    public Result<StringBuffer> requestLayoutChange(int layoutID, IHowIsGoing monitor) throws InterruptedException {
        logger.trace((Object)("Requesting template layout change. New ID is " + layoutID));
        try {
            return this.connection.requestLayoutChange(layoutID, monitor);
        }
        catch (InterruptedException ie) {
            throw ie;
        }
        catch (Exception e) {
            Result err = new Result((Object)new StringBuffer());
            err.add((Throwable)e);
            return err;
        }
    }

    @Override
    public Result<StringBuffer> setCursorPosition(IHowIsGoing monitor, RecType startRec, String defaultToken) throws InterruptedException {
        Objects.requireNonNull(defaultToken, "Please specify a non-null default token.");
        String token = "";
        int sequenceNo = 0;
        int segmentNo = 0;
        if (startRec == null) {
            token = defaultToken;
        } else {
            token = startRec.getToken();
            if (startRec.isSetSeq()) {
                sequenceNo = startRec.getSeq();
            }
            if (startRec.isSetSeg()) {
                segmentNo = startRec.getSeg();
            }
        }
        logger.trace((Object)("Setting cursor location to token [" + token + "] sequence no: " + sequenceNo + " segment no" + segmentNo));
        String command = "LOCTOK  " + token;
        String sequenceSpec = "," + sequenceNo;
        String segmentSpec = "," + segmentNo;
        IPDHost currentHost = null;
        currentHost = this.sessionType == AbstractSessionFormatted.SessionType.BASE ? this.baseOptions.getaResource().getSystem() : (this.sessionType == AbstractSessionFormatted.SessionType.DB2 ? this.db2Options.getSystem() : this.imsOptions.getSystem());
        if (currentHost.supports((PDFeature)FMFeature.NEW_STYLE_LOCKTOK)) {
            return this.sendCommand("LOCTOK DUMMY" + sequenceSpec + segmentSpec, token, monitor);
        }
        return this.sendCommand(command + sequenceSpec + segmentSpec, null, monitor);
    }

    @Override
    public Result<StringBuffer> setCursorPositionToTop(IHowIsGoing monitor) throws InterruptedException {
        logger.trace((Object)"Attempting to set cursor position to top");
        return this.sendCommand("TOP", null, monitor);
    }

    @Override
    public Result<StringBuffer> setCursorPositionToBottom(IHowIsGoing monitor, int stepSize) throws InterruptedException {
        logger.trace((Object)"Attempting to set cursor position to bottom");
        Result<StringBuffer> result = this.sendCommand("BOTTOM", null, monitor);
        if (result.getRC() >= 8) {
            return result;
        }
        logger.trace((Object)("BOT command successful. Moving up by " + stepSize));
        return this.sendCommand("UP " + stepSize, null, monitor);
    }

    @Override
    public FMEditSessionProperties getProperties(IHowIsGoing monitor) {
        return this.props;
    }

    @Override
    public IFile readRecords(IHowIsGoing monitor, Result<StringBuffer> result, int stepSize) throws InterruptedException {
        block4: {
            Objects.requireNonNull(result, "Please provide a non-null result object to hold result of reading records.");
            logger.trace((Object)("Reading " + stepSize + " records from " + (this.sessionType == AbstractSessionFormatted.SessionType.BASE ? this.baseOptions.getaResource().getFormattedName() : (this.sessionType == AbstractSessionFormatted.SessionType.DB2 ? this.db2Options.getTable().getFormattedName() : this.imsOptions.getImsResource().getFormattedName()))));
            Result aResult = this.connection.readNextRecordsFromEditSession(this.cacheFile.getLocation().toString(), Integer.toString(stepSize), monitor);
            if (aResult.getRC() <= 4) break block4;
            result.copy(aResult);
            return null;
        }
        try {
            logger.trace((Object)"Finished reading records.");
            return this.cacheFile;
        }
        catch (InterruptedException ie) {
            throw ie;
        }
        catch (Exception e) {
            result.add((Throwable)e);
            return null;
        }
    }

    @Override
    public Result<StringBuffer> readRecords(IHowIsGoing monitor, StringBuilder aBuffer, int stepSize) throws InterruptedException {
        logger.trace((Object)("Reading " + stepSize + " records from " + (this.sessionType == AbstractSessionFormatted.SessionType.BASE ? this.baseOptions.getaResource().getFormattedName() : this.db2Options.getTable().getFormattedName())));
        try {
            return this.connection.readNextRecordsFromEditSession(aBuffer, Integer.toString(stepSize), monitor);
        }
        catch (InterruptedException ie) {
            throw ie;
        }
        catch (Exception e) {
            String errMsg = MessageFormat.format(Messages.SessionFormatted_0, this.sessionType == AbstractSessionFormatted.SessionType.BASE ? this.baseOptions.getaResource().getFormattedName() : this.db2Options.getTable().getFormattedName());
            Result errResult = new Result();
            errResult.setRC(8);
            errResult.add(errMsg);
            errResult.add((Throwable)e);
            return errResult;
        }
    }

    @Override
    public boolean updateRecordsInHexInEditSession(StringBuffer recsToUpdate, int noOfRecs, IHowIsGoing monitor, Result<StringBuffer> overallResult) throws InterruptedException {
        block4: {
            logger.trace((Object)("updating " + noOfRecs + " records in hex. XML [" + String.valueOf(recsToUpdate) + "]"));
            Objects.requireNonNull(recsToUpdate, "Please specify non-null recsToUpdate");
            if (this.getSessionType() != AbstractSessionFormatted.SessionType.IMS) break block4;
            this.connection.updateRecordsInHexInEditSessionForIms(recsToUpdate.toString(), monitor, overallResult);
            return true;
        }
        try {
            this.connection.updateRecordsInHexInEditSession(recsToUpdate.toString(), noOfRecs, monitor, overallResult);
            return true;
        }
        catch (InterruptedException ie) {
            throw ie;
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            return false;
        }
    }

    @Override
    public Result<StringBuffer> prepareNewFormattedRecordsInEditSession(StringBuffer recsToInsert, int noOfRecs, IHowIsGoing monitor) throws InterruptedException {
        logger.trace((Object)("Inserting " + noOfRecs + " new records in the formatted mode."));
        try {
            return this.connection.insertFormattedRecordsInEditSession(recsToInsert.toString(), noOfRecs, monitor);
        }
        catch (InterruptedException ie) {
            throw ie;
        }
        catch (Exception e) {
            Result err = new Result((Object)new StringBuffer());
            err.add(Messages.CommEditFormattedSession_INSERT_NEW_FORMATTED_ERR);
            err.add((Throwable)e);
            return err;
        }
    }

    @Override
    public Result<StringBuffer> checkFormattedRecordsEditSession(StringBuffer recsToCheck, int noOfRecs, IHowIsGoing monitor) throws InterruptedException {
        logger.trace((Object)("Checking " + noOfRecs + " updated records. XML [" + String.valueOf(recsToCheck) + "]"));
        try {
            return this.connection.validateFormattedRecordsInEditSession(recsToCheck.toString(), noOfRecs, monitor);
        }
        catch (InterruptedException ie) {
            throw ie;
        }
        catch (Exception e) {
            Result resultStringBuffer = new Result((Throwable)e);
            resultStringBuffer.setOutput((Object)new StringBuffer());
            return resultStringBuffer;
        }
    }

    @Override
    public Result<StringBuffer> saveAs(IZRL newTarget, IHowIsGoing monitor) throws InterruptedException {
        Objects.requireNonNull(this.connection, "Attempted to save as before starting edit session.");
        return this.connection.sessionSaveAs(newTarget, monitor);
    }

    @Override
    public IFile readAllBytes(IHowIsGoing monitor, Result<StringBuffer> result) throws InterruptedException {
        Result aResult;
        IFile tmpFile;
        block5: {
            logger.trace((Object)"Reading all bytes from the current edit session.");
            Objects.requireNonNull(result, "Please provide a non-null result object to hold result of reading.");
            IZRL aTarget = this.sessionType == AbstractSessionFormatted.SessionType.BASE ? this.baseOptions.getaResource() : this.db2Options.getTable();
            tmpFile = PDFileSystemUtil.getLocalCacheFile((String)"FM", (IHostProviderName)aTarget, (String)"", (String)".fme");
            aResult = this.sendCommand("LOCATE 1", null, monitor);
            if (aResult.isSuccessfulWithoutWarnings()) break block5;
            result.copy(aResult);
            return null;
        }
        try {
            aResult = this.connection.readNextRecordsFromEditSession(tmpFile.getLocation().toString(), "ALL", monitor);
            result.copy(aResult);
            if (aResult.isSuccessfulWithoutWarnings()) {
                return tmpFile;
            }
            return null;
        }
        catch (InterruptedException ie) {
            throw ie;
        }
        catch (Exception e) {
            result.add((Throwable)e);
            return null;
        }
    }

    @Override
    public AbstractSessionFormatted.SessionType getSessionType() {
        return this.sessionType;
    }

    @Override
    public BaseEditorOptions getBaseEditOptions() {
        return this.baseOptions;
    }

    @Override
    public Db2EditOptions getDb2EditOptions() {
        return this.db2Options;
    }

    @Override
    public ImsEditorOptions getImsEditOptions() {
        return this.imsOptions;
    }

    @Override
    public void end(IHowIsGoing monitor) {
        if (this.connection == null) {
            return;
        }
        this.connection.sessionQuit(monitor);
        this.connection.unlock();
    }

    @Override
    public void file(IHowIsGoing monitor) {
        Objects.requireNonNull(this.connection, "Attempted to file before starting edit session.");
        this.connection.sessionFile(monitor);
        this.connection.unlock();
    }

    @Override
    public Result<StringBuffer> save(IHowIsGoing monitor) throws InterruptedException {
        Objects.requireNonNull(this.connection, "Attempted to save before starting edit session.");
        return this.connection.sessionSave(monitor);
    }

    @Override
    public Result<StringBuffer> getCompilerListing(IHowIsGoing monitor, IFile listingFile) throws InterruptedException {
        logger.trace((Object)"Getting compiler listing for the current formatted edit session.");
        Objects.requireNonNull(this.connection, "Attempted to get compiler listing before starting edit session.");
        Result result = new Result((Object)new StringBuffer());
        this.connection.getCompilerListing((Result<StringBuffer>)result, listingFile, monitor);
        return result;
    }

    @Override
    public Result<StringBuffer> getImsKeyPosition(IHowIsGoing monitor) throws InterruptedException {
        return this.connection.getImsKeyPosition(monitor);
    }

    @Override
    public Result<StringBuffer> setImsKeyPosition(String xmlKeyPosSpec, IHowIsGoing monitor) throws InterruptedException {
        Objects.requireNonNull(this.connection, "Attempted to set IMS Key position before starting edit session.");
        return this.connection.setImsKeyPosition(xmlKeyPosSpec, monitor);
    }

    @Override
    public CommonConnectionFM getConnection() {
        return this.connection;
    }
}

